/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.function;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.function.Consumer;
import org.jhotdraw8.css.function.AbstractCssFunction;
import org.jhotdraw8.css.function.CssFunction;
import org.jhotdraw8.css.manager.CssFunctionProcessor;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.parser.ListCssTokenizer;
import org.jhotdraw8.css.value.QualifiedName;
import org.jspecify.annotations.Nullable;

public class AttrCssFunction<T>
extends AbstractCssFunction<T> {
    public static final String NAME = "attr";

    public AttrCssFunction() {
        super(NAME);
    }

    public AttrCssFunction(String name) {
        super(name);
    }

    @Override
    public void process(T element, CssTokenizer tt, SelectorModel<T> model, CssFunctionProcessor<T> functionProcessor, Consumer<CssToken> out, Deque<CssFunction<T>> recursionStack) throws IOException, ParseException {
        tt.requireNextToken(-18, this.getName() + "():  function " + this.getName() + "() expected.");
        if (!this.getName().equals(tt.currentString())) {
            throw tt.createParseException(this.getName() + "():  function " + this.getName() + "() expected.");
        }
        int line = tt.getLineNumber();
        int start = tt.getStartPosition();
        QualifiedName attrName = this.parseAttrName(tt);
        String typeOrUnit = null;
        ArrayList<CssToken> attrFallback = new ArrayList<CssToken>();
        if (tt.next() == 37) {
            typeOrUnit = "%";
        } else if (tt.current() == -2) {
            typeOrUnit = tt.currentString();
        } else {
            tt.pushBack();
        }
        if (tt.next() == 44) {
            while (tt.nextNoSkip() != -1 && tt.current() != 41) {
                if (tt.current() == -16 && attrFallback.isEmpty()) continue;
                attrFallback.add(tt.getToken());
            }
            while (!attrFallback.isEmpty() && ((CssToken)attrFallback.getLast()).getType() == -16) {
                attrFallback.removeLast();
            }
        }
        if (tt.current() != 41) {
            throw new ParseException(this.getName() + "():  right bracket expected. " + tt.current(), tt.getStartPosition());
        }
        int end = tt.getEndPosition();
        this.applyFunction(element, model, functionProcessor, out, recursionStack, line, start, attrName, typeOrUnit, attrFallback, end);
    }

    private void applyFunction(T element, SelectorModel<T> model, CssFunctionProcessor<T> functionProcessor, Consumer<CssToken> out, Deque<CssFunction<T>> recursionStack, int line, int start, QualifiedName attrName, String typeOrUnit, List<CssToken> attrFallback, int end) throws IOException, ParseException {
        @Nullable List<CssToken> tokenizedValue = model.getAttribute(element, null, attrName.namespace(), attrName.name());
        if (tokenizedValue != null) {
            switch (typeOrUnit == null ? "string" : typeOrUnit) {
                default: {
                    if (this.applyAsString(element, model, out, line, start, attrName, end)) {
                        return;
                    }
                    if (!attrFallback.isEmpty()) break;
                    attrFallback = List.of(new CssToken(-4, ""));
                    break;
                }
                case "color": {
                    if (!attrFallback.isEmpty()) break;
                    attrFallback = List.of(new CssToken(-2, "currentcolor"));
                    break;
                }
                case "url": {
                    if (!attrFallback.isEmpty()) break;
                    attrFallback = List.of(new CssToken(-12, "about:invalid"));
                    break;
                }
                case "em": 
                case "ex": 
                case "px": 
                case "rem": 
                case "vw": 
                case "vh": 
                case "vmin": 
                case "vmax": 
                case "mm": 
                case "cm": 
                case "in": 
                case "pt": 
                case "pc": {
                    if (this.applyAsLengthInTheGivenUnits(out, line, start, typeOrUnit, end, tokenizedValue)) {
                        return;
                    }
                    if (!attrFallback.isEmpty()) break;
                    attrFallback = List.of(new CssToken(-11, 0, typeOrUnit));
                    break;
                }
                case "integer": 
                case "number": {
                    if (this.applyAsNumber(out, line, start, typeOrUnit, end, tokenizedValue)) {
                        return;
                    }
                    if (!attrFallback.isEmpty()) break;
                    attrFallback = List.of(new CssToken(-9, 0, typeOrUnit));
                    break;
                }
                case "length": {
                    if (this.applyAsLength(out, line, start, typeOrUnit, end, tokenizedValue)) {
                        return;
                    }
                    if (!attrFallback.isEmpty()) break;
                    attrFallback = List.of(new CssToken(-9, 0, typeOrUnit));
                    break;
                }
                case "%": {
                    if (this.applyAsPercentage(out, line, start, typeOrUnit, end, tokenizedValue)) {
                        return;
                    }
                    if (!attrFallback.isEmpty()) break;
                    attrFallback = List.of(new CssToken(-9, 0, typeOrUnit));
                }
                case "angle": 
                case "time": 
                case "frequency": 
            }
        }
        recursionStack.push(this);
        functionProcessor.processToken(element, new ListCssTokenizer(attrFallback.isEmpty() ? Collections.singletonList(new CssToken(-2, "none")) : attrFallback), out, recursionStack);
        recursionStack.pop();
    }

    private boolean applyAsPercentage(Consumer<CssToken> out, int line, int start, String typeOrUnit, int end, List<CssToken> tokenizedValue) {
        ListCssTokenizer t2 = new ListCssTokenizer(tokenizedValue);
        while (t2.next() != -1) {
            switch (t2.current()) {
                case -4: 
                case -2: {
                    double d;
                    try {
                        d = Double.parseDouble(t2.currentStringNonNull());
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                    out.accept(new CssToken(-10, null, d, line, start, end));
                    return true;
                }
                case -11: 
                case -10: 
                case -9: {
                    out.accept(new CssToken(-10, null, t2.currentNumberNonNull(), line, start, end));
                    return true;
                }
            }
        }
        return false;
    }

    private boolean applyAsLength(Consumer<CssToken> out, int line, int start, String typeOrUnit, int end, List<CssToken> tokenizedValue) {
        ListCssTokenizer t2 = new ListCssTokenizer(tokenizedValue);
        if (t2.next() == -1) {
            return false;
        }
        t2.pushBack();
        while (t2.next() != -1) {
            switch (t2.current()) {
                case -4: 
                case -2: {
                    double d;
                    try {
                        d = Double.parseDouble(t2.currentStringNonNull());
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                    out.accept(new CssToken(-11, "", d, line, start, end));
                    return true;
                }
                case -11: 
                case -9: {
                    out.accept(new CssToken(-11, t2.currentString() == null ? "" : t2.currentString(), t2.currentNumberNonNull(), line, start, end));
                    return true;
                }
                case -10: {
                    out.accept(new CssToken(-11, "", t2.currentNumberNonNull().doubleValue() * 100.0, line, start, end));
                    return true;
                }
            }
        }
        return false;
    }

    private boolean applyAsNumber(Consumer<CssToken> out, int line, int start, String typeOrUnit, int end, List<CssToken> tokenizedValue) {
        ListCssTokenizer t2 = new ListCssTokenizer(tokenizedValue);
        if (t2.next() == -1) {
            return false;
        }
        t2.pushBack();
        while (t2.next() != -1) {
            switch (t2.current()) {
                case -4: 
                case -2: {
                    double d;
                    try {
                        d = Double.parseDouble(t2.currentStringNonNull());
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                    out.accept(new CssToken(-9, null, d, line, start, end));
                    return true;
                }
                case -11: 
                case -10: 
                case -9: {
                    out.accept(new CssToken(-9, null, t2.currentNumberNonNull(), line, start, end));
                    return true;
                }
            }
        }
        return false;
    }

    private boolean applyAsLengthInTheGivenUnits(Consumer<CssToken> out, int line, int start, String typeOrUnit, int end, List<CssToken> tokenizedValue) {
        ListCssTokenizer t2 = new ListCssTokenizer(tokenizedValue);
        if (t2.next() == -1) {
            out.accept(new CssToken(-11, 0, typeOrUnit));
        }
        t2.pushBack();
        while (t2.next() != -1) {
            switch (t2.current()) {
                case -4: 
                case -2: {
                    double d;
                    try {
                        d = Double.parseDouble(t2.currentStringNonNull());
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                    out.accept(new CssToken(-11, typeOrUnit, d, line, start, end));
                    return true;
                }
                case -11: 
                case -9: {
                    out.accept(new CssToken(-11, typeOrUnit, t2.currentNumberNonNull(), line, start, end));
                    return true;
                }
                case -10: {
                    out.accept(new CssToken(-11, typeOrUnit, t2.currentNumberNonNull().doubleValue() * 100.0, line, start, end));
                    return true;
                }
            }
        }
        return false;
    }

    private boolean applyAsString(T element, SelectorModel<T> model, Consumer<CssToken> out, int line, int start, QualifiedName attrName, int end) {
        String attributeAsString = model.getAttributeAsString(element, null, attrName.namespace(), attrName.name());
        if (attributeAsString == null) {
            return false;
        }
        out.accept(new CssToken(-4, attributeAsString, null, line, start, end));
        return true;
    }

    private QualifiedName parseAttrName(CssTokenizer tt) throws IOException, ParseException {
        if (tt.next() != -2) {
            throw new ParseException(this.getName() + "(): attr-name expected.", tt.getStartPosition());
        }
        String name = tt.currentStringNonNull();
        return new QualifiedName(null, name);
    }

    @Override
    public String getHelpText() {
        return this.getName() + "(\u27e8attr-name\u27e9 \u27e8type-or-unit\u27e9, \u27e8fallback\u27e9)\n    Retrieves an attribute value by name and converts it to type-or-unit.\n    If the attribute does not exist or if the conversion fails, the fallback is used. \n    type-or-unit must be one of 'string', 'color', 'url', 'integer', 'number', 'length' 'angle', 'time', 'frequency', '%'.";
    }
}

