/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.function;

import java.io.IOException;
import java.text.ParseException;
import java.util.Deque;
import java.util.function.Consumer;
import org.jhotdraw8.css.function.AbstractMathCssFunction;
import org.jhotdraw8.css.function.CssFunction;
import org.jhotdraw8.css.manager.CssFunctionProcessor;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.value.CssSize;
import org.jspecify.annotations.Nullable;

public class CalcCssFunction<T>
extends AbstractMathCssFunction<T> {
    public static final String NAME = "calc";

    public CalcCssFunction() {
        this(NAME);
    }

    public CalcCssFunction(String name) {
        super(name);
    }

    @Override
    public void process(T element, CssTokenizer tt, SelectorModel<T> model, CssFunctionProcessor<T> functionProcessor, Consumer<CssToken> out, Deque<CssFunction<T>> recursionStack) throws IOException, ParseException {
        int line = tt.getLineNumber();
        int start = tt.getStartPosition();
        CssSize dim = this.parseCalcFunction(element, tt, functionProcessor);
        int end = tt.getEndPosition();
        this.produceNumberPercentageOrDimension(out, dim, line, start, end);
    }

    private @Nullable CssSize parseCalcFunction(T element, CssTokenizer tt, CssFunctionProcessor<T> functionProcessor) throws IOException, ParseException {
        tt.requireNextToken(-18, this.getName() + "(): " + this.getName() + "() function expected.");
        if (!this.getName().equals(tt.currentStringNonNull())) {
            throw new ParseException(this.getName() + "(): " + this.getName() + "() function expected.", tt.getStartPosition());
        }
        CssSize dim = this.parseCalcSum(element, tt, functionProcessor);
        tt.requireNextToken(41, this.getName() + "():  right bracket \")\" expected.");
        return dim;
    }

    @Override
    public String getHelpText() {
        return this.getName() + "(\u27e8expression\u27e9)\n    Computes a mathematical expression with addition (+), subtraction (-), multiplication (*), and division (/).\n    It can be used wherever \u27e8length\u27e9, \u27e8frequency\u27e9, \u27e8angle\u27e9, \u27e8time\u27e9, \u27e8percentage\u27e9, \u27e8number\u27e9, or \u27e8integer\u27e9 values are allowed. ";
    }
}

