/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.function;

import java.io.IOException;
import java.text.ParseException;
import java.util.Deque;
import java.util.function.Consumer;
import org.jhotdraw8.css.function.AbstractStringCssFunction;
import org.jhotdraw8.css.function.CssFunction;
import org.jhotdraw8.css.manager.CssFunctionProcessor;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;

public class ConcatCssFunction<T>
extends AbstractStringCssFunction<T> {
    public static final String NAME = "concat";

    public ConcatCssFunction() {
        super(NAME);
    }

    public ConcatCssFunction(String name) {
        super(name);
    }

    @Override
    public String getHelpText() {
        return this.getName() + "(\u27e8string\u27e9, ...)\n    Concatenates a list of strings.";
    }

    @Override
    public void process(T element, CssTokenizer tt, SelectorModel<T> model, CssFunctionProcessor<T> functionProcessor, Consumer<CssToken> out, Deque<CssFunction<T>> recursionStack) throws IOException, ParseException {
        tt.requireNextToken(-18, this.getName() + "():  concat() function expected.");
        if (!this.getName().equals(tt.currentStringNonNull())) {
            throw new ParseException(this.getName() + "():  concat() function expected.", tt.getStartPosition());
        }
        int line = tt.getLineNumber();
        int start = tt.getStartPosition();
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        block3: while (tt.next() != -1 && tt.current() != 41) {
            switch (tt.current()) {
                case 44: {
                    if (!first) continue block3;
                    tt.pushBack();
                    buf.append(this.evalString(element, tt, this.getName(), functionProcessor));
                    break;
                }
                default: {
                    tt.pushBack();
                    buf.append(this.evalString(element, tt, this.getName(), functionProcessor));
                }
            }
            first = false;
        }
        if (tt.current() != 41) {
            throw new ParseException(this.getName() + "():  right bracket ')' expected.", tt.getStartPosition());
        }
        int end = tt.getEndPosition();
        out.accept(new CssToken(-4, buf.toString(), null, line, start, end));
    }
}

