/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.function;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.text.ParseException;
import java.util.Deque;
import java.util.Objects;
import java.util.function.Consumer;
import org.jhotdraw8.css.function.CalcCssFunction;
import org.jhotdraw8.css.function.CssFunction;
import org.jhotdraw8.css.manager.CssFunctionProcessor;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.DefaultUnitConverter;

public class RoundCssFunction<T>
extends CalcCssFunction<T> {
    public static final String NAME = "round";

    public RoundCssFunction(String name) {
        super(name);
    }

    public RoundCssFunction() {
        this(NAME);
    }

    @Override
    public void process(T element, CssTokenizer tt, SelectorModel<T> model, CssFunctionProcessor<T> functionProcessor, Consumer<CssToken> out, Deque<CssFunction<T>> recursionStack) throws IOException, ParseException {
        CssSize dimB;
        String roundingStrategy;
        int line = tt.getLineNumber();
        int start = tt.getStartPosition();
        tt.requireNextToken(-18, this.getName() + "():  " + this.getName() + "() function expected.");
        if (!this.getName().equals(tt.currentStringNonNull())) {
            throw new ParseException(this.getName() + "():  " + this.getName() + "() function expected.", tt.getStartPosition());
        }
        if (tt.next() == -2) {
            roundingStrategy = tt.currentString();
        } else {
            roundingStrategy = null;
            tt.pushBack();
        }
        CssSize dimA = this.parseCalcValue(element, tt, functionProcessor);
        if (tt.next() == 44) {
            dimB = this.parseCalcValue(element, tt, functionProcessor);
        } else {
            dimB = CssSize.ONE;
            tt.pushBack();
        }
        if (dimB.getUnits().isEmpty()) {
            dimB = CssSize.of(dimB.getValue(), dimA.getUnits());
        }
        tt.requireNextToken(41, this.getName() + "():  right bracket \")\" expected.");
        int end = tt.getEndPosition();
        double valueA = Objects.equals(dimA.getUnits(), dimB.getUnits()) ? dimA.getValue() : dimA.getConvertedValue(DefaultUnitConverter.getInstance(), dimB.getUnits());
        double valueB = dimB.getValue();
        String string = roundingStrategy;
        int n = 0;
        CssSize rounded = CssSize.of(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"up", "down", "to-zero"}, (Object)string, n)) {
            case 0 -> Math.ceil(valueA / valueB) * valueB;
            case 1 -> Math.floor(valueA / valueB) * valueB;
            case 2 -> {
                if (valueA < 0.0) {
                    yield Math.ceil(valueA / valueB) * valueB;
                }
                yield Math.floor(valueA / valueB) * valueB;
            }
            default -> (double)Math.round(valueA / valueB) * valueB;
        }, dimB.getUnits());
        this.produceNumberPercentageOrDimension(out, rounded, line, start, end);
    }

    @Override
    public String getHelpText() {
        return "round(\u27e8value\u27e9)\n    Rounds the specified value.\n    The value can be given as a number, dimension or a percentage.";
    }
}

