/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.parser.StreamCssTokenizer;

public class CssPrettyPrinter
implements Appendable {
    private final Deque<Syntax> stack = new ArrayDeque<Syntax>();
    int indentation = 0;
    private String indenter = "\t";
    private final Appendable w;
    private boolean mustIndent = false;

    public CssPrettyPrinter(Appendable w) {
        this.w = w;
        this.stack.push(Syntax.STYLESHEET);
    }

    @Override
    public CssPrettyPrinter append(CharSequence str) {
        try {
            this.print(str);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    @Override
    public CssPrettyPrinter append(CharSequence csq, int start, int end) {
        this.append(csq.subSequence(start, end));
        return this;
    }

    @Override
    public CssPrettyPrinter append(char c) {
        return this.append("" + c);
    }

    public String getIndenter() {
        return this.indenter;
    }

    public void setIndenter(String indenter) {
        this.indenter = indenter;
    }

    public void print(CharSequence str) throws IOException {
        StreamCssTokenizer tt = new StreamCssTokenizer(str, null);
        this.print(tt);
    }

    public void print(CssTokenizer tt) throws IOException {
        block3: while (tt.nextNoSkip() != -1) {
            CssToken token = tt.getToken();
            int oldsize = this.stack.size();
            this.parseToken(token);
            this.indentation = Math.min(this.stack.size(), oldsize);
            switch (token.getType()) {
                case -16: {
                    if (token.getStringValueNonNull().indexOf(10) < 0) {
                        if (this.mustIndent) continue block3;
                        this.w.append(" ");
                        continue block3;
                    }
                    this.w.append('\n');
                    this.mustIndent = true;
                    continue block3;
                }
            }
            if (this.mustIndent) {
                this.indent();
                this.mustIndent = false;
            }
            this.w.append(token.fromToken());
        }
    }

    private void indent() throws IOException {
        for (int i = 1; i < this.indentation; ++i) {
            this.w.append(this.indenter);
        }
    }

    private void parseToken(CssToken token) {
        switch (token.getType()) {
            case -24: 
            case -23: 
            case -22: 
            case -21: 
            case -20: 
            case -19: 
            case -17: 
            case -16: 
            case -15: 
            case -14: 
            case -13: 
            case -12: 
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -1: 
            case 37: 
            case 43: 
            case 44: 
            case 47: 
            case 124: {
                break;
            }
            case -18: 
            case 40: {
                this.stack.push(Syntax.ROUND_BLOCK);
                break;
            }
            case 123: {
                this.stack.push(Syntax.CURLY_BLOCK);
                break;
            }
            case 91: {
                this.stack.push(Syntax.SQUARE_BLOCK);
                break;
            }
            case 41: {
                while (this.stack.size() > 1 && this.stack.pop() != Syntax.ROUND_BLOCK) {
                }
                break;
            }
            case 125: {
                while (this.stack.size() > 1 && this.stack.pop() != Syntax.CURLY_BLOCK) {
                }
                break;
            }
            case 93: {
                while (this.stack.size() > 1 && this.stack.pop() == Syntax.SQUARE_BLOCK) {
                }
                break;
            }
            case 59: {
                while (this.stack.size() > 1 && this.stack.pop() != Syntax.DECLARATION_VALUE) {
                }
                break;
            }
            case 58: {
                if (this.stack.peek() != Syntax.DECLARATION_KEY) break;
                this.stack.pop();
                this.stack.push(Syntax.DECLARATION_VALUE);
                break;
            }
            case -2: {
                if (this.stack.peek() != Syntax.CURLY_BLOCK) break;
                this.stack.push(Syntax.DECLARATION_KEY);
            }
        }
    }

    private static enum Syntax {
        STYLESHEET,
        SELECTOR,
        DECLARATION_KEY,
        DECLARATION_VALUE,
        ROUND_BLOCK,
        SQUARE_BLOCK,
        CURLY_BLOCK;

    }
}

