/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.manager;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jhotdraw8.css.function.CssFunction;
import org.jhotdraw8.css.manager.CssFunctionProcessor;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.parser.ListCssTokenizer;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;
import org.jspecify.annotations.Nullable;

public class SimpleCssFunctionProcessor<T>
implements CssFunctionProcessor<T> {
    protected SelectorModel<T> model;
    protected @Nullable Map<String, ImmutableList<CssToken>> customProperties;
    private final Map<String, CssFunction<T>> functions;
    private int maxRecursionDepth = 256;

    public SimpleCssFunctionProcessor(List<CssFunction<T>> functions) {
        this(functions, null, null);
    }

    public SimpleCssFunctionProcessor(List<CssFunction<T>> functions, @Nullable SelectorModel<T> model, @Nullable Map<String, @Nullable ImmutableList<CssToken>> customProperties) {
        this.model = model;
        this.customProperties = customProperties;
        this.functions = new LinkedHashMap<String, CssFunction<T>>();
        for (CssFunction<T> function : functions) {
            this.functions.put(function.getName(), function);
        }
    }

    public int getMaxRecursionDepth() {
        return this.maxRecursionDepth;
    }

    public void setMaxRecursionDepth(int maxRecursionDepth) {
        if (maxRecursionDepth < 0) {
            throw new IllegalArgumentException("maxRecursionDepth=" + maxRecursionDepth);
        }
        this.maxRecursionDepth = maxRecursionDepth;
    }

    public SelectorModel<T> getModel() {
        return this.model;
    }

    @Override
    public void setModel(SelectorModel<T> model) {
        this.model = model;
    }

    @Override
    public Map<String, ImmutableList<CssToken>> getCustomProperties() {
        return this.customProperties;
    }

    @Override
    public void setCustomProperties(Map<String, ImmutableList<CssToken>> customProperties) {
        this.customProperties = customProperties;
    }

    public final ReadOnlyList<CssToken> process(T element, ImmutableList<CssToken> in) throws ParseException {
        ListCssTokenizer tt = new ListCssTokenizer((ReadOnlyList<CssToken>)in);
        ArrayList<CssToken> out = new ArrayList<CssToken>(in.size());
        try {
            this.process(element, tt, out::add, new ArrayDeque<CssFunction<T>>());
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + e.getMessage(), e);
            out.clear();
            for (CssToken t : in) {
                out.add(t);
            }
        }
        return VectorList.copyOf(out);
    }

    @Override
    public String getHelpText() {
        StringBuilder buf = new StringBuilder();
        for (CssFunction<T> value : this.functions.values()) {
            if (!buf.isEmpty()) {
                buf.append("\n");
            }
            buf.append(value.getHelpText());
        }
        return buf.toString();
    }

    @Override
    public final void process(T element, CssTokenizer tt, Consumer<CssToken> out, Deque<CssFunction<T>> recursionStack) throws IOException, ParseException {
        while (tt.nextNoSkip() != -1) {
            tt.pushBack();
            this.processToken(element, tt, out, recursionStack);
        }
    }

    @Override
    public final void processToken(T element, CssTokenizer tt, Consumer<CssToken> out, Deque<CssFunction<T>> recursionStack) throws IOException, ParseException {
        this.doProcessToken(element, tt, out, recursionStack);
    }

    protected void doProcessToken(T element, CssTokenizer tt, Consumer<CssToken> out, Deque<CssFunction<T>> recursionStack) throws IOException, ParseException {
        if (recursionStack.size() >= this.maxRecursionDepth) {
            throw tt.createParseException("Too many recursions. recursionDepth=" + recursionStack.size());
        }
        if (tt.nextNoSkip() == -18) {
            String name = tt.currentStringNonNull();
            CssFunction<T> function = this.functions.get(name);
            if (function != null) {
                tt.pushBack();
                function.process(element, tt, this.model, this, out, recursionStack);
            } else {
                tt.pushBack();
                this.processUnknownFunction(element, tt, out, recursionStack);
            }
        } else {
            out.accept(tt.getToken());
        }
    }

    private void processUnknownFunction(T element, CssTokenizer tt, Consumer<CssToken> out, Deque<CssFunction<T>> recursionStack) throws IOException, ParseException {
        tt.requireNextToken(-18, "\u3008func\u3009: function expected.");
        out.accept(tt.getToken());
        while (tt.nextNoSkip() != -1 && tt.current() != 41) {
            tt.pushBack();
            this.processToken(element, tt, out, recursionStack);
        }
        if (tt.current() != -1) {
            out.accept(tt.getToken());
        }
    }
}

