/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.manager;

import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javafx.css.StyleOrigin;
import org.jhotdraw8.base.function.Consumer3;
import org.jhotdraw8.css.ast.StyleRule;
import org.jhotdraw8.css.ast.Stylesheet;
import org.jhotdraw8.css.model.SelectorModel;
import org.jspecify.annotations.Nullable;

public interface StylesheetsManager<E> {
    default public void addStylesheet(StyleOrigin origin, URI url) {
        this.addStylesheet(origin, url, url);
    }

    public void addStylesheet(StyleOrigin var1, URI var2, URI var3);

    public void addStylesheet(StyleOrigin var1, Stylesheet var2);

    public void addStylesheet(StyleOrigin var1, String var2, @Nullable URI var3);

    default public void applyStylesheetsTo(Iterable<E> iterable) {
        ((Stream)StreamSupport.stream(iterable.spliterator(), false).toList().stream().parallel()).forEach(this::applyStylesheetsTo);
    }

    public void clearStylesheets(StyleOrigin var1);

    default public <T> void setStylesheets(StyleOrigin origin, List<T> stylesheets) {
        this.setStylesheets(origin, null, stylesheets);
    }

    public <T> void setStylesheets(StyleOrigin var1, URI var2, List<T> var3);

    public void applyStylesheetsTo(E var1);

    public SelectorModel<E> getSelectorModel();

    public boolean applyStylesheetTo(StyleOrigin var1, Stylesheet var2, E var3, boolean var4) throws ParseException;

    default public boolean matchesElement(Stylesheet s, E elem) {
        SelectorModel<E> selectorModel = this.getSelectorModel();
        for (StyleRule r : s.getStyleRules()) {
            if (!r.getSelectorGroup().matches(selectorModel, elem)) continue;
            return true;
        }
        return false;
    }

    default public List<StyleRule> getMatchingRulesForElement(Stylesheet s, E elem) {
        ArrayList<StyleRule> matchingRules = new ArrayList<StyleRule>();
        SelectorModel<E> selectorModel = this.getSelectorModel();
        for (StyleRule r : s.getStyleRules()) {
            if (!r.getSelectorGroup().matches(selectorModel, elem)) continue;
            matchingRules.add(r);
        }
        return matchingRules;
    }

    public Consumer3<Level, String, Throwable> getLogger();

    public void setLogger(Consumer3<Level, String, Throwable> var1);

    public String getHelpText();

    public List<StylesheetInfo> getStylesheets();

    default public boolean hasStylesheets() {
        return !this.getStylesheets().isEmpty();
    }

    public static interface StylesheetInfo {
        public URI getUri();

        public StyleOrigin getOrigin();

        public Stylesheet getStylesheet();
    }
}

