/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javafx.css.StyleOrigin;
import org.jhotdraw8.css.model.AbstractSelectorModel;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.StreamCssTokenizer;
import org.jhotdraw8.css.value.QualifiedName;
import org.jhotdraw8.icollection.ChampSet;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentSelectorModel
extends AbstractSelectorModel<Element> {
    @Override
    public String getAttributeAsString(Element elem, StyleOrigin origin, @Nullable String namespacePattern, String name) {
        return this.getAttributeAsString(elem, namespacePattern, name);
    }

    @Override
    public @Nullable List<CssToken> getAttribute(Element element, @Nullable StyleOrigin origin, @Nullable String namespacePattern, String name) {
        String str = this.getAttributeAsString(element, origin, namespacePattern, name);
        if (str == null) {
            return null;
        }
        try {
            return new StreamCssTokenizer(str, null).toTokenList();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected Exception: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean hasId(Element elem, String id) {
        String value = elem.getAttribute("id");
        return value.equals(id);
    }

    @Override
    public String getId(Element elem) {
        return elem.getAttribute("id");
    }

    @Override
    public boolean hasType(Element elem, @Nullable String namespacePattern, String type) {
        String localName = elem.getLocalName();
        if ("*".equals(namespacePattern)) {
            return localName.equals(type);
        }
        return localName.equals(type) && Objects.equals(namespacePattern, elem.getNamespaceURI());
    }

    @Override
    public void reset(Element elem) {
    }

    @Override
    public @Nullable QualifiedName getType(Element elem) {
        return new QualifiedName(elem.getNamespaceURI(), elem.getNodeName());
    }

    @Override
    public boolean hasStyleClass(Element elem, String clazz) {
        String[] clazzes;
        String value = elem.getAttribute("class");
        for (String c : clazzes = value.split(" +")) {
            if (!c.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ReadOnlySet<String> getStyleClasses(Element elem) {
        String value = elem.getAttribute("class");
        String[] clazzes = value.split(" +");
        return ChampSet.copyOf(Arrays.asList(clazzes));
    }

    @Override
    public ReadOnlySet<String> getPseudoClasses(Element elem) {
        return ChampSet.of();
    }

    @Override
    public boolean hasPseudoClass(Element element, String pseudoClass) {
        return switch (pseudoClass) {
            case "root" -> {
                if (element.getOwnerDocument() != null && element.getOwnerDocument().getDocumentElement() == element) {
                    yield true;
                }
                yield false;
            }
            case "nth-child(even)" -> {
                int i = this.getChildIndex(element);
                if ((i & 1) == 0) {
                    yield true;
                }
                yield false;
            }
            case "nth-child(odd)" -> {
                int i = this.getChildIndex(element);
                if ((i & 1) == 1) {
                    yield true;
                }
                yield false;
            }
            case "first-child" -> this.isFirstChild(element);
            case "last-child" -> this.isLastChild(element);
            default -> false;
        };
    }

    private int getChildIndex(Element element) {
        if (element.getParentNode() != null) {
            NodeList list = element.getParentNode().getChildNodes();
            int j = 0;
            int n = list.getLength();
            for (int i = 0; i < n; ++i) {
                if (list.item(i) == element) {
                    return j;
                }
                if (!(list.item(i) instanceof Element)) continue;
                ++j;
            }
        }
        return -1;
    }

    private boolean isFirstChild(Element element) {
        if (element.getParentNode() != null) {
            NodeList list = element.getParentNode().getChildNodes();
            int n = list.getLength();
            for (int i = 0; i < n; ++i) {
                if (list.item(i) == element) {
                    return true;
                }
                if (!(list.item(i) instanceof Element)) continue;
                return false;
            }
        }
        return false;
    }

    private boolean isLastChild(Element element) {
        if (element.getParentNode() != null) {
            NodeList list = element.getParentNode().getChildNodes();
            for (int i = list.getLength() - 1; i >= 0; --i) {
                if (list.item(i) == element) {
                    return true;
                }
                if (!(list.item(i) instanceof Element)) continue;
                return false;
            }
        }
        return false;
    }

    @Override
    public Element getParent(Element elem) {
        Node n;
        for (n = elem.getParentNode(); n != null && !(n instanceof Element); n = n.getParentNode()) {
        }
        return (Element)n;
    }

    @Override
    public Element getPreviousSibling(Element element) {
        Node n;
        for (n = element.getPreviousSibling(); n != null && !(n instanceof Element); n = n.getPreviousSibling()) {
        }
        return (Element)n;
    }

    @Override
    public boolean hasAttribute(Element element, @Nullable String namespace, String attributeName) {
        return this.getAttributeAsString(element, namespace, attributeName) != null;
    }

    @Override
    public boolean attributeValueStartsWith(Element element, @Nullable String namespacePattern, String attributeName, String substring) {
        String actualValue = this.getAttributeAsString(element, namespacePattern, attributeName);
        return actualValue != null && actualValue.startsWith(substring);
    }

    @Override
    public @Nullable String getAttributeAsString(Element element, @Nullable String namespacePattern, String attributeName) {
        if ("*".equals(namespacePattern)) {
            NamedNodeMap nnm = element.getAttributes();
            int n = nnm.getLength();
            for (int i = 0; i < n; ++i) {
                Node item = nnm.item(i);
                if (!Objects.equals(item.getLocalName(), attributeName) && !Objects.equals(item.getNodeName(), attributeName)) continue;
                return item.getNodeValue();
            }
            return null;
        }
        return element.getAttributeNS(namespacePattern, attributeName);
    }

    @Override
    public Set<QualifiedName> getAttributeNames(Element element) {
        LinkedHashSet<QualifiedName> attr = new LinkedHashSet<QualifiedName>();
        NamedNodeMap nnm = element.getAttributes();
        int n = nnm.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nnm.item(i);
            attr.add(new QualifiedName(node.getNamespaceURI(), node.getLocalName()));
        }
        return attr;
    }

    @Override
    public Set<QualifiedName> getComposedAttributeNames(Element element) {
        return this.getAttributeNames(element);
    }

    @Override
    public Set<QualifiedName> getDecomposedAttributeNames(Element element) {
        return this.getAttributeNames(element);
    }

    @Override
    public void setAttribute(Element element, StyleOrigin origin, @Nullable String namespace, String name, @Nullable ReadOnlyList<CssToken> value) {
        StringBuilder buf = new StringBuilder();
        for (CssToken t : value) {
            buf.append(t.fromToken());
        }
        String value1 = buf.toString();
        switch (origin) {
            case USER: 
            case USER_AGENT: 
            case INLINE: 
            case AUTHOR: {
                if ("*".equals(namespace)) {
                    NamedNodeMap nnm = element.getAttributes();
                    int n = nnm.getLength();
                    for (int i = 0; i < n; ++i) {
                        Node item = nnm.item(i);
                        if (!item.getLocalName().equals(name)) continue;
                        item.setNodeValue(value1);
                        return;
                    }
                    element.setAttribute(name, value1);
                    break;
                }
                element.setAttributeNS(namespace, name, value1);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported origin=" + String.valueOf(origin));
            }
        }
    }
}

