/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.model;

import java.text.ParseException;
import java.util.List;
import java.util.Set;
import javafx.beans.property.MapProperty;
import javafx.css.StyleOrigin;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.value.QualifiedName;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;
import org.jspecify.annotations.Nullable;

public interface SelectorModel<T> {
    public MapProperty<String, Set<T>> additionalPseudoClassStatesProperty();

    default public boolean attributeValueContains(T element, @Nullable String namespacePattern, String attributeName, String substring) {
        String actualValue = this.getAttributeAsString(element, namespacePattern, attributeName);
        return actualValue != null && actualValue.contains(substring);
    }

    default public boolean attributeValueContainsWord(T element, @Nullable String namespacePattern, String attributeName, String word) {
        String value = this.getAttributeAsString(element, namespacePattern, attributeName);
        if (value != null) {
            String[] words;
            for (String s : words = value.split("\\s+")) {
                if (!word.equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean attributeValueEndsWith(T element, @Nullable String namespacePattern, String attributeName, String substring) {
        String actualValue = this.getAttributeAsString(element, namespacePattern, attributeName);
        return actualValue != null && actualValue.endsWith(substring);
    }

    default public boolean attributeValueEquals(T element, @Nullable String namespacePattern, String attributeName, String attributeValue) {
        String actualValue = this.getAttributeAsString(element, namespacePattern, attributeName);
        return actualValue != null && actualValue.equals(attributeValue);
    }

    default public boolean attributeValueStartsWith(T element, @Nullable String namespacePattern, String attributeName, String substring) {
        String actualValue = this.getAttributeAsString(element, namespacePattern, attributeName);
        return actualValue != null && actualValue.startsWith(substring);
    }

    default public @Nullable String getAttributeAsString(T element, @Nullable String namespacePattern, String name) {
        return this.getAttributeAsString(element, StyleOrigin.USER, namespacePattern, name);
    }

    default public @Nullable String getAttributeAsString(T element, @Nullable StyleOrigin origin, @Nullable String namespacePattern, String name) {
        List<CssToken> list = this.getAttribute(element, origin, namespacePattern, name);
        if (list == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (CssToken t : list) {
            buf.append(t.fromToken());
        }
        return buf.toString();
    }

    public @Nullable List<CssToken> getAttribute(T var1, @Nullable StyleOrigin var2, @Nullable String var3, String var4);

    public Set<QualifiedName> getAttributeNames(T var1);

    public Set<QualifiedName> getComposedAttributeNames(T var1);

    public Set<QualifiedName> getDecomposedAttributeNames(T var1);

    public @Nullable String getId(T var1);

    public @Nullable T getParent(T var1);

    public @Nullable T getPreviousSibling(T var1);

    public ReadOnlySet<String> getStyleClasses(T var1);

    public ReadOnlySet<String> getPseudoClasses(T var1);

    public @Nullable QualifiedName getType(T var1);

    public boolean hasAttribute(T var1, @Nullable String var2, String var3);

    public boolean hasId(T var1, String var2);

    public boolean hasPseudoClass(T var1, String var2);

    public boolean hasStyleClass(T var1, String var2);

    public boolean hasType(T var1, @Nullable String var2, String var3);

    public void reset(T var1);

    public void setAttribute(T var1, StyleOrigin var2, @Nullable String var3, String var4, @Nullable ReadOnlyList<CssToken> var5) throws ParseException;
}

