/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import org.jhotdraw8.css.model.AbstractSelectorModel;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.StreamCssTokenizer;
import org.jhotdraw8.css.value.QualifiedName;
import org.jhotdraw8.icollection.ChampSet;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;
import org.jspecify.annotations.Nullable;

public class StyleableSelectorModel
extends AbstractSelectorModel<Styleable> {
    @Override
    public @Nullable String getAttributeAsString(Styleable element, StyleOrigin origin, @Nullable String namespacePattern, String name) {
        if (origin == StyleOrigin.USER) {
            String attribute = this.getAttributeAsString(element, namespacePattern, name);
            return attribute == null ? "" : attribute;
        }
        return null;
    }

    @Override
    public boolean hasId(Styleable element, String id) {
        return id.equals(element.getId());
    }

    @Override
    public String getId(Styleable element) {
        return element.getId();
    }

    @Override
    public boolean hasType(Styleable element, @Nullable String namespacePattern, String type) {
        return type.equals(element.getTypeSelector());
    }

    @Override
    public void reset(Styleable elem) {
    }

    @Override
    public @Nullable QualifiedName getType(Styleable element) {
        return new QualifiedName(null, element.getTypeSelector());
    }

    @Override
    public boolean hasStyleClass(Styleable element, String clazz) {
        return element.getStyleClass().contains((Object)clazz);
    }

    @Override
    public ReadOnlySet<String> getStyleClasses(Styleable element) {
        return ChampSet.copyOf((Iterable)element.getStyleClass());
    }

    @Override
    public ReadOnlySet<String> getPseudoClasses(Styleable element) {
        return ChampSet.copyOf((Iterable)element.getPseudoClassStates().stream().map(PseudoClass::getPseudoClassName).collect(Collectors.toList()));
    }

    @Override
    public boolean hasPseudoClass(Styleable element, String pseudoClass) {
        return element.getPseudoClassStates().contains((Object)PseudoClass.getPseudoClass((String)pseudoClass));
    }

    @Override
    public Styleable getParent(Styleable element) {
        return element.getStyleableParent();
    }

    @Override
    public @Nullable Styleable getPreviousSibling(Styleable element) {
        return null;
    }

    @Override
    public boolean hasAttribute(Styleable element, @Nullable String namespace, String attributeName) {
        List list = element.getCssMetaData();
        for (CssMetaData item : list) {
            if (!attributeName.equals(item.getProperty())) continue;
            return true;
        }
        return false;
    }

    @Override
    public @Nullable List<CssToken> getAttribute(Styleable element, StyleOrigin origin, @Nullable String namespacePattern, String attributeName) {
        List list = element.getCssMetaData();
        for (CssMetaData i : list) {
            CssMetaData item = i;
            if (!attributeName.equals(item.getProperty())) continue;
            Object value = item.getStyleableProperty(element).getValue();
            try {
                return value == null ? null : new StreamCssTokenizer(value.toString(), null).toTokenList();
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected IOException", e);
            }
        }
        return null;
    }

    private @Nullable Set<String> getWordListAttribute(Styleable element, @Nullable String namespace, String attributeName) {
        List list = element.getCssMetaData();
        for (CssMetaData i : list) {
            CssMetaData item = i;
            if (!attributeName.equals(item.getProperty())) continue;
            Object value = item.getStyleableProperty(element).getValue();
            if (value instanceof Collection) {
                Collection olist = (Collection)value;
                HashSet<String> slist = new HashSet<String>();
                for (Object o : olist) {
                    slist.add(o.toString());
                }
                return slist;
            }
            HashSet<String> slist = new HashSet<String>();
            if (value != null) {
                String[] words = value.toString().split("\\s+");
                slist.addAll(Arrays.asList(words));
            }
            return slist;
        }
        return null;
    }

    @Override
    public boolean attributeValueContainsWord(Styleable element, @Nullable String namespacePattern, String attributeName, String word) {
        Set<String> value = this.getWordListAttribute(element, namespacePattern, attributeName);
        return value != null && value.contains(word);
    }

    @Override
    public Set<QualifiedName> getAttributeNames(Styleable element) {
        HashSet<QualifiedName> attr = new HashSet<QualifiedName>();
        for (CssMetaData item : element.getCssMetaData()) {
            attr.add(new QualifiedName(null, item.getProperty()));
        }
        return attr;
    }

    @Override
    public Set<QualifiedName> getComposedAttributeNames(Styleable element) {
        return this.getAttributeNames(element);
    }

    @Override
    public Set<QualifiedName> getDecomposedAttributeNames(Styleable element) {
        return this.getAttributeNames(element);
    }

    @Override
    public void setAttribute(Styleable elem, StyleOrigin origin, @Nullable String namespace, String name, @Nullable ReadOnlyList<CssToken> valueAsTokens) {
        String value = valueAsTokens == null ? null : valueAsTokens.stream().map(CssToken::fromToken).collect(Collectors.joining());
        List metaList = elem.getCssMetaData();
        HashMap<String, CssMetaData> metaMap = new HashMap<String, CssMetaData>();
        for (CssMetaData m : metaList) {
            metaMap.put(m.getProperty(), m);
        }
        CssMetaData m = (CssMetaData)metaMap.get(name);
        if (m != null && m.isSettable(elem)) {
            StyleConverter converter = m.getConverter();
            ParsedValueImpl parsedValue = new ParsedValueImpl(value, null);
            Object convertedValue = converter.convert(parsedValue, null);
            StyleableProperty styleableProperty = m.getStyleableProperty(elem);
            styleableProperty.applyStyle(origin, convertedValue);
        }
    }

    private static class ParsedValueImpl<V, T>
    extends ParsedValue<V, T> {
        public ParsedValueImpl(V value, StyleConverter<V, T> converter) {
            super(value, converter);
        }
    }
}

