/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Objects;
import org.jhotdraw8.base.converter.NumberConverter;
import org.jspecify.annotations.Nullable;

public class CssToken {
    private final int ttype;
    private final @Nullable String stringValue;
    private final @Nullable Number numericValue;
    private final int startPos;
    private final int endPos;
    private final int lineNumber;
    private final @Nullable Character preferredQuoteChar;
    private static final NumberConverter NUMBER_CONVERTER = new NumberConverter();

    public CssToken(int ttype, String stringValue) {
        this(ttype, stringValue, null, 0, 0, stringValue.length());
    }

    public CssToken(int ttype, String stringValue, @Nullable Character preferredQuoteChar) {
        this(ttype, stringValue, null, preferredQuoteChar, 0, 0, stringValue.length());
    }

    public CssToken(int ttype) {
        this(ttype, Character.toString((char)ttype), null, null, 0, 0, 1);
    }

    public CssToken(int ttype, Number numericValue, String stringValue) {
        this(ttype, stringValue, numericValue, null, 0, 0, 1);
    }

    public CssToken(int ttype, Number numericValue) {
        this(ttype, "", numericValue, null, 0, 0, 1);
    }

    public CssToken(int ttype, String stringValue, Number numericValue, int lineNumber, int startPos, int endPos) {
        this(ttype, stringValue, numericValue, null, lineNumber, startPos, endPos);
    }

    public CssToken(int ttype, @Nullable String stringValue, @Nullable Number numericValue, @Nullable Character preferredQuoteChar, int lineNumber, int startPos, int endPos) {
        switch (ttype) {
            case -11: {
                Objects.requireNonNull(numericValue, "numericValue must not be null for ttype=TT_DIMENSION");
                Objects.requireNonNull(stringValue, "stringValue must not be null for ttype=TT_DIMENSION");
                break;
            }
            case -10: 
            case -9: {
                Objects.requireNonNull(numericValue, "numeric value must not be null for ttype=TT_NUMBER or ttype=TT_PERCENTAGE");
                break;
            }
            case -3: 
            case -2: {
                if (stringValue != null && !stringValue.isEmpty()) break;
                throw new IllegalArgumentException("stringValue must not be null or empty for ttype=TT_IDENT or ttype=TT_AT_KEYWORD");
            }
            default: {
                if (ttype >= 0 || ttype == -1 || stringValue != null) break;
                throw new IllegalArgumentException("string value must not be null for ttype=" + ttype);
            }
        }
        this.ttype = ttype;
        this.stringValue = stringValue;
        this.numericValue = numericValue;
        this.lineNumber = lineNumber;
        this.startPos = startPos;
        this.endPos = endPos;
        this.preferredQuoteChar = preferredQuoteChar;
    }

    public String getStringValueNonNull() {
        return Objects.requireNonNull(this.stringValue, "stringValue");
    }

    public Number getNumericValueNonNull() {
        return Objects.requireNonNull(this.numericValue, "numericValue");
    }

    public @Nullable String toString() {
        return this.fromToken();
    }

    public @Nullable String fromToken() {
        if (this.ttype >= 0) {
            return this.stringValue;
        }
        return switch (this.ttype) {
            case -2 -> this.fromIDENT();
            case -3 -> this.fromHASHorAT('@', this.stringValue);
            case -4 -> this.fromSTRING();
            case -5 -> this.fromBAD_STRING(this.stringValue);
            case -6 -> this.fromBAD_URI(this.stringValue);
            case -8 -> this.fromHASHorAT('#', this.stringValue);
            case -9 -> this.fromNUMBER();
            case -10 -> this.fromPERCENTAGE();
            case -11 -> this.fromDIMENSION();
            case -12 -> this.fromURL();
            case -13 -> this.fromUNICODE_RANGE();
            case -14 -> this.fromCDO();
            case -15 -> this.fromCDC();
            case -16 -> this.fromS();
            case -17 -> this.fromCOMMENT();
            case -18 -> this.fromIDENT() + "(";
            case -19 -> this.fromINCLUDE_MATCH();
            case -20 -> this.fromDASH_MATCH();
            case -21 -> this.fromPREFIX_MATCH();
            case -22 -> this.fromSUFFIX_MATCH();
            case -23 -> this.fromSUBSTRING_MATCH();
            case -24 -> this.fromCOLUMN();
            case -1 -> "<EOF>";
            default -> throw new InternalError("Unsupported TTYPE:" + this.ttype);
        };
    }

    private String fromCDC() {
        return "<!--";
    }

    private String fromCDO() {
        return "-->";
    }

    private String fromIDENT() {
        return this.fromIDENT(this.stringValue);
    }

    private String fromIDENT(String value) {
        StringBuilder out = new StringBuilder();
        StringReader r = new StringReader(value);
        try {
            int ch = ((Reader)r).read();
            while (ch == 45) {
                out.append((char)ch);
                ch = ((Reader)r).read();
            }
            if (ch == -1) {
                throw new IllegalArgumentException("nmstart missing! value=\"" + value + "\".");
            }
            if (ch == 95 || 97 <= ch && ch <= 122 || 65 <= ch && ch <= 90 || 160 <= ch) {
                out.append((char)ch);
            } else {
                switch (ch) {
                    case 10: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        String hex = Integer.toHexString(ch);
                        out.append('\\');
                        out.append(hex);
                        out.append(' ');
                        break;
                    }
                    default: {
                        out.append('\\');
                        out.append((char)ch);
                    }
                }
            }
            while (-1 != (ch = ((Reader)r).read())) {
                if (ch == 95 || 97 <= ch && ch <= 122 || 65 <= ch && ch <= 90 || 48 <= ch && ch <= 57 || ch == 45 || 160 <= ch) {
                    out.append((char)ch);
                    continue;
                }
                out.append('\\');
                out.append((char)ch);
            }
            return out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException", e);
        }
    }

    private String fromHASHorAT(char hashOrAt, String value) {
        StringBuilder out = new StringBuilder();
        out.append(hashOrAt);
        StringReader r = new StringReader(value);
        try {
            int ch = ((Reader)r).read();
            while (ch != -1) {
                if (ch == 95 || 97 <= ch && ch <= 122 || 65 <= ch && ch <= 90 || 48 <= ch && ch <= 57 || ch == 45 || 160 <= ch) {
                    out.append((char)ch);
                } else {
                    out.append('\\');
                    out.append((char)ch);
                }
                ch = ((Reader)r).read();
            }
            return out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException", e);
        }
    }

    private String fromSTRING() {
        return this.fromSTRING(this.stringValue);
    }

    private String fromSTRING(String value) {
        char c = this.preferredQuoteChar != null ? this.preferredQuoteChar.charValue() : (value.indexOf(34) < 0 || value.indexOf(39) < 0 ? 34 : 39);
        return this.fromSTRING(value, c, c);
    }

    private String fromBAD_URI(String value) {
        return this.fromURL(value);
    }

    private String fromBAD_STRING(String value) {
        char c = this.preferredQuoteChar != null ? this.preferredQuoteChar.charValue() : (value.indexOf(34) < 0 || value.indexOf(39) < 0 ? 34 : 39);
        return this.fromSTRING(value, c, '\n');
    }

    private String fromSTRING(String value, char firstQuoteChar, char lastQuoteChar) {
        StringBuilder out = new StringBuilder();
        out.append(firstQuoteChar);
        block5: for (char ch : value.toCharArray()) {
            switch (ch) {
                case ' ': {
                    out.append(ch);
                    continue block5;
                }
                case '\\': {
                    out.append('\\');
                    out.append('\\');
                    continue block5;
                }
                case '\n': {
                    out.append('\\');
                    out.append('\n');
                    continue block5;
                }
                default: {
                    if (ch == firstQuoteChar) {
                        out.append('\\');
                        out.append(firstQuoteChar);
                        continue block5;
                    }
                    if (Character.isISOControl(ch) || Character.isWhitespace(ch)) {
                        out.append('\\');
                        String hex = Integer.toHexString(ch);
                        int n = 6 - hex.length();
                        for (int i = 0; i < n; ++i) {
                            out.append('0');
                        }
                        out.append(hex);
                        continue block5;
                    }
                    out.append(ch);
                }
            }
        }
        out.append(lastQuoteChar);
        return out.toString();
    }

    private String fromNUMBER() {
        return NUMBER_CONVERTER.toString((Object)this.numericValue.doubleValue());
    }

    private String fromPERCENTAGE() {
        return Double.isFinite(this.numericValue.doubleValue()) ? this.fromNUMBER() + "%" : this.fromNUMBER();
    }

    private String fromDIMENSION() {
        return !this.stringValue.isEmpty() && Double.isFinite(this.numericValue.doubleValue()) ? this.fromNUMBER() + this.fromIDENT() : this.fromNUMBER();
    }

    private String fromURL() {
        return this.fromURL(this.stringValue);
    }

    private String fromURL(String stringValue) {
        StringBuilder out = new StringBuilder();
        out.append("url(");
        StringReader r = new StringReader(stringValue);
        try {
            int ch = ((Reader)r).read();
            while (ch != -1) {
                boolean escape;
                switch (ch) {
                    case 34: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 92: {
                        boolean bl = true;
                        break;
                    }
                    default: {
                        boolean bl = escape = Character.isWhitespace(ch) || Character.isISOControl(ch);
                    }
                }
                if (escape) {
                    String hex = Integer.toHexString(ch);
                    out.append('\\');
                    out.append(hex);
                    out.append(' ');
                } else {
                    out.append((char)ch);
                }
                ch = ((Reader)r).read();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException", e);
        }
        out.append(')');
        return out.toString();
    }

    private @Nullable String fromUNICODE_RANGE() {
        return this.stringValue;
    }

    private @Nullable String fromS() {
        return this.stringValue;
    }

    private String fromCOMMENT() {
        return "/*" + this.stringValue.replace("*/", "* /") + "*/";
    }

    private @Nullable String fromINCLUDE_MATCH() {
        return "~=";
    }

    private @Nullable String fromDASH_MATCH() {
        return "|=";
    }

    private @Nullable String fromPREFIX_MATCH() {
        return "^=";
    }

    private @Nullable String fromSUFFIX_MATCH() {
        return "$=";
    }

    private @Nullable String fromSUBSTRING_MATCH() {
        return "*=";
    }

    private @Nullable String fromCOLUMN() {
        return this.stringValue;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public @Nullable String getStringValue() {
        return this.stringValue;
    }

    public @Nullable Number getNumericValue() {
        return this.numericValue;
    }

    public int getType() {
        return this.ttype;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CssToken cssToken = (CssToken)o;
        return this.ttype == cssToken.ttype && Objects.equals(this.stringValue, cssToken.stringValue) && Objects.equals(this.numericValue, cssToken.numericValue);
    }

    public int hashCode() {
        return Objects.hash(this.ttype, this.stringValue, this.numericValue);
    }
}

