/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.parser;

import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.parser.CharSequenceCssScanner;
import org.jhotdraw8.css.parser.CssScanner;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.parser.ReaderCssScanner;
import org.jspecify.annotations.Nullable;

public class StreamCssTokenizer
implements CssTokenizer {
    private final CssScanner in;
    private boolean pushBack;
    private int currentToken;
    private @Nullable String stringValue;
    private final StringBuilder stringBuilder = new StringBuilder();
    private final StringBuilder unitBuf = new StringBuilder();
    private @Nullable Number numericValue;
    private int lineNumber;
    private int startPosition;
    private int endPosition;
    private final @Nullable URI uri;
    private static final boolean[] safeUriChars = new boolean[128];
    private static final char[] hexChars;

    public StreamCssTokenizer(CharSequence charSequence, @Nullable URI uri) {
        this(new CharSequenceCssScanner(charSequence), uri);
    }

    public StreamCssTokenizer(CharSequence charSequence) {
        this(new CharSequenceCssScanner(charSequence), null);
    }

    public StreamCssTokenizer(Reader reader, @Nullable URI uri) {
        this(new ReaderCssScanner(reader), uri);
    }

    public StreamCssTokenizer(Reader reader) {
        this(new ReaderCssScanner(reader), null);
    }

    public StreamCssTokenizer(CssScanner reader, @Nullable URI uri) {
        this.in = reader;
        this.uri = uri;
    }

    public StreamCssTokenizer(CssScanner reader) {
        this(reader, null);
    }

    @Override
    public int current() {
        return this.currentToken;
    }

    @Override
    public @Nullable String currentString() {
        return this.stringValue;
    }

    @Override
    public @Nullable Number currentNumber() {
        return this.numericValue;
    }

    @Override
    public int next() throws IOException {
        do {
            this.nextNoSkip();
        } while (this.currentToken == -17 || this.currentToken == -7 || this.currentToken == -16 || this.currentToken == -15 || this.currentToken == -14);
        return this.currentToken;
    }

    @Override
    public int nextNoSkip() throws IOException {
        if (this.pushBack) {
            this.pushBack = false;
            return this.currentToken;
        }
        this.lineNumber = (int)this.in.getLineNumber();
        this.startPosition = (int)this.in.getPosition();
        this.endPosition = (int)this.in.getPosition();
        int ch = this.in.nextChar();
        this.stringValue = null;
        this.numericValue = null;
        switch (ch) {
            case -1: {
                this.currentToken = -1;
                this.stringValue = "<EOF>";
                break;
            }
            case 9: 
            case 10: 
            case 32: {
                this.stringBuilder.setLength(0);
                while (ch == 32 || ch == 10 || ch == 9) {
                    this.stringBuilder.append((char)ch);
                    ch = this.in.nextChar();
                }
                this.in.pushBack(ch);
                this.currentToken = -16;
                this.stringValue = this.stringBuilder.toString();
                break;
            }
            case 126: {
                int next = this.in.nextChar();
                if (next == 61) {
                    this.currentToken = -19;
                    this.stringValue = "~=";
                    break;
                }
                this.in.pushBack(next);
                this.currentToken = 126;
                this.stringValue = String.valueOf((char)ch);
                break;
            }
            case 124: {
                int next = this.in.nextChar();
                if (next == 61) {
                    this.currentToken = -20;
                    this.stringValue = "|=";
                    break;
                }
                if (next == 124) {
                    this.currentToken = -24;
                    this.stringValue = "||";
                    break;
                }
                this.in.pushBack(next);
                this.currentToken = 124;
                this.stringValue = String.valueOf((char)this.currentToken);
                break;
            }
            case 94: {
                int next = this.in.nextChar();
                if (next == 61) {
                    this.currentToken = -21;
                    this.stringValue = "^=";
                    break;
                }
                this.in.pushBack(next);
                this.currentToken = 94;
                this.stringValue = String.valueOf((char)this.currentToken);
                break;
            }
            case 36: {
                int next = this.in.nextChar();
                if (next == 61) {
                    this.currentToken = -22;
                    this.stringValue = "$=";
                    break;
                }
                this.in.pushBack(next);
                this.currentToken = 36;
                this.stringValue = String.valueOf((char)this.currentToken);
                break;
            }
            case 42: {
                int next = this.in.nextChar();
                if (next == 61) {
                    this.currentToken = -23;
                    this.stringValue = "*=";
                    break;
                }
                this.in.pushBack(next);
                this.currentToken = 42;
                this.stringValue = String.valueOf((char)ch);
                break;
            }
            case 64: {
                this.stringBuilder.setLength(0);
                ch = this.in.nextChar();
                if (this.identMacro(ch, this.stringBuilder)) {
                    this.currentToken = -3;
                    this.stringValue = this.stringBuilder.toString();
                    break;
                }
                this.in.pushBack(ch);
                this.currentToken = 64;
                this.stringValue = String.valueOf((char)this.currentToken);
                break;
            }
            case 35: {
                this.stringBuilder.setLength(0);
                ch = this.in.nextChar();
                if (this.nameMacro(ch, this.stringBuilder)) {
                    this.currentToken = -8;
                    this.stringValue = this.stringBuilder.toString();
                    break;
                }
                this.in.pushBack(ch);
                this.currentToken = 35;
                this.stringValue = String.valueOf((char)this.currentToken);
                break;
            }
            case 34: 
            case 39: {
                this.stringBuilder.setLength(0);
                if (this.stringMacro(ch, this.stringBuilder)) {
                    this.currentToken = -4;
                    this.stringValue = this.stringBuilder.toString();
                    break;
                }
                this.currentToken = -5;
                this.stringValue = this.stringBuilder.toString();
                break;
            }
            case 43: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.stringBuilder.setLength(0);
                this.unitBuf.setLength(0);
                if (this.numMacro(ch, this.stringBuilder)) {
                    ch = this.in.nextChar();
                    if (ch == 37) {
                        this.currentToken = -10;
                        this.stringValue = "%";
                        break;
                    }
                    if (this.identMacro(ch, this.unitBuf)) {
                        this.currentToken = -11;
                        this.stringValue = this.unitBuf.toString();
                        break;
                    }
                    this.in.pushBack(ch);
                    this.currentToken = -9;
                    break;
                }
                this.currentToken = ch;
                this.stringValue = String.valueOf((char)this.currentToken);
                break;
            }
            case 47: {
                int next = this.in.nextChar();
                if (next == 42) {
                    this.stringBuilder.setLength(0);
                    this.currentToken = this.commentAfterSlashStarMacro(this.stringBuilder) ? -17 : -7;
                    this.stringValue = this.stringBuilder.toString();
                    break;
                }
                this.in.pushBack(next);
                this.currentToken = ch;
                this.stringValue = String.valueOf((char)this.currentToken);
                break;
            }
            case 45: {
                int next1 = this.in.nextChar();
                if (next1 == 45) {
                    int next2 = this.in.nextChar();
                    if (next2 == 62) {
                        this.stringValue = "-->";
                        this.currentToken = -15;
                        break;
                    }
                    this.stringBuilder.setLength(0);
                    this.stringBuilder.append("--");
                    if (next2 == -1 || this.nameMacro(next2, this.stringBuilder)) {
                        this.currentToken = -2;
                        this.stringValue = this.stringBuilder.toString();
                        break;
                    }
                    this.in.pushBack(next2);
                    this.in.pushBack(next1);
                    this.currentToken = ch;
                    this.stringValue = String.valueOf((char)this.currentToken);
                    break;
                }
                this.in.pushBack(next1);
                this.stringBuilder.setLength(0);
                this.unitBuf.setLength(0);
                if (this.numMacro(ch, this.stringBuilder)) {
                    ch = this.in.nextChar();
                    if (ch == 37) {
                        this.currentToken = -10;
                        this.stringValue = "%";
                        break;
                    }
                    if (this.identMacro(ch, this.unitBuf)) {
                        this.currentToken = -11;
                        this.stringValue = this.unitBuf.toString();
                        break;
                    }
                    this.in.pushBack(ch);
                    this.currentToken = -9;
                    break;
                }
                if (this.identMacro(ch, this.stringBuilder)) {
                    next1 = this.in.nextChar();
                    if (next1 == 40) {
                        this.currentToken = -18;
                    } else {
                        this.in.pushBack(next1);
                        this.currentToken = -2;
                    }
                    this.stringValue = this.stringBuilder.toString();
                    break;
                }
                this.currentToken = ch;
                this.stringValue = String.valueOf((char)this.currentToken);
                break;
            }
            case 60: {
                int next1 = this.in.nextChar();
                if (next1 == 33) {
                    int next2 = this.in.nextChar();
                    if (next2 == 45) {
                        int next3 = this.in.nextChar();
                        if (next3 == 45) {
                            this.stringValue = "<!--";
                            this.currentToken = -14;
                            break;
                        }
                        this.in.pushBack(next3);
                        this.in.pushBack(next2);
                        this.in.pushBack(next1);
                        this.currentToken = ch;
                        this.stringValue = String.valueOf((char)this.currentToken);
                        break;
                    }
                    this.in.pushBack(next2);
                    this.in.pushBack(next1);
                    this.currentToken = ch;
                    this.stringValue = String.valueOf((char)this.currentToken);
                    break;
                }
                this.in.pushBack(next1);
                this.currentToken = ch;
                this.stringValue = String.valueOf((char)this.currentToken);
                break;
            }
            case 85: 
            case 117: {
                this.stringBuilder.setLength(0);
                if (this.identMacro(ch, this.stringBuilder)) {
                    int next1 = this.in.nextChar();
                    if (next1 == 40) {
                        this.stringValue = this.stringBuilder.toString();
                        if (this.stringValue.equalsIgnoreCase("url")) {
                            this.stringBuilder.setLength(0);
                            this.currentToken = this.uriMacro(this.stringBuilder) ? -12 : -6;
                            this.stringValue = this.stringBuilder.toString();
                            break;
                        }
                        this.currentToken = -18;
                        break;
                    }
                    this.in.pushBack(next1);
                    this.currentToken = -2;
                    this.stringValue = this.stringBuilder.toString();
                    break;
                }
                this.currentToken = ch;
                this.stringValue = String.valueOf((char)this.currentToken);
                break;
            }
            default: {
                this.stringBuilder.setLength(0);
                if (this.identMacro(ch, this.stringBuilder)) {
                    int next1 = this.in.nextChar();
                    if (next1 == 40) {
                        this.stringValue = this.stringBuilder.toString();
                        this.currentToken = -18;
                        break;
                    }
                    this.in.pushBack(next1);
                    this.currentToken = -2;
                    this.stringValue = this.stringBuilder.toString();
                    break;
                }
                this.currentToken = ch;
                this.stringValue = String.valueOf((char)this.currentToken);
            }
        }
        this.endPosition = (int)this.in.getPosition();
        return this.currentToken;
    }

    @Override
    public void pushBack() {
        this.pushBack = true;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public @Nullable SourceLocator getSourceLocator() {
        return new SourceLocator(this.startPosition, this.lineNumber, this.uri);
    }

    private boolean identMacro(int ch, StringBuilder buf) throws IOException {
        boolean consumed = false;
        if (ch == 45) {
            buf.append('-');
            consumed = true;
            ch = this.in.nextChar();
        }
        if (this.nmstartMacro(ch, buf)) {
            while (this.nmcharMacro(ch = this.in.nextChar(), buf)) {
            }
            this.in.pushBack(ch);
            return true;
        }
        if (consumed) {
            this.in.pushBack(ch);
        }
        return false;
    }

    private boolean nameMacro(int ch, StringBuilder buf) throws IOException {
        if (this.nmcharMacro(ch, buf)) {
            while (this.nmcharMacro(ch = this.in.nextChar(), buf)) {
            }
            this.in.pushBack(ch);
            return true;
        }
        return false;
    }

    private boolean numMacro(int ch, StringBuilder buf) throws IOException {
        boolean hasSign = false;
        if (ch == 45) {
            hasSign = true;
            buf.append('-');
            ch = this.in.nextChar();
        } else if (ch == 43) {
            hasSign = true;
            buf.append('+');
            ch = this.in.nextChar();
        }
        boolean hasDecimals = false;
        boolean hasFractionalsOrExponent = false;
        while (48 <= ch && ch <= 57) {
            hasDecimals = true;
            buf.append((char)ch);
            ch = this.in.nextChar();
        }
        if (ch == 46) {
            hasFractionalsOrExponent = true;
            int next = this.in.nextChar();
            if (48 > next || next > 57) {
                this.in.pushBack(next);
                if (hasDecimals) {
                    this.in.pushBack(ch);
                    this.numericValue = Long.parseLong(buf.toString());
                    return true;
                }
                return false;
            }
            buf.append('.');
            ch = next;
            while (48 <= ch && ch <= 57) {
                buf.append((char)ch);
                ch = this.in.nextChar();
            }
        }
        if ((hasDecimals || hasFractionalsOrExponent) && (ch == 101 || ch == 69)) {
            hasFractionalsOrExponent = true;
            buf.append('E');
            int expchar = ch;
            ch = this.in.nextChar();
            if (ch == 45) {
                buf.append('-');
                ch = this.in.nextChar();
            } else if (ch == 43) {
                ch = this.in.nextChar();
            }
            boolean hasExponents = false;
            while (48 <= ch && ch <= 57) {
                hasExponents = true;
                buf.append((char)ch);
                ch = this.in.nextChar();
            }
            if (!hasExponents) {
                this.in.pushBack(ch);
                ch = expchar;
                buf.setLength(buf.length() - 1);
            }
        }
        if (!hasDecimals && !hasFractionalsOrExponent) {
            if (hasSign) {
                this.in.pushBack(ch);
                buf.setLength(buf.length() - 1);
            }
            return false;
        }
        try {
            this.numericValue = hasFractionalsOrExponent ? (Number)Double.parseDouble(buf.toString()) : (Number)Long.parseLong(buf.toString());
        }
        catch (NumberFormatException e) {
            throw new InternalError("Tokenizer is broken.", e);
        }
        this.in.pushBack(ch);
        return true;
    }

    private boolean nmstartMacro(int ch, StringBuilder buf) throws IOException {
        if (ch == 95 || 97 <= ch && ch <= 122 || 65 <= ch && ch <= 90) {
            buf.append((char)ch);
            return true;
        }
        if (ch > 159) {
            buf.append((char)ch);
            return true;
        }
        if (ch == 92) {
            return this.escapeMacro(ch, buf);
        }
        return false;
    }

    private boolean escapeMacro(int ch, StringBuilder buf) throws IOException {
        if (ch == 92) {
            ch = this.in.nextChar();
            if (48 <= ch && ch <= 57 || 97 <= ch && ch <= 102 || 65 <= ch && ch <= 70) {
                return this.unicodeAfterBackslashMacro(ch, buf);
            }
            if (ch == 10) {
                this.in.pushBack(ch);
                return false;
            }
            buf.append((char)ch);
            return true;
        }
        return false;
    }

    private int hexToInt(int ch) {
        if (48 <= ch && ch <= 57) {
            return ch - 48;
        }
        if (97 <= ch && ch <= 102) {
            return ch - 97 + 10;
        }
        if (65 <= ch && ch <= 70) {
            return ch - 65 + 10;
        }
        return -1;
    }

    private boolean unicodeAfterBackslashMacro(int ch, StringBuilder buf) throws IOException {
        int count;
        int unicodeScalar = this.hexToInt(ch);
        if (unicodeScalar < 0) {
            return false;
        }
        ch = this.in.nextChar();
        int digit = this.hexToInt(ch);
        for (count = 1; digit != -1 && count < 6; ++count) {
            unicodeScalar = unicodeScalar << 4 | digit;
            ch = this.in.nextChar();
            digit = this.hexToInt(ch);
        }
        if (count < 6) {
            switch (ch) {
                case 9: 
                case 10: 
                case 32: {
                    break;
                }
                default: {
                    this.in.pushBack(ch);
                    break;
                }
            }
        } else {
            this.in.pushBack(ch);
        }
        ch = unicodeScalar;
        if (!(0 <= ch && ch <= 55295 || 57344 <= ch && ch <= 0x110000)) {
            ch = 65533;
        }
        if (ch >= 65536) {
            int wxy = ch - 65536;
            int high = 0xD800 | wxy >> 10;
            int low = 0xDC00 | wxy & 0x3FF;
            buf.append((char)high);
            buf.append((char)low);
        } else {
            buf.append((char)ch);
        }
        return true;
    }

    private boolean nmcharMacro(int ch, StringBuilder buf) throws IOException {
        if (ch == 95 || 97 <= ch && ch <= 122 || 65 <= ch && ch <= 90 || 48 <= ch && ch <= 57 || ch == 45) {
            buf.append((char)ch);
            return true;
        }
        if (ch > 159) {
            buf.append((char)ch);
            return true;
        }
        if (ch == 92) {
            return this.escapeMacro(ch, buf);
        }
        return false;
    }

    private boolean commentAfterSlashStarMacro(StringBuilder buf) throws IOException {
        int ch = this.in.nextChar();
        while (ch != -1) {
            if (ch == 42) {
                ch = this.in.nextChar();
                if (ch == 47) {
                    return true;
                }
                buf.append('*');
                continue;
            }
            buf.append((char)ch);
            ch = this.in.nextChar();
        }
        return false;
    }

    private boolean uriMacro(StringBuilder buf) throws IOException {
        int ch = this.in.nextChar();
        while (ch == 32 || ch == 10 || ch == 9) {
            ch = this.in.nextChar();
        }
        if (ch == 39 || ch == 34) {
            if (!this.uriStringMacro(ch, buf)) {
                return false;
            }
            ch = this.in.nextChar();
        } else {
            while (true) {
                if (ch == 33 || ch == 35 || ch == 36 || ch == 37 || ch == 38 || 42 <= ch && ch <= 91 || 93 <= ch && ch <= 126 || ch > 159) {
                    buf.append((char)ch);
                } else if (ch != 39 || !this.escapeMacro(ch, buf)) break;
                ch = this.in.nextChar();
            }
        }
        while (ch == 32 || ch == 10 || ch == 9) {
            ch = this.in.nextChar();
        }
        if (ch == 41) {
            return true;
        }
        this.in.pushBack(ch);
        return false;
    }

    private boolean stringMacro(int ch, StringBuilder buf) throws IOException {
        int quote = ch;
        if (quote != 39 && quote != 34) {
            throw new IllegalArgumentException("Illegal quote character=\"" + (char)ch + "\".");
        }
        while ((ch = this.in.nextChar()) >= 0) {
            if (ch == 92) {
                if (this.escapeMacro(ch, buf)) continue;
                int nextch = this.in.nextChar();
                if (nextch == 10) {
                    buf.append('\n');
                    continue;
                }
                this.in.pushBack(nextch);
                this.in.pushBack(ch);
                return false;
            }
            if (ch == 10) {
                this.in.pushBack(ch);
                return false;
            }
            if (ch == quote) {
                return true;
            }
            buf.append((char)ch);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean uriStringMacro(int ch, StringBuilder buf) throws IOException {
        quote = ch;
        if (quote != 39 && quote != 34) {
            throw new IllegalArgumentException("Illegal quote character=\"" + (char)ch + "\".");
        }
        block0: while (true) {
            if ((ch = this.in.nextChar()) < 0) {
                return false;
            }
            if (ch == 92) {
                if (this.escapeMacro(ch, buf)) continue;
                nextch = this.in.nextChar();
                if (nextch == 10) {
                    buf.append("%0a");
                    continue;
                }
                this.in.pushBack(nextch);
                this.in.pushBack(ch);
                return false;
            }
            if (ch == 10) {
                this.in.pushBack(ch);
                return false;
            }
            if (ch == quote) {
                return true;
            }
            if (ch < StreamCssTokenizer.safeUriChars.length && StreamCssTokenizer.safeUriChars[ch]) {
                buf.append((char)ch);
                continue;
            }
            if (ch == 32) {
                buf.append('+');
                continue;
            }
            var5_6 = bytes = Character.toString(ch).getBytes(StandardCharsets.UTF_8);
            var6_7 = var5_6.length;
            var7_8 = 0;
            while (true) {
                if (var7_8 < var6_7) ** break;
                continue block0;
                b = var5_6[var7_8];
                buf.append("%");
                buf.append(StreamCssTokenizer.hexChars[b >>> 4]);
                buf.append(StreamCssTokenizer.hexChars[b & 15]);
                ++var7_8;
            }
            break;
        }
    }

    @Override
    public int getStartPosition() {
        return this.startPosition;
    }

    @Override
    public int getEndPosition() {
        return this.endPosition;
    }

    @Override
    public int getNextPosition() {
        return this.pushBack ? this.startPosition : this.endPosition;
    }

    private void skipWhitespace() throws IOException {
        while (this.nextNoSkip() == -16 || this.currentToken == -15 || this.currentToken == -14) {
        }
        this.pushBack();
    }

    @Override
    public @Nullable CssToken getToken() {
        return new CssToken(this.currentToken, this.stringValue, this.numericValue, this.lineNumber, this.startPosition, this.endPosition);
    }

    static {
        Arrays.fill(safeUriChars, 97, 123, true);
        Arrays.fill(safeUriChars, 65, 91, true);
        Arrays.fill(safeUriChars, 48, 58, true);
        Arrays.fill(safeUriChars, 46, 47, true);
        Arrays.fill(safeUriChars, 45, 46, true);
        Arrays.fill(safeUriChars, 42, 43, true);
        Arrays.fill(safeUriChars, 37, 38, true);
        Arrays.fill(safeUriChars, 43, 44, true);
        Arrays.fill(safeUriChars, 34, 35, true);
        Arrays.fill(safeUriChars, 39, 40, true);
        Arrays.fill(safeUriChars, 47, 48, true);
        Arrays.fill(safeUriChars, 95, 96, true);
        Arrays.fill(safeUriChars, 58, 59, true);
        Arrays.fill(safeUriChars, 44, 45, true);
        hexChars = new char[16];
        for (int i = 0; i < 16; ++i) {
            StreamCssTokenizer.hexChars[i] = (char)(i < 10 ? 48 + i : 65 + i - 10);
        }
    }
}

