/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.value;

import java.util.Objects;
import org.jhotdraw8.css.value.CssSizeWithUnits;
import org.jhotdraw8.css.value.DefaultUnitConverter;
import org.jhotdraw8.css.value.UnitConverter;
import org.jspecify.annotations.Nullable;

public class CssSize {
    public static final CssSize ZERO = new CssSize(0.0);
    public static final CssSize ONE = new CssSize(1.0);
    private final double value;

    CssSize(double value) {
        this.value = value;
    }

    public static CssSize of(double value, @Nullable String units) {
        boolean hasDefaultUnits;
        boolean bl = hasDefaultUnits = units == null || units.equals("");
        if (hasDefaultUnits) {
            if (value == 0.0) {
                return ZERO;
            }
            if (value == 1.0) {
                return ONE;
            }
        }
        return hasDefaultUnits ? new CssSize(value) : new CssSizeWithUnits(value, units);
    }

    public static CssSize of(double value) {
        return CssSize.of(value, null);
    }

    public static CssSize max(CssSize a, CssSize b) {
        return a.getConvertedValue() >= b.getConvertedValue() ? a : b;
    }

    public static CssSize min(CssSize a, CssSize b) {
        return a.getConvertedValue() <= b.getConvertedValue() ? a : b;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CssSize)) {
            return false;
        }
        CssSize other = (CssSize)obj;
        if (Double.doubleToLongBits(this.value) != Double.doubleToLongBits(other.value)) {
            return false;
        }
        return Objects.equals(this.getUnits(), other.getUnits());
    }

    public double getConvertedValue() {
        return DefaultUnitConverter.getInstance().convert(this, "");
    }

    public double getConvertedValue(UnitConverter converter) {
        return converter.convert(this, "");
    }

    public double getConvertedValue(UnitConverter converter, String units) {
        return converter.convert(this, units);
    }

    public String getUnits() {
        return "";
    }

    public double getValue() {
        return this.value;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.getUnits());
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.value) ^ Double.doubleToLongBits(this.value) >>> 32);
        return hash;
    }

    public String toString() {
        return "CssSize{" + this.value + this.getUnits() + "}";
    }

    public CssSize subtract(CssSize that) {
        return this.subtract(that, DefaultUnitConverter.getInstance());
    }

    public CssSize add(CssSize that) {
        return this.add(that, DefaultUnitConverter.getInstance());
    }

    public CssSize subtract(CssSize that, UnitConverter unitConverter) {
        return CssSize.of(this.value - unitConverter.convert(that, this.getUnits()), this.getUnits());
    }

    public CssSize add(CssSize that, UnitConverter unitConverter) {
        return CssSize.of(this.value + unitConverter.convert(that, this.getUnits()), this.getUnits());
    }

    public CssSize abs() {
        return this.value >= 0.0 ? this : CssSize.of(Math.abs(this.value), this.getUnits());
    }

    public CssSize multiply(double factor) {
        return CssSize.of(this.value * factor, this.getUnits());
    }

    public CssSize divide(double divisor) {
        return CssSize.of(this.value / divisor, this.getUnits());
    }
}

