/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlySetProperty;
import javafx.collections.ObservableSet;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.tool.Tool;
import org.jhotdraw8.fxbase.beans.NonNullObjectProperty;
import org.jhotdraw8.fxbase.undo.FXUndoManager;

public interface DrawingEditor {
    public static final String HELP_TEXT_PROPERTY = "helpText";
    public static final String HANDLE_TYPE_PROPERTY = "handleType";
    public static final String MULTI_HANDLE_TYPE_PROPERTY = "multiHandleType";
    public static final String HANDLE_SIZE_PROPERTY = "handleSize";
    public static final String TOLERANCE_PROPERTY = "tolerance";
    public static final String HANDLE_STROKE_WDITH_PROPERTY = "handleStrokeWidth";
    public static final String HANDLE_COLOR_PROPERTY = "handleColor";
    public static final String DRAWING_VIEWS_PROPERTY = "drawingViews";
    public static final String ACTIVE_DRAWING_VIEW_PROPERTY = "activeDrawingView";
    public static final String ACTIVE_TOOL_PROPERTY = "activeTool";
    public static final String DEFAULT_TOOL_PROPERTY = "defaultTool";
    public static final String UNDO_MANAGER_PROPERTY = "undoManager";

    public @NonNull ReadOnlySetProperty<DrawingView> drawingViewsProperty();

    public @NonNull ObjectProperty<DrawingView> activeDrawingViewProperty();

    public @NonNull ObjectProperty<Tool> activeToolProperty();

    public @NonNull ObjectProperty<Tool> defaultToolProperty();

    default public void addDrawingView(DrawingView drawingView) {
        this.drawingViewsProperty().add((Object)drawingView);
    }

    default public void removeDrawingView(DrawingView drawingView) {
        this.drawingViewsProperty().remove((Object)drawingView);
    }

    default public @Nullable DrawingView getActiveDrawingView() {
        return (DrawingView)this.activeDrawingViewProperty().get();
    }

    default public ObservableSet<DrawingView> getDrawingViews() {
        return (ObservableSet)this.drawingViewsProperty().get();
    }

    default public void setActiveDrawingView(@Nullable DrawingView drawingView) {
        this.activeDrawingViewProperty().set((Object)drawingView);
    }

    default public @Nullable Tool getActiveTool() {
        return (Tool)this.activeToolProperty().get();
    }

    default public void setActiveTool(@Nullable Tool tool) {
        this.activeToolProperty().set((Object)tool);
    }

    default public @Nullable Tool getDefaultTool() {
        return (Tool)this.defaultToolProperty().get();
    }

    default public void setDefaultTool(@Nullable Tool tool) {
        this.defaultToolProperty().set((Object)tool);
    }

    public @NonNull ObjectProperty<String> helpTextProperty();

    default public String getHelpText() {
        return (String)this.helpTextProperty().get();
    }

    default public void setHelpText(String newValue) {
        this.helpTextProperty().set((Object)newValue);
    }

    public DoubleProperty handleSizeProperty();

    public DoubleProperty toleranceProperty();

    public DoubleProperty handleStrokeWidthProperty();

    default public double getHandleSize() {
        return this.handleSizeProperty().get();
    }

    default public void setHandleSize(double newValue) {
        this.handleSizeProperty().set(newValue);
    }

    default public void setTolerance(double newValue) {
        this.toleranceProperty().set(newValue);
    }

    public NonNullObjectProperty<CssColor> handleColorProperty();

    default public CssColor getHandleColor() {
        return (CssColor)this.handleColorProperty().get();
    }

    default public void setHandleColor(CssColor newValue) {
        this.handleColorProperty().set((Object)newValue);
    }

    default public double getHandleStrokeWidth() {
        return this.handleStrokeWidthProperty().get();
    }

    default public void setHandleStrokeWidth(double newValue) {
        this.handleStrokeWidthProperty().set(newValue);
    }

    default public void recreateHandles() {
        for (DrawingView drawingView : this.getDrawingViews()) {
            drawingView.recreateHandles();
        }
    }

    default public void setHandleType(@Nullable HandleType newValue) {
        this.handleTypeProperty().set((Object)newValue);
    }

    default public @Nullable HandleType getHandleType() {
        return (HandleType)this.handleTypeProperty().get();
    }

    public @NonNull ObjectProperty<HandleType> anchorHandleTypeProperty();

    public @NonNull ObjectProperty<HandleType> leadHandleTypeProperty();

    default public void setAnchorHandleType(@Nullable HandleType newValue) {
        this.anchorHandleTypeProperty().set((Object)newValue);
    }

    default public @Nullable HandleType getAnchorHandleType() {
        return (HandleType)this.anchorHandleTypeProperty().get();
    }

    default public void setLeadHandleType(@Nullable HandleType newValue) {
        this.leadHandleTypeProperty().set((Object)newValue);
    }

    default public @Nullable HandleType getLeadHandleType() {
        return (HandleType)this.leadHandleTypeProperty().get();
    }

    public @NonNull NonNullObjectProperty<HandleType> handleTypeProperty();

    default public double getTolerance() {
        return this.toleranceProperty().get();
    }

    public @NonNull NonNullObjectProperty<HandleType> multiHandleTypeProperty();

    default public void setMultiHandleType(@Nullable HandleType newValue) {
        this.multiHandleTypeProperty().set((Object)newValue);
    }

    default public @Nullable HandleType getMultiHandleType() {
        return (HandleType)this.multiHandleTypeProperty().get();
    }

    public @NonNull NonNullObjectProperty<FXUndoManager> undoManagerProperty();

    default public void setUndoManager(@NonNull FXUndoManager newValue) {
        this.undoManagerProperty().set((Object)newValue);
    }

    default public @NonNull FXUndoManager getUndoManager() {
        return (FXUndoManager)this.undoManagerProperty().get();
    }
}

