/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.action;

import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javax.swing.event.UndoableEditEvent;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.action.AbstractAction;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.fxbase.binding.CustomBinding;
import org.jhotdraw8.fxbase.undo.UndoableEditHelper;

public abstract class AbstractDrawingViewAction
extends AbstractAction {
    private final @NonNull DrawingEditor editor;
    protected final @NonNull UndoableEditHelper undoHelper = new UndoableEditHelper((Object)this, this::forwardUndoableEdit);

    public AbstractDrawingViewAction(@NonNull DrawingEditor editor) {
        this.editor = editor;
        SimpleBooleanProperty editorHasNoDrawingViewOrDrawingViewIsDisabledProperty = new SimpleBooleanProperty();
        CustomBinding.bind((Property)editorHasNoDrawingViewOrDrawingViewIsDisabledProperty, editor.activeDrawingViewProperty(), drawingView -> drawingView == null ? new SimpleBooleanProperty(true) : drawingView.getNode().disableProperty());
        CustomBinding.bindMembershipToBoolean((ObservableSet)this.disablers(), (Object)new Object(), (ObservableValue)editorHasNoDrawingViewOrDrawingViewIsDisabledProperty);
    }

    public void forwardUndoableEdit(@NonNull UndoableEditEvent event) {
        this.editor.getUndoManager().undoableEditHappened(event);
    }

    public @NonNull DrawingEditor getEditor() {
        return this.editor;
    }

    protected @Nullable DrawingView getView() {
        return this.editor.getActiveDrawingView();
    }

    protected void onActionPerformed(@NonNull ActionEvent event) {
        DrawingView view = this.getView();
        if (view != null) {
            this.undoHelper.startCompositeEdit(null);
            this.onActionPerformed(event, view);
            this.undoHelper.stopCompositeEdit();
        }
    }

    protected abstract void onActionPerformed(@NonNull ActionEvent var1, @NonNull DrawingView var2);
}

