/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.action;

import java.util.Set;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javafx.geometry.Point2D;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.action.AbstractDrawingViewAction;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.geom.FXTransforms;

public class AlignLeftAction
extends AbstractDrawingViewAction {
    public static final String ID = "edit.alignLeft";

    public AlignLeftAction(@NonNull DrawingEditor editor) {
        super(editor);
        Resources labels = DrawLabels.getResources();
        labels.configureAction((Action)this, ID);
    }

    @Override
    protected void onActionPerformed(@NonNull ActionEvent e, @NonNull DrawingView drawingView) {
        ObservableSet<Figure> figures = drawingView.getSelectedFigures();
        Figure lead = drawingView.getSelectionLead();
        this.alignLeft(drawingView, (Set<Figure>)figures, lead);
    }

    private void alignLeft(@NonNull DrawingView view, @NonNull Set<Figure> figures, @Nullable Figure lead) {
        if (figures.size() < 2 || lead == null) {
            return;
        }
        DrawingModel model = view.getModel();
        double xInWorld = lead.getLayoutBoundsInWorld().getMinX();
        Point2D xPointInWorld = new Point2D(xInWorld, 0.0);
        for (Figure f : figures) {
            if (f == lead || !f.isEditable()) continue;
            double desiredX = FXTransforms.transform((Transform)f.getWorldToParent(), (Point2D)xPointInWorld).getX();
            double actualX = f.getLayoutBoundsInParent().getMinX();
            double dx = desiredX - actualX;
            Translate tx = new Translate(dx, 0.0);
            model.transformInParent(f, (Transform)tx);
            model.fireLayoutInvalidated(f);
        }
    }
}

