/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.action;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import javafx.event.ActionEvent;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.action.AbstractDrawingViewAction;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.fxcollection.typesafekey.Key;

public class RemoveTransformationsAction
extends AbstractDrawingViewAction {
    public static final String ID = "edit.removeTransformations";

    public RemoveTransformationsAction(@NonNull DrawingEditor editor) {
        super(editor);
        Resources labels = DrawLabels.getResources();
        labels.configureAction((Action)this, ID);
    }

    @Override
    protected void onActionPerformed(@NonNull ActionEvent e, @NonNull DrawingView drawingView) {
        LinkedList<Figure> figures = new LinkedList<Figure>((Collection<Figure>)drawingView.getSelectedFigures());
        RemoveTransformationsAction.removeTransformations(drawingView, figures);
    }

    public static void removeTransformations(@NonNull DrawingView view, @NonNull Collection<Figure> figures) {
        Set<Key<?>> keys = TransformableFigure.getDeclaredKeys();
        DrawingModel model = view.getModel();
        for (Figure child : figures) {
            if (!(child instanceof TransformableFigure)) continue;
            for (Key<?> k : keys) {
                model.remove(child, k);
            }
        }
    }
}

