/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.action;

import java.util.Collection;
import java.util.LinkedList;
import javafx.event.ActionEvent;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.action.AbstractDrawingViewAction;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.model.DrawingModel;

public class SendToBackAction
extends AbstractDrawingViewAction {
    public static final String ID = "edit.sendToBack";

    public SendToBackAction(@NonNull DrawingEditor editor) {
        super(editor);
        Resources labels = DrawLabels.getResources();
        labels.configureAction((Action)this, ID);
    }

    @Override
    protected void onActionPerformed(@NonNull ActionEvent e, @NonNull DrawingView dview) {
        LinkedList<Figure> figures = new LinkedList<Figure>((Collection<Figure>)dview.getSelectedFigures());
        this.sendToBack(dview, figures);
    }

    public void sendToBack(@NonNull DrawingView view, @NonNull Collection<Figure> figures) {
        DrawingModel model = view.getModel();
        for (Figure child : figures) {
            Figure parent = child.getParent();
            if (parent == null || !parent.isEditable() || !parent.isDecomposable()) continue;
            assert (parent.isAllowsChildren());
            model.insertChildAt(child, parent, 0);
        }
    }
}

