/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import javafx.event.ActionEvent;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.action.AbstractDrawingViewAction;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Grouping;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class UngroupAction
extends AbstractDrawingViewAction {
    public static final String ID = "edit.ungroup";

    public UngroupAction(@NonNull DrawingEditor editor) {
        super(editor);
        Resources labels = DrawLabels.getResources();
        labels.configureAction((Action)this, ID);
    }

    @Override
    protected void onActionPerformed(@NonNull ActionEvent e, @NonNull DrawingView dview) {
        LinkedList<Figure> figures = new LinkedList<Figure>((Collection<Figure>)dview.getSelectedFigures());
        UngroupAction.ungroup(dview, figures);
    }

    public static void ungroup(@NonNull DrawingView view, @NonNull Collection<Figure> figures) {
        if (figures.isEmpty()) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION, "Empty selection can not be ungrouped", new ButtonType[0]);
            alert.getDialogPane().setMaxWidth(640.0);
            alert.showAndWait();
            return;
        }
        for (Figure f : figures) {
            Alert alert;
            if (!(f instanceof Grouping)) {
                alert = new Alert(Alert.AlertType.INFORMATION, "Only groups can be ungrouped", new ButtonType[0]);
                alert.getDialogPane().setMaxWidth(640.0);
                alert.showAndWait();
                return;
            }
            if (!(f == null || f.isEditable() && f.isDecomposable())) {
                alert = new Alert(Alert.AlertType.INFORMATION, "Only editable and decomposable figures can be ungrouped", new ButtonType[0]);
                alert.getDialogPane().setMaxWidth(640.0);
                alert.showAndWait();
                return;
            }
            Figure parent = f.getParent();
            if (parent != null && parent.isEditable() && parent.isDecomposable()) continue;
            Alert alert2 = new Alert(Alert.AlertType.INFORMATION, "Only groups in editable and decomposable parents can be ungrouped", new ButtonType[0]);
            alert2.getDialogPane().setMaxWidth(640.0);
            alert2.showAndWait();
            return;
        }
        LinkedHashSet<Figure> newSelection = new LinkedHashSet<Figure>();
        for (Figure f : figures) {
            UngroupAction.ungroup(view, f, newSelection);
        }
        view.getSelectedFigures().clear();
        view.getSelectedFigures().addAll(newSelection);
    }

    private static void ungroup(@NonNull DrawingView view, @NonNull Figure group, @NonNull LinkedHashSet<Figure> newSelection) {
        Figure parent = group.getParent();
        if (!(parent == null || parent.isEditable() && parent.isDecomposable())) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION, "Only groups in editable and decomposable parents can be ungrouped", new ButtonType[0]);
            alert.getDialogPane().setMaxWidth(640.0);
            alert.showAndWait();
            return;
        }
        DrawingModel model = view.getModel();
        Transform groupTransform = group.getLocalToParent();
        if (groupTransform.isIdentity()) {
            groupTransform = null;
        }
        boolean isGroupTranslateScaleRotateOnly = group.get((MapAccessor)TransformableFigure.TRANSFORMS) == null || ((ImmutableList)group.get((MapAccessor)TransformableFigure.TRANSFORMS)).isEmpty();
        int index = parent.getChildren().indexOf((Object)group);
        newSelection.addAll((Collection<Figure>)group.getChildren());
        for (Figure child : new ArrayList<Figure>((Collection<Figure>)group.getChildren())) {
            model.insertChildAt(child, parent, index++);
            if (groupTransform == null) continue;
            model.transformInParent(child, groupTransform);
        }
        model.removeFromParent(group);
    }
}

