/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.connector;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javafx.geometry.Bounds;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.Lines;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.intersect.IntersectLineRectangle;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;

public interface Connector {
    public @NonNull PointAndDerivative getPointAndDerivativeInLocal(@NonNull Figure var1, @NonNull Figure var2);

    default public @NonNull PointAndDerivative getPointAndDerivativeInWorld(Figure connection, Figure target) {
        PointAndDerivative inLocal = this.getPointAndDerivativeInLocal(connection, target);
        Transform localToWorld = target.getLocalToWorld();
        javafx.geometry.Point2D pointInWorld = FXTransforms.transform((Transform)localToWorld, (javafx.geometry.Point2D)((javafx.geometry.Point2D)inLocal.getPoint(javafx.geometry.Point2D::new)));
        javafx.geometry.Point2D derivativeInWorld = FXTransforms.deltaTransform((Transform)localToWorld, (javafx.geometry.Point2D)((javafx.geometry.Point2D)inLocal.getDerivative(javafx.geometry.Point2D::new)));
        return new PointAndDerivative(pointInWorld.getX(), pointInWorld.getY(), derivativeInWorld.getX(), derivativeInWorld.getY());
    }

    default public IntersectionPointEx chopStart(RenderContext ctx, Figure connection, @NonNull Figure target, double sx, double sy, double ex, double ey) {
        return this.chopStart(ctx, connection, target, new javafx.geometry.Point2D(sx, sy), new javafx.geometry.Point2D(ex, ey));
    }

    default public IntersectionPointEx chopStart(RenderContext ctx, Figure connection, @NonNull Figure target, @NonNull javafx.geometry.Point2D start, @NonNull javafx.geometry.Point2D end) {
        IntersectionPointEx ip = this.intersect(ctx, connection, target, start, end);
        javafx.geometry.Point2D derivative = end.subtract(start);
        return ip == null ? new IntersectionPointEx(start.getX(), start.getY(), 0.0, derivative.getX(), derivative.getY(), 0.0, derivative.getX(), derivative.getY()) : new IntersectionPointEx(Lines.lerp((double)start.getX(), (double)start.getY(), (double)end.getX(), (double)end.getY(), (double)ip.getArgumentA()), ip.getArgumentA(), ip.getDerivativeA(), ip.getArgumentB(), ip.getDerivativeB());
    }

    default public @Nullable IntersectionPointEx intersect(RenderContext ctx, Figure connection, @NonNull Figure target, @NonNull javafx.geometry.Point2D start, @NonNull javafx.geometry.Point2D end) {
        javafx.geometry.Point2D s = target.worldToLocal(start);
        javafx.geometry.Point2D e = target.worldToLocal(end);
        Bounds b = target.getLayoutBounds();
        IntersectionResultEx i = IntersectLineRectangle.intersectLineRectangleEx((Point2D)new Point2D.Double(s.getX(), s.getY()), (Point2D)new Point2D.Double(e.getX(), e.getY()), (Rectangle2D.Double)new Rectangle2D.Double(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight()));
        return (IntersectionPointEx)i.intersections().peekLast();
    }
}

