/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.connector;

import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.shape.StrokeType;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.connector.LocatorConnector;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.StrokableFigure;
import org.jhotdraw8.draw.locator.BoundsLocator;
import org.jhotdraw8.draw.locator.Locator;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXRectangles;
import org.jhotdraw8.geom.intersect.IntersectAABBLine;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;

public class RectangleConnector
extends LocatorConnector {
    public RectangleConnector() {
        super(BoundsLocator.CENTER);
    }

    public RectangleConnector(Locator locator) {
        super(locator);
    }

    @Override
    public @Nullable IntersectionPointEx intersect(RenderContext ctx, Figure connection, @NonNull Figure target, @NonNull Point2D start, @NonNull Point2D end) {
        Point2D s = target.worldToLocal(start);
        Point2D e = target.worldToLocal(end);
        Bounds bounds = target.getLayoutBounds();
        if (target.getStyled((MapAccessor)StrokableFigure.STROKE) != null) {
            double grow = switch ((StrokeType)target.getStyledNonNull((NonNullMapAccessor)StrokableFigure.STROKE_TYPE)) {
                default -> ((CssSize)target.getStyledNonNull((NonNullMapAccessor)StrokableFigure.STROKE_WIDTH)).getConvertedValue() / 2.0;
                case StrokeType.OUTSIDE -> ((CssSize)target.getStyledNonNull((NonNullMapAccessor)StrokableFigure.STROKE_WIDTH)).getConvertedValue();
                case StrokeType.INSIDE -> 0.0;
            };
            bounds = FXRectangles.grow((Bounds)bounds, (double)grow, (double)grow);
        }
        IntersectionResultEx i = IntersectAABBLine.intersectLineAABBEx((double)s.getX(), (double)s.getY(), (double)e.getX(), (double)e.getY(), (double)bounds.getMinX(), (double)bounds.getMinY(), (double)bounds.getMaxX(), (double)bounds.getMaxY());
        return (IntersectionPointEx)i.intersections().peekLast();
    }
}

