/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.constrain;

import java.util.Map;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.scene.shape.Path;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.constrain.AbstractConstrainer;
import org.jhotdraw8.draw.constrain.Constrainer;
import org.jhotdraw8.draw.constrain.NullConstrainer;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.fxbase.beans.NonNullObjectProperty;

public class FigureSpecificConstrainer
extends AbstractConstrainer
implements Constrainer {
    private final Path node = new Path();
    public final String CONSTRAINER_MAP_PROPERTY = "constrainerMap";
    public final String DEFAULT_CONSTRAINER_PROPERTY = "defaultConstrainer";
    private final ReadOnlyMapWrapper<Class<?>, Constrainer> constrainerMap = new ReadOnlyMapWrapper((Object)this, "CONSTRAINER_MAP_PROPERTY", FXCollections.observableHashMap());
    private final NonNullObjectProperty<Constrainer> defaultConstrainer = new NonNullObjectProperty((Object)this, "defaultConstrainer", (Object)new NullConstrainer());

    public @NonNull ObservableMap<Class<?>, Constrainer> constrainerMapProperty() {
        return this.constrainerMap;
    }

    public @NonNull NonNullObjectProperty<Constrainer> defaultConstrainerProperty() {
        return this.defaultConstrainer;
    }

    public Map<Class<?>, Constrainer> getConstrainerMap() {
        return this.constrainerMap.get();
    }

    public Constrainer getDefaultConstrainer() {
        return (Constrainer)this.defaultConstrainer.get();
    }

    public void setDefaultConstrainer(Constrainer newValue) {
        this.defaultConstrainer.set((Object)newValue);
    }

    private Constrainer getConstrainer(@NonNull Figure f) {
        Constrainer c = (Constrainer)this.constrainerMap.get(f.getClass());
        return c != null ? c : (Constrainer)this.defaultConstrainer.get();
    }

    @Override
    public CssPoint2D translatePoint(@NonNull Figure f, CssPoint2D p, CssPoint2D dir) {
        return this.getConstrainer(f).translatePoint(f, p, dir);
    }

    @Override
    public CssRectangle2D translateRectangle(@NonNull Figure f, CssRectangle2D r, CssPoint2D dir) {
        return this.getConstrainer(f).translateRectangle(f, r, dir);
    }

    @Override
    public double translateAngle(@NonNull Figure f, double angle, double dir) {
        return this.getConstrainer(f).translateAngle(f, angle, dir);
    }

    @Override
    public CssPoint2D constrainPoint(@NonNull Figure f, CssPoint2D p) {
        return this.getConstrainer(f).constrainPoint(f, p);
    }

    @Override
    public CssRectangle2D constrainRectangle(@NonNull Figure f, CssRectangle2D r) {
        return this.getConstrainer(f).constrainRectangle(f, r);
    }

    @Override
    public double constrainAngle(@NonNull Figure f, double angle) {
        return this.getConstrainer(f).constrainAngle(f, angle);
    }

    @Override
    public @NonNull Node getNode() {
        return this.node;
    }

    @Override
    public void updateNode(DrawingView drawingView) {
    }
}

