/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.constrain;

import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.DefaultUnitConverter;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.constrain.AbstractConstrainer;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.ViewBoxableDrawing;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;

public class GridConstrainer
extends AbstractConstrainer {
    private final Point2D UP = new Point2D(0.0, 1.0);
    private final DoubleProperty angle = new SimpleDoubleProperty(this, "angle"){

        public void invalidated() {
            GridConstrainer.this.fireInvalidated((Observable)this);
        }
    };
    private final BooleanProperty drawGrid = new SimpleBooleanProperty(this, "drawGrid"){

        public void invalidated() {
            GridConstrainer.this.fireInvalidated();
        }
    };
    private final ObjectProperty<CssSize> height = new SimpleObjectProperty<CssSize>((Object)this, "height"){

        public void invalidated() {
            GridConstrainer.this.fireInvalidated();
        }
    };
    private final @NonNull ObjectProperty<CssColor> gridColorProperty = new SimpleObjectProperty<CssColor>((Object)this, "majorGridColor", new CssColor("hsba(226,100%,75%,40%)", Color.hsb((double)226.0, (double)1.0, (double)0.75, (double)0.4))){

        public void invalidated() {
            GridConstrainer.this.fireInvalidated();
        }
    };
    private final Path majorNode = new Path();
    private final IntegerProperty majorX = new SimpleIntegerProperty(this, "major-x", 5){

        public void invalidated() {
            GridConstrainer.this.fireInvalidated();
        }
    };
    private final IntegerProperty majorY = new SimpleIntegerProperty(this, "major-y", 5){

        public void invalidated() {
            GridConstrainer.this.fireInvalidated();
        }
    };
    private final Path minorNode = new Path();
    private final Group node = new Group();
    private final BooleanProperty snapToGrid = new SimpleBooleanProperty(this, "snapToGrid", true){

        public void invalidated() {
            GridConstrainer.this.fireInvalidated();
        }
    };
    private final ObjectProperty<CssSize> width = new SimpleObjectProperty<CssSize>((Object)this, "width"){

        public void invalidated() {
            GridConstrainer.this.fireInvalidated();
        }
    };
    private final ObjectProperty<CssSize> x = new SimpleObjectProperty<CssSize>((Object)this, "x"){

        public void invalidated() {
            GridConstrainer.this.fireInvalidated();
        }
    };
    private final ObjectProperty<CssSize> y = new SimpleObjectProperty<CssSize>((Object)this, "y"){

        public void invalidated() {
            GridConstrainer.this.fireInvalidated();
        }
    };

    public GridConstrainer() {
        this(0.0, 0.0, 10.0, 10.0, 22.5, 5, 5);
    }

    public GridConstrainer(double width, double height) {
        this(0.0, 0.0, width, height, 22.5, 5, 5);
    }

    public GridConstrainer(double x, double y, double width, double height, double angle, int majorx, int majory) {
        this(CssSize.of((double)x), CssSize.of((double)y), CssSize.of((double)width), CssSize.of((double)height), angle, majorx, majory);
    }

    public GridConstrainer(CssSize x, CssSize y, CssSize width, CssSize height, double angle, int majorx, int majory) {
        this.x.set((Object)x);
        this.y.set((Object)y);
        this.width.set((Object)width);
        this.height.set((Object)height);
        this.angle.set(angle);
        this.minorNode.getStyleClass().setAll((Object[])new String[]{"constrainer-minor-grid"});
        this.majorNode.getStyleClass().setAll((Object[])new String[]{"constrainer-major-grid"});
        this.majorX.set(majorx);
        this.majorY.set(majory);
        this.node.getChildren().addAll((Object[])new Node[]{this.minorNode, this.majorNode});
    }

    public @NonNull DoubleProperty angleProperty() {
        return this.angle;
    }

    private boolean canSnapToGrid() {
        return this.snapToGrid.get() && this.getWidth().getValue() > 0.0 && this.getHeight().getValue() > 0.0;
    }

    public @NonNull BooleanProperty drawGridProperty() {
        return this.drawGrid;
    }

    public CssColor getGridColor() {
        return (CssColor)this.gridColorProperty.getValue();
    }

    public void setGridColor(CssColor newValue) {
        this.gridColorProperty.setValue((Object)newValue);
    }

    public CssSize getHeight() {
        return (CssSize)this.height.get();
    }

    public int getMajorX() {
        return this.majorX.get();
    }

    public int getMajorY() {
        return this.majorY.get();
    }

    @Override
    public @NonNull Node getNode() {
        return this.node;
    }

    public CssSize getWidth() {
        return (CssSize)this.width.get();
    }

    public CssSize getX() {
        return (CssSize)this.x.get();
    }

    public CssSize getY() {
        return (CssSize)this.y.get();
    }

    public @NonNull Property<CssColor> gridColorProperty() {
        return this.gridColorProperty;
    }

    public @NonNull ObjectProperty<CssSize> heightProperty() {
        return this.height;
    }

    public @NonNull IntegerProperty majorXProperty() {
        return this.majorX;
    }

    public @NonNull IntegerProperty majorYProperty() {
        return this.majorY;
    }

    public @NonNull BooleanProperty snapToGridProperty() {
        return this.snapToGrid;
    }

    @Override
    public double translateAngle(Figure f, double angle, double dir) {
        if (!this.snapToGrid.get()) {
            return angle;
        }
        double cAngle = this.angle.get();
        if (cAngle == 0.0) {
            return angle;
        }
        double ta = angle / cAngle;
        ta = Double.isNaN(dir) || dir == 0.0 ? (double)Math.round(ta) : (dir < 0.0 ? Math.floor(ta + 1.0) : Math.ceil(ta - 1.0));
        double result = ta * cAngle % 360.0;
        return result < 0.0 ? 360.0 + result : result;
    }

    @Override
    public @NonNull CssPoint2D translatePoint(Figure f, @NonNull CssPoint2D cssp, @NonNull CssPoint2D dir) {
        double ty;
        if (!this.canSnapToGrid()) {
            Point2D p = cssp.getConvertedValue();
            Point2D covertedDir = dir.getConvertedValue();
            return new CssPoint2D(p.add(covertedDir));
        }
        DefaultUnitConverter c = DefaultUnitConverter.getInstance();
        String wunits = ((CssSize)this.width.get()).getUnits();
        String hunits = ((CssSize)this.height.get()).getUnits();
        double px = c.convert(cssp.getX(), wunits);
        double py = c.convert(cssp.getY(), hunits);
        double cx = c.convert((CssSize)this.x.get(), wunits);
        double cy = c.convert((CssSize)this.y.get(), hunits);
        double cwidth = ((CssSize)this.width.get()).getValue();
        double cheight = ((CssSize)this.height.get()).getValue();
        double tx = cwidth == 0.0 ? px : (px - cx) / cwidth;
        double d = ty = cheight == 0.0 ? py : (py - cy) / cheight;
        tx = dir.getX().getValue() > 0.0 ? Math.floor(tx + 1.0) : (dir.getX().getValue() < 0.0 ? Math.ceil(tx - 1.0) : (double)Math.round(tx));
        ty = dir.getY().getValue() > 0.0 ? Math.ceil(ty) : (dir.getY().getValue() < 0.0 ? Math.floor(ty) : (double)Math.round(ty));
        double x = Math.fma(tx, cwidth, cx);
        double y = Math.fma(ty, cheight, cy);
        return new CssPoint2D(CssSize.of((double)x, (String)wunits), CssSize.of((double)y, (String)hunits));
    }

    @Override
    public @NonNull CssRectangle2D translateRectangle(Figure f, @NonNull CssRectangle2D cssr, @NonNull CssPoint2D cssdir) {
        double tmaxy;
        if (!this.canSnapToGrid()) {
            Rectangle2D r = cssr.getConvertedValue();
            Point2D dir = cssdir.getConvertedValue();
            return new CssRectangle2D(r.getMinX() + dir.getX(), r.getMinY() + dir.getY(), r.getWidth(), r.getHeight());
        }
        Rectangle2D r = cssr.getConvertedValue();
        Point2D dir = cssdir.getConvertedValue();
        double cx = ((CssSize)this.x.get()).getConvertedValue();
        double cy = ((CssSize)this.y.get()).getConvertedValue();
        double cwidth = ((CssSize)this.width.get()).getConvertedValue();
        double cheight = ((CssSize)this.height.get()).getConvertedValue();
        double tx = cwidth == 0.0 ? r.getMinX() : (r.getMinX() - cx) / cwidth;
        double ty = cheight == 0.0 ? r.getMinY() : (r.getMinY() - cy) / cheight;
        double tmaxx = cwidth == 0.0 ? r.getMaxX() : (r.getMaxX() - cx) / cwidth;
        double d = tmaxy = cheight == 0.0 ? r.getMaxY() : (r.getMaxY() - cy) / cheight;
        tx = dir.getX() > 0.0 ? (tx += Math.floor(tmaxx + 1.0) - tmaxx) : (dir.getX() < 0.0 ? Math.ceil(tx - 1.0) : (double)Math.round(tx));
        ty = dir.getY() > 0.0 ? (ty += Math.floor(tmaxy + 1.0) - tmaxy) : (dir.getY() < 0.0 ? Math.ceil(ty - 1.0) : (double)Math.round(ty));
        return new CssRectangle2D(Math.fma(tx, cwidth, cx), Math.fma(ty, cheight, cy), r.getWidth(), r.getHeight());
    }

    @Override
    public void updateNode(@NonNull DrawingView drawingView) {
        double dy;
        double dx;
        ObservableList minor = this.minorNode.getElements();
        ObservableList major = this.majorNode.getElements();
        minor.clear();
        major.clear();
        CssColor gridColor = this.getGridColor();
        this.minorNode.setStroke((Paint)(gridColor == null ? null : gridColor.getColor()));
        this.majorNode.setStroke((Paint)(gridColor == null ? null : gridColor.getColor()));
        this.minorNode.setStrokeWidth(0.5);
        this.majorNode.setStrokeWidth(1.0);
        Drawing drawing = drawingView.getDrawing();
        if (drawing instanceof ViewBoxableDrawing) {
            dx = ((CssSize)drawing.getNonNull((NonNullMapAccessor)ViewBoxableDrawing.VIEW_BOX_X)).getConvertedValue();
            dy = ((CssSize)drawing.getNonNull((NonNullMapAccessor)ViewBoxableDrawing.VIEW_BOX_Y)).getConvertedValue();
        } else {
            dx = 0.0;
            dy = 0.0;
        }
        double dw = ((CssSize)drawing.getNonNull((NonNullMapAccessor)Drawing.WIDTH)).getConvertedValue();
        double dh = ((CssSize)drawing.getNonNull((NonNullMapAccessor)Drawing.HEIGHT)).getConvertedValue();
        Bounds visibleRect = drawingView.viewToWorld(drawingView.getVisibleRect());
        if (this.drawGrid.get()) {
            Point2D p2;
            Point2D p1;
            double y2;
            double y1;
            double x1;
            int i;
            int start;
            double gmydelta;
            double gmxdelta;
            Point2D p22;
            Point2D p12;
            double y22;
            double x2;
            double y12;
            double x12;
            int i2;
            int end;
            int start2;
            Transform t = drawingView.getWorldToView();
            t = t.createConcatenation(drawing.getLocalToParent());
            double gx0 = ((CssSize)this.x.get()).getConvertedValue();
            double gy0 = ((CssSize)this.y.get()).getConvertedValue();
            double gxdelta = Math.abs(((CssSize)this.width.get()).getConvertedValue());
            double gydelta = Math.abs(((CssSize)this.height.get()).getConvertedValue());
            if (gx0 < 0.0) {
                gx0 = gx0 % gxdelta + gxdelta;
            }
            if (gy0 < 0.0) {
                gy0 = gy0 % gydelta + gydelta;
            }
            int gmx = Math.max(0, Math.abs(this.majorX.get()));
            int gmy = Math.max(0, Math.abs(this.majorY.get()));
            Point2D scaled = t.deltaTransform(gxdelta, gydelta);
            if (scaled.getX() > 2.0 && gmx != 1) {
                start2 = (int)Math.ceil((Math.max(dx, visibleRect.getMinX()) - gx0) / gxdelta);
                end = (int)Math.ceil((Math.min(dw + dx, visibleRect.getMaxX()) - gx0) / gxdelta);
                for (i2 = start2; i2 < end; ++i2) {
                    double x;
                    if (gmx > 0 && i2 % gmx == 0) continue;
                    x12 = x = gx0 + (double)i2 * gxdelta;
                    y12 = dy;
                    x2 = x;
                    y22 = dh + dy;
                    p12 = t.transform(x12, y12);
                    p22 = t.transform(x2, y22);
                    minor.add((Object)new MoveTo((double)Math.round(p12.getX()) + 0.5, p12.getY()));
                    minor.add((Object)new LineTo((double)Math.round(p22.getX()) + 0.5, p22.getY()));
                }
            }
            if (scaled.getY() > 2.0 && gmy != 1) {
                start2 = (int)Math.ceil((Math.max(dy, visibleRect.getMinY()) - gy0) / gydelta);
                end = (int)Math.ceil((Math.min(dh + dy, visibleRect.getMaxY()) - gy0) / gydelta);
                for (i2 = start2; i2 < end; ++i2) {
                    if (gmy > 0 && i2 % gmy == 0) continue;
                    double y = gy0 + (double)i2 * gydelta;
                    x12 = dx;
                    y12 = y;
                    x2 = dw + dx;
                    y22 = y;
                    p12 = t.transform(x12, y12);
                    p22 = t.transform(x2, y22);
                    minor.add((Object)new MoveTo(p12.getX(), (double)Math.round(p12.getY()) + 0.5));
                    minor.add((Object)new LineTo(p22.getX(), (double)Math.round(p22.getY()) + 0.5));
                }
            }
            if ((scaled = t.deltaTransform(gmxdelta = gxdelta * (double)gmx, gmydelta = gydelta * (double)gmy)).getX() > 2.0) {
                start = (int)Math.ceil((Math.max(dx, visibleRect.getMinX()) - gx0) / gmxdelta);
                int end2 = (int)Math.ceil((Math.min(dw + dx, visibleRect.getMaxX()) - gx0) / gmxdelta);
                for (i = start; i < end2; ++i) {
                    double x;
                    x1 = x = gx0 + (double)i * gmxdelta;
                    y1 = dy;
                    double x22 = x;
                    y2 = dh + dy;
                    p1 = t.transform(x1, y1);
                    p2 = t.transform(x22, y2);
                    major.add((Object)new MoveTo((double)Math.round(p1.getX()) + 0.5, p1.getY()));
                    major.add((Object)new LineTo((double)Math.round(p2.getX()) + 0.5, p2.getY()));
                }
            }
            if (scaled.getY() > 2.0) {
                start = (int)Math.ceil((Math.max(dy, visibleRect.getMinY()) - gy0) / gmydelta);
                int end3 = (int)Math.ceil((Math.min(dh + dy, visibleRect.getMaxY()) - gy0) / gmydelta);
                for (i = start; i < end3; ++i) {
                    double y = gy0 + (double)i * gmydelta;
                    x1 = dx;
                    y1 = y;
                    double x23 = dw + dx;
                    y2 = y;
                    p1 = t.transform(x1, y1);
                    p2 = t.transform(x23, y2);
                    major.add((Object)new MoveTo(p1.getX(), (double)Math.round(p1.getY()) + 0.5));
                    major.add((Object)new LineTo(p2.getX(), (double)Math.round(p2.getY()) + 0.5));
                }
            }
        }
    }

    public @NonNull ObjectProperty<CssSize> widthProperty() {
        return this.width;
    }

    public @NonNull ObjectProperty<CssSize> xProperty() {
        return this.x;
    }

    public @NonNull ObjectProperty<CssSize> yProperty() {
        return this.y;
    }
}

