/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.awt.geom.PathIterator;
import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.geom.PathBuilder;
import org.jhotdraw8.geom.SvgPaths;
import org.jhotdraw8.geom.shape.BezierPath;
import org.jhotdraw8.geom.shape.BezierPathBuilder;

public class BezierPathCssConverter
extends AbstractCssConverter<BezierPath> {
    public BezierPathCssConverter(boolean nullable) {
        super(nullable);
    }

    public @NonNull BezierPath parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        if (tt.next() != -4) {
            throw new ParseException("Could not convert " + String.valueOf(tt.getToken()) + " to a BezierPath.", tt.getStartPosition());
        }
        BezierPathBuilder builder = new BezierPathBuilder();
        SvgPaths.svgStringToBuilder((String)tt.currentStringNonNull(), (PathBuilder)builder);
        return builder.build();
    }

    protected <TT extends BezierPath> void produceTokensNonNull(@NonNull TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        if (value.isEmpty()) {
            out.accept(new CssToken(-2, "none"));
        } else {
            out.accept(new CssToken(-4, SvgPaths.awtPathIteratorToDoubleSvgString((PathIterator)value.getPathIterator(null))));
        }
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8BezierPath\u27e9: \"\u27e8SvgPath\u27e9\"";
    }
}

