/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.scene.paint.Color;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.FloatConverter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.base.util.MathUtil;
import org.jhotdraw8.color.CssColorSpaces;
import org.jhotdraw8.color.NamedColorSpace;
import org.jhotdraw8.color.ParametricHlsColorSpace;
import org.jhotdraw8.color.ParametricHsvColorSpace;
import org.jhotdraw8.color.ParametricScaledColorSpace;
import org.jhotdraw8.color.SrgbColorSpace;
import org.jhotdraw8.css.converter.CssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.parser.StreamCssTokenizer;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.NamedCssColor;
import org.jhotdraw8.draw.css.value.ShsbaCssColor;
import org.jhotdraw8.draw.css.value.SrgbaCssColor;
import org.jhotdraw8.draw.css.value.SystemCssColor;
import org.jhotdraw8.draw.css.value.Uint4HexSrgbaCssColor;
import org.jhotdraw8.draw.css.value.Uint8HexSrgbaCssColor;

public class ColorCssConverter
implements CssConverter<CssColor> {
    private static final @NonNull FloatConverter number = new FloatConverter();
    final boolean nullable;
    private static final @NonNull NamedColorSpace CSS_SRGB_COLOR_SPACE = new SrgbColorSpace();
    private static final @NonNull NamedColorSpace CSS_LEGACY_SRGB_COLOR_SPACE = new ParametricScaledColorSpace("CSS sRGB*255", 255.0f, CSS_SRGB_COLOR_SPACE);
    private static final @NonNull NamedColorSpace CSS_HLS_COLOR_SPACE = new ParametricHlsColorSpace("CSS HSL", CSS_SRGB_COLOR_SPACE);
    private static final @NonNull NamedColorSpace JAVAFX_HSB_COLOR_SPACE = new ParametricHsvColorSpace("HSB", CSS_SRGB_COLOR_SPACE);

    public ColorCssConverter() {
        this(false);
    }

    public ColorCssConverter(boolean nullable) {
        this.nullable = nullable;
    }

    private String colorParamToString(List<CssSize> params) {
        StringBuilder buf = new StringBuilder(16);
        for (int i = 0; i < params.size(); ++i) {
            if (i > 0) {
                if (i == 3) {
                    buf.append(" / ");
                } else {
                    buf.append(' ');
                }
            }
            buf.append(number.toString((Object)Float.valueOf((float)params.get(i).getValue())));
            buf.append(params.get(i).getUnits());
        }
        return buf.toString();
    }

    public @Nullable CssColor getDefaultValue() {
        return null;
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8Color\u27e9: \u27e8name\u27e9\uff5c#\u27e8hex\u27e9\uff5crgb(\u27e8r\u27e9,\u27e8g\u27e9,\u27e8b\u27e9)\uff5crgba(\u27e8r\u27e9,\u27e8g\u27e9,\u27e8b\u27e9,\u27e8a\u27e9)\uff5chsb(\u27e8h\u27e9,\u27e8s\u27e9,\u27e8b\u27e9)\uff5chsba(\u27e8h\u27e9,\u27e8s\u27e9,\u27e8b\u27e9,\u27e8a\u27e9)";
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public @Nullable CssColor parse(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        return switch (tt.next()) {
            case -2 -> {
                tt.pushBack();
                yield this.parseNamedColor(tt);
            }
            case -11, -8 -> {
                tt.pushBack();
                yield this.parseHexColor(tt);
            }
            case -18 -> {
                tt.pushBack();
                switch (tt.currentStringNonNull().toLowerCase()) {
                    case "rgb": 
                    case "rgba": {
                        yield this.parseRgbFunction(tt);
                    }
                    case "hsl": 
                    case "hsla": {
                        yield this.parseHslFunction(tt);
                    }
                    case "hsb": 
                    case "hsba": {
                        yield this.parseHsbFunction(tt);
                    }
                    case "hwb": 
                    case "oklch": 
                    case "oklab": 
                    case "lab": {
                        yield null;
                    }
                    case "color": {
                        yield this.parseColorFunction(tt);
                    }
                }
                throw tt.createParseException("Could not convert a string to a CssColor because the function " + tt.currentStringNonNull() + "() is not supported.");
            }
            default -> throw tt.createParseException("Could not convert a string to a CssColor because unexpected " + String.valueOf(tt.getToken()) + " was found.");
        };
    }

    private @Nullable CssColor parseColorFunction(CssTokenizer tt) throws ParseException, IOException {
        NamedColorSpace cs;
        tt.requireNextToken(-18, "Could not convert a string to a CssColor because unexpected " + String.valueOf(tt.getToken()) + " was found.");
        String functionName = tt.currentStringNonNull();
        String colorSpaceParam = "srgb";
        if ("color".equals(functionName)) {
            if (tt.next() == -2) {
                colorSpaceParam = tt.currentStringNonNull().toLowerCase();
            } else {
                tt.pushBack();
            }
        }
        if ((cs = (NamedColorSpace)CssColorSpaces.COLOR_SPACES.get(colorSpaceParam)) == null) {
            throw tt.createParseException("Could not convert a string to a CssColor because the color space=\"" + colorSpaceParam + "\" is not supported.");
        }
        List<CssSize> params = ColorCssConverter.parseParams(tt, cs);
        if (tt.current() != 41) {
            throw tt.createParseException("Could not convert a string to a CssColor because the closing bracket ')' is missing.");
        }
        float[] rgb = ColorCssConverter.clampColors(params);
        return new CssColor("color(" + colorSpaceParam + " " + this.colorParamToString(params) + ")", new Color((double)rgb[0], (double)rgb[1], (double)rgb[2], params.size() == 4 ? MathUtil.clamp((double)params.get(3).getValue(), (double)0.0, (double)1.0) : 1.0));
    }

    private static @NonNull List<CssSize> parseParams(CssTokenizer tt, NamedColorSpace cs) throws IOException, ParseException {
        ArrayList<CssSize> params = new ArrayList<CssSize>();
        while (tt.next() != -1 && tt.current() != 41) {
            block0 : switch (tt.current()) {
                case -11: 
                case -10: {
                    if (params.size() > 3) {
                        throw tt.createParseException("Could not convert a string to a CssColor because the function has too many parameters.");
                    }
                    params.add(CssSize.of((double)tt.currentNumberNonNull().doubleValue(), (String)tt.currentStringNonNull()));
                    break;
                }
                case -9: {
                    if (params.size() > 3) {
                        throw tt.createParseException("Could not convert a string to a CssColor because the function has too many parameters.");
                    }
                    params.add(CssSize.of((double)tt.currentNumberNonNull().doubleValue()));
                    break;
                }
                case 44: 
                case 47: {
                    break;
                }
                case -2: {
                    switch (tt.currentStringNonNull()) {
                        case "none": {
                            if (params.size() > 3) {
                                throw tt.createParseException("Could not convert a string to a CssColor because the function has too many parameters.");
                            }
                            params.add(CssSize.ZERO);
                            break block0;
                        }
                    }
                    throw tt.createParseException("Could not convert a string to a CssColor because the identifier 'none' or a number is expected.");
                }
            }
        }
        if (params.size() < 3) {
            throw tt.createParseException("Could not convert a string to a CssColor because the function has not enough parameters.");
        }
        return params;
    }

    private static float toDeg(@NonNull CssSize size, @NonNull CssTokenizer tt) throws ParseException {
        double v = size.getValue();
        return (float)(switch (size.getUnits()) {
            case "", "deg" -> v;
            case "grad" -> v * 360.0 / 400.0;
            case "rad" -> v * 180.0 / Math.PI;
            case "turn" -> v * 360.0;
            default -> throw tt.createParseException("Could not convert a string to a color because the value " + String.valueOf(size) + " has unexpected units=\"" + size.getUnits() + "\".");
        });
    }

    private @NonNull CssColor parseRgbFunction(CssTokenizer tt) throws ParseException, IOException {
        List<CssSize> params = ColorCssConverter.parseParams(tt, CSS_LEGACY_SRGB_COLOR_SPACE);
        float[] rgb = new float[]{ColorCssConverter.toPercentage(params.get(0), 2.55, tt), ColorCssConverter.toPercentage(params.get(1), 2.55, tt), ColorCssConverter.toPercentage(params.get(2), 2.55, tt)};
        for (int i = 0; i < rgb.length; ++i) {
            rgb[i] = rgb[i] / 255.0f;
        }
        float[] clamped = ColorCssConverter.clampColors(rgb);
        float alpha = params.size() == 4 ? MathUtil.clamp((float)ColorCssConverter.toPercentage(params.get(3), 0.01, tt), (float)0.0f, (float)1.0f) : 1.0f;
        return new CssColor("rgb(" + this.colorParamToString(params) + ")", new Color((double)clamped[0], (double)clamped[1], (double)clamped[2], (double)alpha));
    }

    private @NonNull CssColor parseHslFunction(CssTokenizer tt) throws ParseException, IOException {
        List<CssSize> params = ColorCssConverter.parseParams(tt, CSS_HLS_COLOR_SPACE);
        float[] hls = new float[]{ColorCssConverter.toDeg(params.get(0), tt), ColorCssConverter.toPercentage(params.get(2), 0.01, tt), ColorCssConverter.toPercentage(params.get(1), 0.01, tt)};
        float[] rgb = ColorCssConverter.clampColors(CSS_HLS_COLOR_SPACE.toRGB(hls));
        float alpha = params.size() == 4 ? MathUtil.clamp((float)ColorCssConverter.toPercentage(params.get(3), 0.01, tt), (float)0.0f, (float)1.0f) : 1.0f;
        return new CssColor("hsl(" + this.colorParamToString(params) + ")", new Color((double)rgb[0], (double)rgb[1], (double)rgb[2], (double)alpha));
    }

    private @NonNull CssColor parseHsbFunction(CssTokenizer tt) throws ParseException, IOException {
        List<CssSize> params = ColorCssConverter.parseParams(tt, JAVAFX_HSB_COLOR_SPACE);
        float[] hsb = new float[]{ColorCssConverter.toDeg(params.get(0), tt), ColorCssConverter.toPercentage(params.get(1), 0.01, tt), ColorCssConverter.toPercentage(params.get(2), 0.01, tt)};
        float[] rgb = JAVAFX_HSB_COLOR_SPACE.toRGB(hsb);
        float[] clamped = ColorCssConverter.clampColors(rgb);
        float alpha = params.size() == 4 ? MathUtil.clamp((float)ColorCssConverter.toPercentage(params.get(3), 0.01, tt), (float)0.0f, (float)1.0f) : 1.0f;
        return new CssColor("hsb(" + this.colorParamToString(params) + ")", new Color((double)clamped[0], (double)clamped[1], (double)clamped[2], (double)alpha));
    }

    private static float[] toFloat(double[] params) {
        float[] floats = new float[3];
        for (int i = 0; i < 3; ++i) {
            floats[i] = (float)params[i];
        }
        return floats;
    }

    private static float[] toFloat(List<CssSize> params) {
        float[] floats = new float[3];
        for (int i = 0; i < 3; ++i) {
            CssSize value = params.get(i);
            floats[i] = value == null ? 0.0f : (float)value.getValue();
        }
        return floats;
    }

    private static float toPercentage(CssSize param, double percentageConversionFactor, CssTokenizer tt) {
        return switch (param.getUnits()) {
            case "%" -> (float)(param.getValue() * percentageConversionFactor);
            default -> (float)param.getValue();
        };
    }

    private static float[] clampColors(NamedColorSpace param, double[] params) {
        return ColorCssConverter.clampColors(ColorCssConverter.toFloat(params));
    }

    private static float[] clampColors(List<CssSize> params) {
        return ColorCssConverter.clampColors(ColorCssConverter.toFloat(params));
    }

    private static float[] clampColors(float[] params) {
        float[] clamped = new float[3];
        for (int i = 0; i < clamped.length; ++i) {
            clamped[i] = MathUtil.clamp((float)params[i], (float)0.0f, (float)1.0f);
        }
        return clamped;
    }

    private @NonNull CssColor parseColorHexDigits(@NonNull String hexdigits, int startpos) throws ParseException {
        try {
            int v = (int)Long.parseLong(hexdigits, 16);
            switch (hexdigits.length()) {
                case 3: {
                    int r = (v & 0xF00) >>> 4 | (v & 0xF00) >>> 8;
                    int g = v & 0xF0 | (v & 0xF0) >>> 4;
                    int b = (v & 0xF) << 4 | v & 0xF;
                    int a = 255;
                    return new Uint4HexSrgbaCssColor(r, g, b, a);
                }
                case 4: {
                    int r = (v & 0xF000) >>> 8 | (v & 0xF000) >>> 12;
                    int g = (v & 0xF00) >>> 4 | (v & 0xF00) >>> 8;
                    int b = v & 0xF0 | (v & 0xF0) >>> 4;
                    int a = (v & 0xF) << 4 | v & 0xF;
                    return new Uint4HexSrgbaCssColor(r, g, b, a);
                }
                case 6: {
                    int r = (v & 0xFF0000) >>> 16;
                    int g = (v & 0xFF00) >>> 8;
                    int b = v & 0xFF;
                    int a = 255;
                    return new Uint8HexSrgbaCssColor(r, g, b, a);
                }
                case 8: {
                    int r = (v & 0xFF000000) >>> 24;
                    int g = (v & 0xFF0000) >>> 16;
                    int b = (v & 0xFF00) >>> 8;
                    int a = v & 0xFF;
                    return new Uint8HexSrgbaCssColor(r, g, b, a);
                }
            }
            throw new ParseException("Could not convert a string to a CssColor because a hex digits value must have 3, 6  or 8 digits. Found " + hexdigits + " digits.", startpos);
        }
        catch (NumberFormatException e) {
            ParseException pe = new ParseException("Could not convert a string to a CssColor because it does not contain hex digits. Found \"" + hexdigits + "\".", startpos);
            pe.initCause(e);
            throw pe;
        }
    }

    private @NonNull CssColor parseHexColor(CssTokenizer tt) throws ParseException, IOException {
        return switch (tt.next()) {
            case -11 -> {
                if (tt.currentNumberNonNull().intValue() == 0 && tt.currentNumber() instanceof Long && tt.currentStringNonNull().startsWith("x")) {
                    yield this.parseColorHexDigits(tt.currentStringNonNull().substring(1), tt.getStartPosition());
                }
                throw tt.createParseException("Could not convert a string to CssColor because it does not contain the expected hex digits.");
            }
            case -8 -> this.parseColorHexDigits(tt.currentStringNonNull(), tt.getStartPosition());
            default -> throw tt.createParseException("Could not convert a string to CssColor because it does not contain the expected hex digits.");
        };
    }

    private @Nullable CssColor parseNamedColor(CssTokenizer tt) throws ParseException, IOException {
        tt.requireNextToken(-2, "CssColor: identifier expected.");
        String ident = tt.currentString();
        if ("none".equals(ident)) {
            return null;
        }
        CssColor color = NamedCssColor.of(tt.currentStringNonNull());
        if (color == null) {
            color = SystemCssColor.of(tt.currentStringNonNull());
        }
        return color;
    }

    public @Nullable CssColor parseOld(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        CssColor color = null;
        if (this.nullable) {
            if (tt.nextIsIdentNone()) {
                return null;
            }
            tt.pushBack();
        }
        switch (tt.next()) {
            case -11: {
                if (tt.currentNumberNonNull().intValue() == 0 && tt.currentNumber() instanceof Long && tt.currentStringNonNull().startsWith("x")) {
                    color = this.parseColorHexDigits(tt.currentStringNonNull().substring(1), tt.getStartPosition());
                    break;
                }
                throw tt.createParseException("Could not convert a string to CssColor because it does not contain the expected hex digits.");
            }
            case -8: {
                color = this.parseColorHexDigits(tt.currentStringNonNull(), tt.getStartPosition());
                break;
            }
            case -2: {
                color = NamedCssColor.of(tt.currentStringNonNull());
                if (color != null) break;
                color = SystemCssColor.of(tt.currentStringNonNull());
                break;
            }
            case -18: {
                switch (tt.currentStringNonNull()) {
                    case "rgba": 
                    case "rgb": {
                        color = this.parseSrgbaColor(tt);
                        break;
                    }
                    case "hsba": 
                    case "hsb": {
                        color = this.parseShsbaColor(tt);
                        break;
                    }
                    default: {
                        throw tt.createParseException("Could not convert a string to a CssColor because it contains an unsupported function=\"" + tt.currentStringNonNull() + "()\"");
                    }
                }
                if (tt.next() == 41) break;
                throw tt.createParseException("Could not convert a string to a CssColor because it does not end with a closing bracket ')' character.");
            }
            default: {
                throw tt.createParseException("Could not convert a string to a CssColor because it does not contain an expected color value.");
            }
        }
        return color;
    }

    private @NonNull CssColor parseShsbaColor(@NonNull CssTokenizer tt) throws IOException, ParseException {
        CssColor color;
        int i = 0;
        CssSize[] sizes = new CssSize[4];
        while (i < 4 && (tt.next() == -9 || tt.current() == -10 || tt.current() == -11)) {
            if (!(tt.current() != -11 || i == 0 && "deg".equals(tt.currentStringNonNull()))) {
                throw tt.createParseException("Could not convert a string to a HSB color because of the unexpected value=" + String.valueOf(tt.getToken()) + ".");
            }
            sizes[i++] = tt.current() == -10 ? CssSize.of((double)tt.currentNumberNonNull().doubleValue(), (String)"%") : CssSize.of((double)tt.currentNumberNonNull().doubleValue(), (String)"");
            if (tt.next() == 44) continue;
            tt.pushBack();
        }
        if (i == 0) {
            color = ShsbaCssColor.BLACK;
            tt.pushBack();
        } else if (i == 3) {
            color = new ShsbaCssColor(sizes[0], sizes[1], sizes[2], CssSize.ONE);
            tt.pushBack();
        } else if (i == 4) {
            color = new ShsbaCssColor(sizes[0], sizes[1], sizes[2], sizes[3]);
        } else {
            throw tt.createParseException("Could not convert a string to a HSB color because the function must have 0, 3 or 4 arguments. Found " + i + " arguments.");
        }
        return color;
    }

    private @NonNull CssColor parseSrgbaColor(@NonNull CssTokenizer tt) throws IOException, ParseException {
        SrgbaCssColor color;
        int i = 0;
        CssSize[] sizes = new CssSize[4];
        while (i < 4 && (tt.next() == -9 || tt.current() == -10)) {
            sizes[i++] = tt.current() == -10 ? CssSize.of((double)tt.currentNumberNonNull().doubleValue(), (String)"%") : CssSize.of((double)tt.currentNumberNonNull().doubleValue(), (String)"");
            if (tt.next() == 44) continue;
            tt.pushBack();
        }
        if (i == 0) {
            color = SrgbaCssColor.BLACK;
            tt.pushBack();
        } else if (i == 3) {
            color = new SrgbaCssColor(sizes[0], sizes[1], sizes[2], CssSize.ONE);
            tt.pushBack();
        } else if (i == 4) {
            color = new SrgbaCssColor(sizes[0], sizes[1], sizes[2], sizes[3]);
        } else {
            throw tt.createParseException("Could not convert a string to a sRGB color because the function must have 0, 3 or 4 arguments. Found " + i + " arguments.");
        }
        return color;
    }

    public <TT extends CssColor> void produceTokens(@Nullable TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        if (value == null) {
            out.accept(new CssToken(-2, "none"));
            return;
        }
        StreamCssTokenizer tt = new StreamCssTokenizer((CharSequence)value.getName(), null);
        try {
            while (tt.nextNoSkip() != -1) {
                out.accept(new CssToken(tt.current(), tt.currentNumber(), tt.currentString()));
            }
        }
        catch (IOException e) {
            throw new AssertionError("Unexpected IOException", e);
        }
    }
}

