/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.runtime.SwitchBootstraps;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.function.Consumer;
import javafx.scene.effect.Blend;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.Bloom;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.effect.Glow;
import javafx.scene.effect.InnerShadow;
import javafx.scene.effect.Shadow;
import javafx.scene.paint.Color;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.base.util.MathUtil;
import org.jhotdraw8.css.converter.CssConverter;
import org.jhotdraw8.css.converter.KebabCaseEnumCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.draw.css.converter.ColorCssConverter;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class EffectCssConverter
implements CssConverter<Effect> {
    private static final ImmutableList<String> examples = VectorList.of((Object[])new String[]{"blend(hard-light)", "bloom(10%)", "box-blur(10,3,3)", "color-adjust(hue -5%,saturation 20%,brightness 10%,contrast 10%)", "drop-shadow(three-pass-box,gray,5,0,3,3)", "gaussian-blur(10)", "inner-shadow(three-pass-box,gray,10,0,4,4)", "shadow(three-pass-box,black,10)"});
    private static final String BLEND = "blend";
    private static final String BLOOM = "bloom";
    private static final String BOX_BLUR = "box-blur";
    private static final String COLOR_ADJUST = "color-adjust";
    private static final String DROP_SHADOW = "drop-shadow";
    private static final String GAUSSIAN_BLUR = "gaussian-blur";
    private static final String GLOW = "glow";
    private static final String INNER_SHADOW = "inner-shadow";
    private static final String SHADOW = "shadow";
    private final @NonNull KebabCaseEnumCssConverter<BlurType> blurTypeConverter = new KebabCaseEnumCssConverter(BlurType.class, false);
    private final @NonNull KebabCaseEnumCssConverter<BlendMode> blendModeConverter = new KebabCaseEnumCssConverter(BlendMode.class, false);
    private final @NonNull ColorCssConverter colorConverter = new ColorCssConverter(false);

    public @Nullable Effect getDefaultValue() {
        return null;
    }

    public @NonNull ImmutableList<String> getExamples() {
        return examples;
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8Effect\u27e9: none\uff5c\uff08\u27e8Blend\u27e9\uff5c\u27e8Bloom\u27e9\uff5c\u27e8BoxBlur\u27e9\uff5c\u27e8ColorAdjust\u27e9\uff5c\u27e8DropShadow\u27e9\uff5c\u27e8GaussianBlur\u27e9\uff5c \u27e8InnerShadow\u27e9\uff09\uff5b, \u27e8Effect\u27e9\uff5d\nFormat of \u27e8Blend\u27e9: blend(\u27e8BlendMode\u27e9)\nFormat of \u27e8Bloom\u27e9: bloom(\u27e8luminosity\u27e9%)\nFormat of \u27e8BoxBlur\u27e9: box-blur(\u27e8width\u27e9,\u27e8height\u27e9,\u27e8iterations\u27e9)\nFormat of \u27e8ColorAdjust\u27e9: color-adjust(hue \u00b1\u27e8h\u27e9%, saturation \u00b1\u27e8s\u27e9%, brightness \u00b1\u27e8b\u27e9%, contrast \u00b1\u27e8c\u27e9%)\nFormat of \u27e8DropShadow\u27e9: drop-shadow(\u27e8BlurType\u27e9,\u27e8Color\u27e9,\u27e8radius\u27e9,\u27e8spread\u27e9,\u27e8xoffset\u27e9,\u27e8yoffset\u27e9)\nFormat of \u27e8GaussianBlur\u27e9: gaussian-blur(\u27e8radius\u27e9)\nFormat of \u27e8InnerShadow\u27e9: inner-shadow(\u27e8BlurType\u27e9,\u27e8Color\u27e9,\u27e8radius\u27e9,\u27e8choke\u27e9,\u27e8xoffset\u27e9,\u27e8yoffset\u27e9)\nFormat of \u27e8Shadow\u27e9: shadow(\u27e8BlurType\u27e9,\u27e8Color\u27e9,\u27e8radius\u27e9)\n" + this.blendModeConverter.getHelpText() + "\n" + this.blurTypeConverter.getHelpText() + "\n" + this.colorConverter.getHelpText();
    }

    public boolean isNullable() {
        return true;
    }

    public @Nullable Effect parse(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        if (tt.nextIsIdentNone()) {
            return null;
        }
        tt.pushBack();
        return this.parseEffect(tt);
    }

    private @NonNull Effect parseBlend(@NonNull CssTokenizer tt) throws ParseException, IOException {
        BlendMode mode = BlendMode.SRC_OVER;
        if (tt.next() == -2) {
            tt.pushBack();
            mode = (BlendMode)this.blendModeConverter.parse(tt, null);
        }
        if (tt.next() != 41) {
            throw tt.createParseException("CSS Effect: ')' expected.");
        }
        return new Blend(mode);
    }

    private @NonNull Effect parseBloom(@NonNull CssTokenizer tt) throws ParseException, IOException {
        double threshold = 0.3;
        switch (tt.next()) {
            case -9: {
                threshold = tt.currentNumberNonNull().doubleValue();
                break;
            }
            case -10: {
                threshold = tt.currentNumberNonNull().doubleValue() / 100.0;
                break;
            }
            default: {
                tt.pushBack();
            }
        }
        if (tt.next() != 41) {
            throw tt.createParseException("CSS Effect: ')' expected.");
        }
        return new Bloom(MathUtil.clamp((double)threshold, (double)0.0, (double)1.0));
    }

    private @NonNull Effect parseBoxBlur(@NonNull CssTokenizer tt) throws ParseException, IOException {
        double width = 5.0;
        double height = 5.0;
        int iterations = 1;
        switch (tt.next()) {
            case -9: {
                width = MathUtil.clamp((double)tt.currentNumberNonNull().doubleValue(), (double)0.0, (double)255.0);
                break;
            }
            default: {
                tt.pushBack();
            }
        }
        if (tt.next() != 44) {
            tt.pushBack();
        }
        switch (tt.next()) {
            case -9: {
                height = MathUtil.clamp((double)tt.currentNumberNonNull().doubleValue(), (double)0.0, (double)255.0);
                break;
            }
            default: {
                tt.pushBack();
            }
        }
        if (tt.next() != 44) {
            tt.pushBack();
        }
        switch (tt.next()) {
            case -9: {
                iterations = MathUtil.clamp((int)tt.currentNumberNonNull().intValue(), (int)0, (int)3);
                break;
            }
            default: {
                tt.pushBack();
            }
        }
        if (tt.next() != 41) {
            throw tt.createParseException("CSS Effect: ')' expected.");
        }
        return new BoxBlur(width, height, iterations);
    }

    private @NonNull Effect parseColorAdjust(@NonNull CssTokenizer tt) throws ParseException, IOException {
        double hue = 0.0;
        double saturation = 0.0;
        double brightness = 0.0;
        double contrast = 0.0;
        while (tt.next() == -2) {
            String ident = tt.currentStringNonNull();
            double adjust = 0.0;
            switch (tt.next()) {
                case -9: {
                    adjust = tt.currentNumberNonNull().doubleValue();
                    break;
                }
                case -10: {
                    adjust = tt.currentNumberNonNull().doubleValue() / 100.0;
                    break;
                }
                default: {
                    tt.pushBack();
                }
            }
            adjust = MathUtil.clamp((double)adjust, (double)0.0, (double)1.0);
            switch (ident) {
                case "hue": {
                    hue = adjust;
                    break;
                }
                case "saturation": {
                    saturation = adjust;
                    break;
                }
                case "brightness": {
                    brightness = adjust;
                    break;
                }
                case "contrast": {
                    contrast = adjust;
                    break;
                }
                default: {
                    throw tt.createParseException("CSS \"hue\", \"saturation\", \"brightness\", or \"contrast\" expected.");
                }
            }
            if (tt.next() == 44) continue;
            tt.pushBack();
        }
        if (tt.current() != 41) {
            throw tt.createParseException("CSS Effect: ')' expected.");
        }
        return new ColorAdjust(hue, saturation, brightness, contrast);
    }

    private @NonNull Effect parseDropShadow(@NonNull CssTokenizer tt) throws ParseException, IOException {
        return this.parseDropShadowOrInnerShadow(tt, true);
    }

    private @NonNull Effect parseDropShadowOrInnerShadow(@NonNull CssTokenizer tt, boolean isDropShadow) throws ParseException, IOException {
        DropShadow effect;
        String func = isDropShadow ? DROP_SHADOW : INNER_SHADOW;
        BlurType blurType = BlurType.GAUSSIAN;
        Color color = new Color(0.0, 0.0, 0.0, 0.25);
        double radius = 10.0;
        double spreadOrChocke = 0.0;
        double offsetX = 0.0;
        double offsetY = 4.0;
        Effect input = null;
        if (tt.next() != 41) {
            if (tt.current() != -2) {
                throw tt.createParseException("CSS Effect: " + func + "(<blur-type>,color,radius,spread,offset-x,offset-y) expected.");
            }
            tt.pushBack();
            blurType = (BlurType)this.blurTypeConverter.parseNonNull(tt, null);
            if (tt.next() != 44) {
                tt.pushBack();
            }
            if (tt.next() == -8) {
                color = Color.web((String)("#" + tt.currentString()));
            } else if (tt.current() == -2) {
                color = Color.web((String)tt.currentStringNonNull());
            } else if (tt.current() == -18) {
                tt.pushBack();
                CssColor colorOrNull = this.colorConverter.parse(tt, null);
                color = colorOrNull == null ? Color.BLACK : colorOrNull.getColor();
            } else {
                throw tt.createParseException("CSS Effect: " + func + "(" + blurType.toString().toLowerCase().replace('_', '-') + ",  <color> expected.");
            }
            if (tt.next() != 44) {
                tt.pushBack();
            }
            if (tt.next() != -9) {
                throw tt.createParseException("CSS Effect: radius number expected.");
            }
            radius = tt.currentNumberNonNull().doubleValue();
            if (tt.next() != 44) {
                tt.pushBack();
            }
            spreadOrChocke = switch (tt.next()) {
                case -9 -> tt.currentNumberNonNull().doubleValue();
                case -10 -> tt.currentNumberNonNull().doubleValue() / 100.0;
                default -> throw tt.createParseException("CSS Shadow-Effect: spread or chocke number expected.");
            };
            if (tt.next() != 44) {
                tt.pushBack();
            }
            if (tt.next() != -9) {
                throw tt.createParseException("CSS Shadow-Effect: offset-x number expected.");
            }
            offsetX = tt.currentNumberNonNull().doubleValue();
            if (tt.next() != 44) {
                tt.pushBack();
            }
            if (tt.next() != -9) {
                throw tt.createParseException("CSS Shadow-Effect: offset-y number expected.");
            }
            offsetY = tt.currentNumberNonNull().doubleValue();
            if (tt.next() != 44) {
                tt.pushBack();
            } else {
                input = this.parseEffect(tt);
            }
            if (tt.next() != 41) {
                throw tt.createParseException("CSS Shadow-Effect: ')' expected.");
            }
        }
        if (isDropShadow) {
            DropShadow dropShadow = new DropShadow(blurType, color, MathUtil.clamp((double)radius, (double)0.0, (double)127.0), spreadOrChocke, offsetX, offsetY);
            if (input != null) {
                dropShadow.setInput(input);
            }
            effect = dropShadow;
        } else {
            InnerShadow innerhShadow = new InnerShadow(blurType, color, MathUtil.clamp((double)radius, (double)0.0, (double)127.0), spreadOrChocke, offsetX, offsetY);
            if (input != null) {
                innerhShadow.setInput(input);
            }
            effect = innerhShadow;
        }
        return effect;
    }

    private @Nullable Effect parseEffect(@NonNull CssTokenizer tt) throws ParseException, IOException {
        Effect first = null;
        Effect previous = null;
        while (tt.next() == -18) {
            Effect current = switch (tt.currentStringNonNull()) {
                case BLEND -> this.parseBlend(tt);
                case BLOOM -> this.parseBloom(tt);
                case BOX_BLUR -> this.parseBoxBlur(tt);
                case COLOR_ADJUST -> this.parseColorAdjust(tt);
                case DROP_SHADOW -> this.parseDropShadow(tt);
                case GAUSSIAN_BLUR -> this.parseGaussianBlur(tt);
                case GLOW -> this.parseGlow(tt);
                case INNER_SHADOW -> this.parseInnerShadow(tt);
                case SHADOW -> this.parseShadow(tt);
                default -> throw tt.createParseException("CSS Effect: \"blend, drop-shadow(\" or \"inner-shadow(\"  expected.");
            };
            if (first == null) {
                first = previous = current;
            } else {
                try {
                    previous.getClass().getDeclaredMethod("setInput", Effect.class).invoke((Object)previous, current);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    ParseException pe = tt.createParseException("CSS Effect: can not combine effects.");
                    pe.initCause(ex);
                    throw pe;
                }
                previous = current;
            }
            if (tt.next() == 44) continue;
            tt.pushBack();
        }
        return first;
    }

    private @NonNull Effect parseGaussianBlur(@NonNull CssTokenizer tt) throws ParseException, IOException {
        double radius = 5.0;
        switch (tt.next()) {
            case -9: {
                radius = MathUtil.clamp((double)tt.currentNumberNonNull().doubleValue(), (double)0.0, (double)63.0);
                break;
            }
            default: {
                tt.pushBack();
            }
        }
        if (tt.next() != 41) {
            throw tt.createParseException("CSS Effect: ')' expected.");
        }
        return new GaussianBlur(radius);
    }

    private @NonNull Effect parseGlow(@NonNull CssTokenizer tt) throws ParseException, IOException {
        double level = 0.3;
        switch (tt.next()) {
            case -9: {
                level = tt.currentNumberNonNull().doubleValue();
                break;
            }
            case -10: {
                level = tt.currentNumberNonNull().doubleValue() / 100.0;
                break;
            }
            default: {
                tt.pushBack();
            }
        }
        if (tt.next() != 41) {
            throw tt.createParseException("CSS Effect: ')' expected.");
        }
        return new Glow(MathUtil.clamp((double)level, (double)0.0, (double)1.0));
    }

    private @NonNull Effect parseInnerShadow(@NonNull CssTokenizer tt) throws ParseException, IOException {
        return this.parseDropShadowOrInnerShadow(tt, false);
    }

    private @NonNull Effect parseShadow(@NonNull CssTokenizer tt) throws ParseException, IOException {
        String func = SHADOW;
        BlurType blurType = BlurType.GAUSSIAN;
        Color color = new Color(0.0, 0.0, 0.0, 0.75);
        double radius = 10.0;
        if (tt.next() != 41) {
            if (tt.current() != -2) {
                throw tt.createParseException("CSS Effect: " + func + "(<blur-type>,color,radius,spread,offset-x,offset-y) expected.");
            }
            tt.pushBack();
            blurType = (BlurType)this.blurTypeConverter.parseNonNull(tt, null);
            if (tt.next() != 44) {
                tt.pushBack();
            }
            if (tt.next() == -8) {
                color = Color.web((String)("#" + tt.currentStringNonNull()));
            } else if (tt.current() == -2) {
                color = Color.web((String)tt.currentStringNonNull());
            } else if (tt.current() == -18) {
                tt.pushBack();
                CssColor colorOrNull = this.colorConverter.parse(tt, null);
                color = colorOrNull == null ? Color.BLACK : colorOrNull.getColor();
            } else {
                throw tt.createParseException("CSS Effect: " + func + "(" + blurType.toString().toLowerCase().replace('_', '-') + ",  <color> expected.");
            }
            if (tt.next() != 44) {
                tt.pushBack();
            }
            if (tt.next() != -9) {
                throw tt.createParseException("CSS Effect: radius number expected.");
            }
            radius = tt.currentNumberNonNull().doubleValue();
            if (tt.next() != 41) {
                throw tt.createParseException("CSS Effect: ')' expected.");
            }
        }
        return new Shadow(blurType, color, MathUtil.clamp((double)radius, (double)0.0, (double)127.0));
    }

    public <TT extends Effect> void produceTokens(@Nullable TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        ArrayDeque<TT> effects = new ArrayDeque<TT>();
        Object chainedEffect = value;
        while (chainedEffect != null) {
            effects.add((TT)chainedEffect);
            try {
                Object inputEffect = chainedEffect.getClass().getDeclaredMethod("getInput", Effect.class).invoke(chainedEffect, new Object[0]);
                if (!(inputEffect instanceof Effect)) continue;
                chainedEffect = (Effect)inputEffect;
                effects.addFirst((TT)chainedEffect);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                chainedEffect = null;
            }
        }
        boolean first = true;
        block14: for (Effect eff : effects) {
            if (first) {
                first = false;
            } else {
                out.accept(new CssToken(44));
                out.accept(new CssToken(-16, " "));
            }
            Effect effect = eff;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Blend.class, Bloom.class, BoxBlur.class, ColorAdjust.class, DropShadow.class, GaussianBlur.class, Glow.class, InnerShadow.class, Shadow.class}, (Object)effect, n)) {
                case 0: {
                    Blend fx = (Blend)effect;
                    out.accept(new CssToken(-18, BLEND));
                    this.blendModeConverter.produceTokens((Enum)fx.getMode(), idSupplier, out);
                    out.accept(new CssToken(41));
                    break;
                }
                case 1: {
                    Bloom fx = (Bloom)effect;
                    out.accept(new CssToken(-18, BLOOM));
                    out.accept(new CssToken(-10, (Number)(fx.getThreshold() * 100.0)));
                    if (fx.getInput() != null) {
                        out.accept(new CssToken(44));
                        this.produceTokens(fx.getInput(), idSupplier, out);
                    }
                    out.accept(new CssToken(41));
                    break;
                }
                case 2: {
                    BoxBlur fx = (BoxBlur)effect;
                    out.accept(new CssToken(-18, BOX_BLUR));
                    out.accept(new CssToken(-9, (Number)fx.getWidth()));
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-9, (Number)fx.getHeight()));
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-9, (Number)fx.getIterations()));
                    out.accept(new CssToken(41));
                    if (fx.getInput() == null) continue block14;
                    out.accept(new CssToken(44));
                    this.produceTokens(fx.getInput(), idSupplier, out);
                    break;
                }
                case 3: {
                    boolean all;
                    ColorAdjust fx = (ColorAdjust)effect;
                    out.accept(new CssToken(-18, COLOR_ADJUST));
                    boolean needComma = false;
                    double hue = fx.getHue();
                    double saturation = fx.getSaturation();
                    double brightness = fx.getBrightness();
                    double contrast = fx.getContrast();
                    boolean bl = all = hue == 0.0 && saturation == 0.0 && brightness == 0.0 && contrast == 0.0;
                    if (hue != 0.0 || all) {
                        out.accept(new CssToken(-2, "hue"));
                        out.accept(new CssToken(-16, " "));
                        if (hue > 0.0) {
                            out.accept(new CssToken(43));
                        }
                        out.accept(new CssToken(-10, (Number)(hue * 100.0)));
                        needComma = true;
                    }
                    if (saturation != 0.0 || all) {
                        if (needComma) {
                            out.accept(new CssToken(44));
                        }
                        out.accept(new CssToken(-2, "saturation"));
                        out.accept(new CssToken(-16, " "));
                        if (saturation > 0.0) {
                            out.accept(new CssToken(43));
                        }
                        out.accept(new CssToken(-10, (Number)(saturation * 100.0)));
                        needComma = true;
                    }
                    if (brightness != 0.0 || all) {
                        if (needComma) {
                            out.accept(new CssToken(44));
                        }
                        out.accept(new CssToken(-2, "brightness"));
                        out.accept(new CssToken(-16, " "));
                        if (brightness > 0.0) {
                            out.accept(new CssToken(43));
                        }
                        out.accept(new CssToken(-10, (Number)(brightness * 100.0)));
                        needComma = true;
                    }
                    if (contrast != 0.0 || all) {
                        if (needComma) {
                            out.accept(new CssToken(44));
                        }
                        out.accept(new CssToken(-2, "contrast"));
                        out.accept(new CssToken(-16, " "));
                        if (contrast > 0.0) {
                            out.accept(new CssToken(43));
                        }
                        out.accept(new CssToken(-10, (Number)(contrast * 100.0)));
                    }
                    out.accept(new CssToken(41));
                    if (fx.getInput() == null) continue block14;
                    out.accept(new CssToken(-16, " "));
                    this.produceTokens(fx.getInput(), idSupplier, out);
                    break;
                }
                case 4: {
                    DropShadow fx = (DropShadow)effect;
                    out.accept(new CssToken(-18, DROP_SHADOW));
                    this.blurTypeConverter.produceTokens((Enum)fx.getBlurType(), idSupplier, out);
                    out.accept(new CssToken(44));
                    this.colorConverter.produceTokens(new CssColor(fx.getColor()), idSupplier, out);
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-9, (Number)fx.getRadius()));
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-10, (Number)(fx.getSpread() * 100.0)));
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-9, (Number)fx.getOffsetX()));
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-9, (Number)fx.getOffsetY()));
                    out.accept(new CssToken(41));
                    if (fx.getInput() == null) continue block14;
                    out.accept(new CssToken(44));
                    this.produceTokens(fx.getInput(), idSupplier, out);
                    break;
                }
                case 5: {
                    GaussianBlur fx = (GaussianBlur)effect;
                    out.accept(new CssToken(-18, GAUSSIAN_BLUR));
                    out.accept(new CssToken(-9, (Number)fx.getRadius()));
                    out.accept(new CssToken(41));
                    if (fx.getInput() == null) continue block14;
                    out.accept(new CssToken(44));
                    this.produceTokens(fx.getInput(), idSupplier, out);
                    break;
                }
                case 6: {
                    Glow fx = (Glow)effect;
                    out.accept(new CssToken(-18, GLOW));
                    out.accept(new CssToken(-10, (Number)(fx.getLevel() * 100.0)));
                    out.accept(new CssToken(41));
                    if (fx.getInput() == null) continue block14;
                    out.accept(new CssToken(-16, " "));
                    this.produceTokens(fx.getInput(), idSupplier, out);
                    break;
                }
                case 7: {
                    InnerShadow fx = (InnerShadow)effect;
                    out.accept(new CssToken(-18, INNER_SHADOW));
                    this.blurTypeConverter.produceTokens((Enum)fx.getBlurType(), idSupplier, out);
                    out.accept(new CssToken(44));
                    this.colorConverter.produceTokens(new CssColor(fx.getColor()), idSupplier, out);
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-9, (Number)fx.getRadius()));
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-10, (Number)(fx.getChoke() * 100.0)));
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-9, (Number)fx.getOffsetX()));
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-9, (Number)fx.getOffsetY()));
                    out.accept(new CssToken(41));
                    if (fx.getInput() == null) continue block14;
                    out.accept(new CssToken(-16, " "));
                    this.produceTokens(fx.getInput(), idSupplier, out);
                    break;
                }
                case 8: {
                    Shadow fx = (Shadow)effect;
                    out.accept(new CssToken(-18, SHADOW));
                    this.blurTypeConverter.produceTokens((Enum)fx.getBlurType(), idSupplier, out);
                    out.accept(new CssToken(44));
                    this.colorConverter.produceTokens(new CssColor(fx.getColor()), idSupplier, out);
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-9, (Number)fx.getRadius()));
                    out.accept(new CssToken(41));
                    if (fx.getInput() == null) continue block14;
                    out.accept(new CssToken(-16, " "));
                    this.produceTokens(fx.getInput(), idSupplier, out);
                    break;
                }
                default: {
                    out.accept(new CssToken(-2, "none"));
                }
            }
        }
    }
}

