/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssFont;

public class FontCssConverter
extends AbstractCssConverter<CssFont> {
    public static final String ITALIC_STYLE = "italic";
    public static final String BOLD_WEIGHT = "bold";
    public static final String NORMAL_STYLE = "normal";
    public static final String NORMAL_WEIGHT = "normal";
    public static final String OBLIQUE_STYLE = "oblique";
    public static final String BOLDER_WEIGHT = "bolder";
    public static final String LIGHTER_WEIGHT = "lighter";

    public FontCssConverter(boolean nullable) {
        super(nullable);
    }

    public <TT extends CssFont> void produceTokensNonNull(@NonNull TT font, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        FontWeight weight;
        CssSize fontSize = font.getSize();
        String fontFamily = font.getFamily();
        FontPosture posture = font.getPosture();
        boolean needsSpace = false;
        if (posture != null) {
            switch (font.getPosture()) {
                case ITALIC: {
                    out.accept(new CssToken(-2, ITALIC_STYLE));
                    needsSpace = true;
                    break;
                }
                case REGULAR: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown fontPosture:" + String.valueOf(font.getPosture()));
                }
            }
        }
        if ((weight = font.getWeight()) != null) {
            switch (weight) {
                case NORMAL: {
                    break;
                }
                case BOLD: {
                    if (needsSpace) {
                        out.accept(new CssToken(-16, " "));
                    }
                    out.accept(new CssToken(-2, BOLD_WEIGHT));
                    needsSpace = true;
                    break;
                }
                default: {
                    if (needsSpace) {
                        out.accept(new CssToken(-16, " "));
                    }
                    out.accept(new CssToken(-9, (Number)weight.getWeight()));
                    needsSpace = true;
                }
            }
        }
        if (needsSpace) {
            out.accept(new CssToken(-16, " "));
        }
        out.accept(new CssToken(-11, (Number)fontSize.getValue(), fontSize.getUnits()));
        out.accept(new CssToken(-16, " "));
        if (fontFamily.contains("'") || fontFamily.contains("\"")) {
            out.accept(new CssToken(-4, fontFamily));
        } else if (fontFamily.contains(" ")) {
            boolean first = true;
            for (String part : fontFamily.split(" +")) {
                if (first) {
                    first = false;
                } else {
                    out.accept(new CssToken(-16, " "));
                }
                out.accept(new CssToken(-2, part));
            }
        } else {
            out.accept(new CssToken(-2, fontFamily));
        }
    }

    public @NonNull CssFont parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        CssFont font;
        FontPosture fontPosture = FontPosture.REGULAR;
        FontWeight fontWeight = FontWeight.NORMAL;
        CssSize fontSize = CssSize.of((double)12.0);
        StringBuilder fontFamily = new StringBuilder("System");
        if (tt.next() == -2) {
            switch (tt.currentStringNonNull().toLowerCase()) {
                case "normal": {
                    fontPosture = FontPosture.REGULAR;
                    break;
                }
                case "italic": 
                case "oblique": {
                    fontPosture = FontPosture.ITALIC;
                    break;
                }
                default: {
                    tt.pushBack();
                    break;
                }
            }
        } else {
            tt.pushBack();
        }
        boolean fontWeightConsumed = false;
        if (tt.next() == -2) {
            switch (tt.currentStringNonNull().toLowerCase()) {
                case "normal": {
                    fontWeight = FontWeight.NORMAL;
                    fontWeightConsumed = true;
                    break;
                }
                case "bold": {
                    fontWeight = FontWeight.BOLD;
                    fontWeightConsumed = true;
                    break;
                }
                case "bolder": {
                    fontWeight = FontWeight.BOLD;
                    fontWeightConsumed = true;
                    break;
                }
                case "lighter": {
                    fontWeight = FontWeight.LIGHT;
                    fontWeightConsumed = true;
                    break;
                }
                default: {
                    tt.pushBack();
                    break;
                }
            }
        } else {
            tt.pushBack();
        }
        double fontWeightOrFontSize = 0.0;
        boolean fontWeightOrFontSizeConsumed = false;
        if (!fontWeightConsumed) {
            if (tt.next() == -9) {
                fontWeightOrFontSize = tt.currentNumberNonNull().doubleValue();
                fontWeightOrFontSizeConsumed = true;
            } else {
                tt.pushBack();
            }
        }
        if (tt.next() == -11 || tt.current() == -9) {
            if (tt.current() == -11) {
                fontSize = CssSize.of((double)tt.currentNumberNonNull().doubleValue(), (String)tt.currentStringNonNull());
            } else if (tt.current() == -9) {
                fontSize = CssSize.of((double)tt.currentNumberNonNull().doubleValue());
            }
            if (fontWeightOrFontSizeConsumed) {
                fontWeight = switch ((int)fontWeightOrFontSize) {
                    case 100 -> FontWeight.THIN;
                    case 200 -> FontWeight.EXTRA_LIGHT;
                    case 300 -> FontWeight.LIGHT;
                    case 400 -> FontWeight.NORMAL;
                    case 500 -> FontWeight.MEDIUM;
                    case 600 -> FontWeight.SEMI_BOLD;
                    case 700 -> FontWeight.BOLD;
                    case 800 -> FontWeight.EXTRA_BOLD;
                    case 900 -> FontWeight.BLACK;
                    default -> throw new ParseException("\u27e8Font\u27e9: illegal font weight " + fontWeightOrFontSize, tt.getStartPosition());
                };
            }
        } else if (fontWeightOrFontSizeConsumed) {
            tt.pushBack();
            fontSize = CssSize.of((double)fontWeightOrFontSize);
        } else {
            tt.pushBack();
        }
        if (tt.next() == -2) {
            fontFamily = new StringBuilder(tt.currentString());
            while (tt.next() == -2) {
                fontFamily.append(" ").append(tt.currentString());
            }
        } else if (tt.current() == -4) {
            fontFamily = new StringBuilder(tt.currentString());
        } else {
            throw new ParseException("\u27e8Font\u27e9: \u27e8FontFamily\u27e9 expected", tt.getStartPosition());
        }
        if ((font = CssFont.font(fontFamily.toString(), fontWeight, fontPosture, fontSize)) == null) {
            font = CssFont.font(null, fontWeight, fontPosture, fontSize);
        }
        return font;
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8Font\u27e9: \uff3b\u27e8FontStyle\u27e9\uff3d\uff3b\u27e8FontWeight\u27e9\uff3d \u27e8FontSize\u27e9 \u27e8FontFamily\u27e9\n  with \u27e8FontStyle\u27e9: normal\uff5citalic\uff5coblique\n  with \u27e8FontWeight\u27e9: normal\uff5cbold\uff5cbolder\uff5clighter\uff5c100\uff5c200\uff5c300\uff5c400\uff5c500\uff5c600\uff5c700\uff5c800\uff5c900\n  with \u27e8FontSize\u27e9: size\n  with \u27e8FontFamily\u27e9: \u27e8identifier\u27e9\uff5c\u27e8string\u27e9";
    }
}

