/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.draw.css.converter.ColorCssConverter;
import org.jhotdraw8.draw.css.converter.LinearGradientCssConverter;
import org.jhotdraw8.draw.css.converter.RadialGradientCssConverter;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.CssLinearGradient;
import org.jhotdraw8.draw.css.value.CssRadialGradient;
import org.jhotdraw8.draw.css.value.Paintable;

public class PaintableCssConverter
extends AbstractCssConverter<Paintable> {
    private static final @NonNull ColorCssConverter colorConverter = new ColorCssConverter(false);
    private static final @NonNull LinearGradientCssConverter linearGradientConverter = new LinearGradientCssConverter(false);
    private static final @NonNull RadialGradientCssConverter radialGradientConverter = new RadialGradientCssConverter(false);

    public PaintableCssConverter(boolean nullable) {
        super(nullable);
    }

    public @Nullable String getHelpText() {
        String[] lines = ("Format of \u27e8Paint\u27e9: none\uff5c\uff08\u27e8Color\u27e9\uff5c \u27e8LinearGradient\u27e9\uff5c \u27e8RadialGradient\u27e9\n" + colorConverter.getHelpText() + "\n" + linearGradientConverter.getHelpText() + "\n" + radialGradientConverter.getHelpText()).split("\n");
        StringBuilder buf = new StringBuilder();
        HashSet<String> duplicateLines = new HashSet<String>();
        for (String line : lines) {
            if (!duplicateLines.add(line)) continue;
            if (!buf.isEmpty()) {
                buf.append('\n');
            }
            buf.append(line);
        }
        return buf.toString();
    }

    public @NonNull Paintable parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        if (tt.next() == -18) {
            switch (tt.currentStringNonNull()) {
                case "linear-gradient": {
                    tt.pushBack();
                    return linearGradientConverter.parseNonNull(tt, idResolver);
                }
                case "radial-gradient": {
                    tt.pushBack();
                    return radialGradientConverter.parseNonNull(tt, idResolver);
                }
            }
        }
        tt.pushBack();
        return (Paintable)colorConverter.parseNonNull(tt, idResolver);
    }

    protected <TT extends Paintable> void produceTokensNonNull(@NonNull TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) throws IOException {
        TT TT = value;
        Objects.requireNonNull(TT);
        TT TT2 = TT;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CssColor.class, CssLinearGradient.class, CssRadialGradient.class}, TT2, n)) {
            case 0: {
                CssColor c = (CssColor)TT2;
                colorConverter.produceTokens(c, idSupplier, out);
                break;
            }
            case 1: {
                CssLinearGradient lg = (CssLinearGradient)TT2;
                linearGradientConverter.produceTokens(lg, idSupplier, out);
                break;
            }
            case 2: {
                CssRadialGradient lg = (CssRadialGradient)TT2;
                radialGradientConverter.produceTokens(lg, idSupplier, out);
                break;
            }
            default: {
                throw new UnsupportedOperationException("not yet implemented for " + String.valueOf(value));
            }
        }
    }
}

