/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.function.Consumer;
import javafx.scene.paint.CycleMethod;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.draw.css.converter.ColorCssConverter;
import org.jhotdraw8.draw.css.converter.CssStop;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.CssRadialGradient;

public class RadialGradientCssConverter
extends AbstractCssConverter<CssRadialGradient> {
    private static final @NonNull ColorCssConverter colorConverter = new ColorCssConverter(false);
    public static final String RADIAL_GRADIENT_FUNCTION = "radial-gradient";

    public RadialGradientCssConverter(boolean nullable) {
        super(nullable);
    }

    protected <TT extends CssRadialGradient> void produceTokensNonNull(@NonNull TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        out.accept(new CssToken(-18, RADIAL_GRADIENT_FUNCTION));
        TT lg = value;
        boolean proportional = lg.isProportional();
        double focusAngle = lg.getFocusAngle();
        double focusDistance = lg.getFocusDistance();
        double centerX = lg.getCenterX();
        double centerY = lg.getCenterY();
        double radius = lg.getRadius();
        boolean needsComma = false;
        if (focusAngle != 0.0) {
            out.accept(new CssToken(-2, "focus-angle"));
            out.accept(new CssToken(-16, " "));
            out.accept(new CssToken(-11, (Number)focusAngle, "deg"));
            needsComma = true;
        }
        if (focusDistance != 0.0) {
            if (needsComma) {
                out.accept(new CssToken(44));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(44));
                out.accept(new CssToken(-16, " "));
            }
            out.accept(new CssToken(-2, "focus-distance"));
            out.accept(new CssToken(-16, " "));
            out.accept(new CssToken(-10, (Number)(focusDistance * 100.0)));
            needsComma = true;
        }
        if (centerX != 0.5 || centerY != 0.5) {
            if (needsComma) {
                out.accept(new CssToken(44));
                out.accept(new CssToken(-16, " "));
            }
            out.accept(new CssToken(-2, "center"));
            out.accept(new CssToken(-16, " "));
            if (proportional) {
                out.accept(new CssToken(-10, (Number)(centerX * 100.0)));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-10, (Number)(centerY * 100.0)));
                out.accept(new CssToken(-16, " "));
            } else {
                out.accept(new CssToken(-9, (Number)centerX));
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-9, (Number)centerY));
            }
            needsComma = true;
        }
        if (needsComma) {
            out.accept(new CssToken(44));
            out.accept(new CssToken(-16, " "));
        }
        out.accept(new CssToken(-2, "radius"));
        out.accept(new CssToken(-16, " "));
        if (proportional) {
            out.accept(new CssToken(-10, (Number)(radius * 100.0)));
        } else {
            out.accept(new CssToken(-9, (Number)radius));
        }
        needsComma = true;
        switch (lg.getCycleMethod()) {
            case NO_CYCLE: {
                break;
            }
            case REPEAT: {
                if (needsComma) {
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-16, " "));
                }
                out.accept(new CssToken(-2, "repeat"));
                needsComma = true;
                break;
            }
            case REFLECT: {
                if (needsComma) {
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-16, " "));
                }
                out.accept(new CssToken(-2, "reflect"));
                needsComma = true;
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown cycle method " + String.valueOf(lg.getCycleMethod()));
            }
        }
        for (CssStop stop : lg.getStops()) {
            if (needsComma) {
                out.accept(new CssToken(44));
                out.accept(new CssToken(-16, " "));
            }
            colorConverter.produceTokens(stop.color(), idSupplier, out);
            if (stop.offset() != null) {
                out.accept(new CssToken(-16, " "));
                out.accept(new CssToken(-10, (Number)(stop.offset() * 100.0)));
            }
            needsComma = true;
        }
        out.accept(new CssToken(41));
    }

    public @NonNull CssRadialGradient parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        tt.requireNextToken(-18, "\u27e8RadialGradient\u27e9: \"radial-gradient(\"  expected");
        switch (tt.currentStringNonNull()) {
            case "radial-gradient": {
                break;
            }
            default: {
                throw new ParseException("\u27e8RadialGradient\u27e9: \"radial-gradient\" expected, found: " + String.valueOf(tt.getToken()), tt.getStartPosition());
            }
        }
        double focusAngle = 0.0;
        double focusDistance = 0.0;
        double centerX = 0.5;
        double centerY = 0.5;
        double radius = 1.0;
        Boolean isProportional = null;
        while (tt.next() == -2) {
            block51: {
                block54: {
                    block53: {
                        block52: {
                            block50: {
                                if (!"focus-angle".equals(tt.currentString())) break block50;
                                focusAngle = switch (tt.next()) {
                                    case -11 -> {
                                        if (!"deg".equals(tt.currentString())) {
                                            throw new ParseException("CSS RadialGradient: expected focus-angle given in degrees with unit  \"deg\", found: " + String.valueOf(tt.getToken()), tt.getStartPosition());
                                        }
                                        yield tt.currentNumberNonNull().doubleValue();
                                    }
                                    case -9 -> tt.currentNumberNonNull().doubleValue();
                                    default -> throw new ParseException("CSS RadialGradient: focus-angle  expected, found: " + String.valueOf(tt.getToken()), tt.getStartPosition());
                                };
                                break block51;
                            }
                            if (!"focus-distance".equals(tt.currentString())) break block52;
                            focusDistance = switch (tt.next()) {
                                case -10 -> tt.currentNumberNonNull().doubleValue() / 100.0;
                                case -9 -> tt.currentNumberNonNull().doubleValue();
                                default -> throw new ParseException("CSS RadialGradient: focus-distance expected, found: " + String.valueOf(tt.getToken()), tt.getStartPosition());
                            };
                            break block51;
                        }
                        if (!"center".equals(tt.currentString())) break block53;
                        switch (tt.next()) {
                            case -10: {
                                if (isProportional == null) {
                                    isProportional = true;
                                }
                                if (!isProportional.booleanValue()) {
                                    throw new ParseException("CSS RadialGradient: absolute value expected, found: " + String.valueOf(tt.getToken()), tt.getStartPosition());
                                }
                                centerX = tt.currentNumberNonNull().doubleValue() / 100.0;
                                break;
                            }
                            case -9: {
                                if (isProportional == null) {
                                    isProportional = false;
                                }
                                if (isProportional.booleanValue()) {
                                    throw new ParseException("CSS RadialGradient: percentage expected, found: " + String.valueOf(tt.getToken()), tt.getStartPosition());
                                }
                                centerX = tt.currentNumberNonNull().doubleValue();
                                break;
                            }
                            default: {
                                throw new ParseException("CSS RadialGradient: center x-value expected, found: " + String.valueOf(tt.getToken()), tt.getStartPosition());
                            }
                        }
                        switch (tt.next()) {
                            case -10: {
                                if (isProportional == null) {
                                    isProportional = true;
                                }
                                if (!isProportional.booleanValue()) {
                                    throw new ParseException("CSS RadialGradient: absolute value  expected, found: " + String.valueOf(tt.getToken()), tt.getStartPosition());
                                }
                                centerY = tt.currentNumberNonNull().doubleValue() / 100.0;
                                break block51;
                            }
                            case -9: {
                                if (isProportional == null) {
                                    isProportional = false;
                                }
                                if (isProportional.booleanValue()) {
                                    throw new ParseException("CSS RadialGradient: percentage  expected, found: " + String.valueOf(tt.getToken()), tt.getStartPosition());
                                }
                                centerY = tt.currentNumberNonNull().doubleValue();
                                break block51;
                            }
                            default: {
                                throw new ParseException("CSS RadialGradient: center y-value  expected, found: " + String.valueOf(tt.getToken()), tt.getStartPosition());
                            }
                        }
                    }
                    if (!"radius".equals(tt.currentString())) break block54;
                    switch (tt.next()) {
                        case -10: {
                            if (isProportional == null) {
                                isProportional = true;
                            }
                            if (!isProportional.booleanValue()) {
                                throw new ParseException("CSS RadialGradient: absolute value expected, found: " + String.valueOf(tt.getToken()), tt.getStartPosition());
                            }
                            radius = tt.currentNumberNonNull().doubleValue() / 100.0;
                            break block51;
                        }
                        case -9: {
                            if (isProportional == null) {
                                isProportional = false;
                            }
                            if (isProportional.booleanValue()) {
                                throw new ParseException("CSS RadialGradient: percentage  expected, found: " + String.valueOf(tt.getToken()), tt.getStartPosition());
                            }
                            radius = tt.currentNumberNonNull().doubleValue();
                            break block51;
                        }
                        default: {
                            throw new ParseException("CSS RadialGradient: center x-value  expected, found: " + String.valueOf(tt.getToken()), tt.getStartPosition());
                        }
                    }
                }
                tt.pushBack();
                break;
            }
            if (tt.next() == 44) continue;
            tt.pushBack();
        }
        tt.pushBack();
        CycleMethod cycleMethod = CycleMethod.NO_CYCLE;
        if (tt.next() == -2) {
            if ("repeat".equals(tt.currentString())) {
                cycleMethod = CycleMethod.REPEAT;
            } else if ("reflect".equals(tt.currentString())) {
                cycleMethod = CycleMethod.REFLECT;
            } else {
                tt.pushBack();
            }
        } else {
            tt.pushBack();
        }
        if (tt.next() != 44) {
            tt.pushBack();
        }
        ArrayList<CssStop> stops = new ArrayList<CssStop>();
        while (tt.next() != 41 && tt.current() != -1) {
            tt.pushBack();
            stops.add(this.parseColorStop(tt, idResolver));
            if (tt.next() == 44) continue;
            tt.pushBack();
        }
        if (tt.current() != 41) {
            throw new ParseException("CSS RadialGradient: ')'  expected, found: " + String.valueOf(tt.getToken()), tt.getStartPosition());
        }
        if (isProportional == null) {
            isProportional = true;
        }
        return new CssRadialGradient(focusAngle, focusDistance, centerX, centerY, radius, isProportional, cycleMethod, stops.toArray(new CssStop[0]));
    }

    private @NonNull CssStop parseColorStop(@NonNull CssTokenizer tt, IdResolver idResolver) throws IOException, ParseException {
        CssColor color = colorConverter.parse(tt, idResolver);
        Double offset = null;
        switch (tt.next()) {
            case -9: {
                offset = tt.currentNumberNonNull().doubleValue();
                break;
            }
            case -10: {
                offset = tt.currentNumberNonNull().doubleValue() / 100.0;
                break;
            }
            default: {
                tt.pushBack();
            }
        }
        return new CssStop(offset, color);
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8RadialGradient\u27e9: radial-gradient(\uff3b\u27e8RadialGradientParameters\u27e9\uff3d\uff3b,\u27e8Cycle\u27e9\uff3d,\u27e8ColorStop\u27e9\uff5b,\u27e8ColorStop\u27e9\uff5d)\nFormat of \u27e8RadialGradientParameters\u27e9: \uff3b\u27e8FocusAngle\u27e9\uff3d\uff3b, \u27e8FocusDistance\u27e9\uff3d\uff3b, \u27e8Center\u27e9\uff3d, \u27e8Radius\u27e9\nFormat of \u27e8FocusAngle\u27e9: focus-angle \u27e8angle\u27e9deg\nFormat of \u27e8FocusDistance\u27e9: focus-distance \u27e8percentage\u27e9%\nFormat of \u27e8Center\u27e9: center \u27e8cx\u27e9,\u27e8cy\u27e9\uff5ccenter \u27e8cx\u27e9%,\u27e8cy\u27e9%\nFormat of \u27e8Radius\u27e9: \u27e8radius\u27e9\uff5c\u27e8percentage\u27e9%\nFormat of \u27e8Cycle\u27e9: repeat\uff5creflect\nFormat of \u27e8ColorStop\u27e9: \u27e8Color\u27e9 \u27e8percentage\u27e9%\n" + colorConverter.getHelpText();
    }
}

