/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.base.text.RegexReplace;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;

public class RegexCssConverter
extends AbstractCssConverter<RegexReplace> {
    public static final String REPLACE_FUNCTION = "replace";

    public RegexCssConverter(boolean nullable) {
        super(nullable);
    }

    public @NonNull RegexReplace parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        String replace;
        tt.requireNextToken(-18, "\u27e8replace\u27e9: function expected.");
        if (!REPLACE_FUNCTION.equals(tt.currentStringNonNull())) {
            throw tt.createParseException("\u27e8replace\u27e9: replace() function expected.");
        }
        tt.requireNextToken(-4, "\u27e8replace\u27e9: find string expected.");
        String find = tt.currentStringNonNull();
        if (tt.next() != 44) {
            tt.pushBack();
        }
        if (tt.next() == -4) {
            replace = tt.currentStringNonNull();
        } else {
            tt.pushBack();
            replace = null;
        }
        tt.requireNextToken(41, "\u27e8replace\u27e9: right bracket expected.");
        return new RegexReplace(find, replace);
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8replace\u27e9: none | replace(\u27e8Match\u27e9, \u27e8Replace\u27e9)\nFormat of \u27e8Match\u27e9: \"match\"\nFormat of \u27e8Replace\u27e9: \"replacement\"";
    }

    protected <TT extends RegexReplace> void produceTokensNonNull(@NonNull TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        out.accept(new CssToken(-18, REPLACE_FUNCTION));
        String find = value.getFind();
        out.accept(new CssToken(-4, find == null ? "" : find));
        out.accept(new CssToken(44));
        String replace = value.getReplace();
        out.accept(new CssToken(-4, replace == null ? "" : replace));
        out.accept(new CssToken(41));
    }
}

