/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import javafx.geometry.Point2D;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;

public class SymmetricPoint2DConverter
extends AbstractCssConverter<Point2D> {
    private final boolean withSpace;
    private final boolean withComma;

    public SymmetricPoint2DConverter() {
        this(false, true, false);
    }

    public SymmetricPoint2DConverter(boolean nullable) {
        this(nullable, true, false);
    }

    public SymmetricPoint2DConverter(boolean nullable, boolean withSpace, boolean withComma) {
        super(nullable);
        this.withSpace = withSpace;
        this.withComma = withComma || !withSpace;
    }

    public @NonNull Point2D parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        double y;
        tt.requireNextToken(-9, "x");
        double x = tt.currentNumberNonNull().doubleValue();
        if (tt.next() == -1) {
            y = x;
        } else {
            tt.pushBack();
            tt.skipIfPresent(44);
            tt.requireNextToken(-9, "y");
            y = tt.currentNumberNonNull().doubleValue();
        }
        return new Point2D(x, y);
    }

    protected <TT extends Point2D> void produceTokensNonNull(@NonNull TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        double x = value.getX();
        double y = value.getY();
        out.accept(new CssToken(-9, (Number)x));
        if (x != y) {
            if (this.withComma) {
                out.accept(new CssToken(44));
            }
            if (this.withSpace) {
                out.accept(new CssToken(-16, " "));
            }
            out.accept(new CssToken(-9, (Number)y));
        }
    }

    public @Nullable Point2D getDefaultValue() {
        return new Point2D(0.0, 0.0);
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8SymmetricPoint2D\u27e9: \u27e8xy\u27e9 \uff5c \u27e8x\u27e9 \u27e8y\u27e9";
    }
}

