/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.model;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.css.StyleOrigin;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.css.converter.CssConverter;
import org.jhotdraw8.css.converter.StringCssConverter;
import org.jhotdraw8.css.model.AbstractSelectorModel;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.parser.ListCssTokenizer;
import org.jhotdraw8.css.parser.StreamCssTokenizer;
import org.jhotdraw8.css.value.QualifiedName;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.fxbase.styleable.ReadOnlyStyleableMapAccessor;
import org.jhotdraw8.fxbase.styleable.WritableStyleableMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.CompositeMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;

public class FigureSelectorModel
extends AbstractSelectorModel<Figure> {
    public static final String JAVA_CLASS_NAMESPACE = "http://java.net";
    private final @NonNull Map<Class<?>, Map<QualifiedName, WritableStyleableMapAccessor<?>>> nameToKeyMap = new ConcurrentHashMap();
    private final @NonNull Map<Class<?>, Map<QualifiedName, ReadOnlyStyleableMapAccessor<?>>> nameToReadableKeyMap = new ConcurrentHashMap();
    private final @NonNull ConcurrentHashMap<WritableStyleableMapAccessor<?>, QualifiedName> keyToNameMap = new ConcurrentHashMap();
    private final @NonNull ConcurrentHashMap<Class<? extends Figure>, Map<QualifiedName, List<WritableStyleableMapAccessor<Object>>>> figureToMetaMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends Figure>, Map<QualifiedName, List<ReadOnlyStyleableMapAccessor<Object>>>> figureToReadOnlyMetaMap = new ConcurrentHashMap();
    private final @NonNull Map<Object, Object> inlinedValues = new ConcurrentHashMap<Object, Object>();

    public boolean hasId(@NonNull Figure element, @NonNull String id) {
        return id.equals(element.getId());
    }

    public String getId(@NonNull Figure element) {
        return element.getId();
    }

    public boolean hasType(@NonNull Figure element, @Nullable String namespacePattern, @NonNull String type) {
        if (namespacePattern == null || "*".equals(namespacePattern)) {
            return type.equals(element.getTypeSelector());
        }
        if (JAVA_CLASS_NAMESPACE.equals(namespacePattern)) {
            return element.getClass().getSimpleName().equals(type);
        }
        return false;
    }

    public @Nullable QualifiedName getType(@NonNull Figure element) {
        return new QualifiedName(null, element.getTypeSelector());
    }

    public boolean hasStyleClass(@NonNull Figure element, @NonNull String clazz) {
        return element.getStyleClasses().contains((Object)clazz);
    }

    public @NonNull ReadOnlySet<String> getStyleClasses(@NonNull Figure element) {
        return element.getStyleClasses();
    }

    public @NonNull ReadOnlySet<String> getPseudoClasses(@NonNull Figure element) {
        return element.getPseudoClassStates();
    }

    private WritableStyleableMapAccessor<?> findKey(@NonNull Figure element, @Nullable String namespace, String attributeName) {
        Map mm = this.nameToKeyMap.computeIfAbsent(element.getClass(), k -> {
            LinkedHashMap<QualifiedName, WritableStyleableMapAccessor> m = new LinkedHashMap<QualifiedName, WritableStyleableMapAccessor>();
            for (MapAccessor kk : element.getSupportedKeys()) {
                if (!(kk instanceof WritableStyleableMapAccessor)) continue;
                WritableStyleableMapAccessor sk = (WritableStyleableMapAccessor)kk;
                m.put(new QualifiedName(sk.getCssNamespace(), String.valueOf(element.getClass()) + "$" + sk.getCssName()), sk);
                if (sk.getCssNamespace() == null) continue;
                m.put(new QualifiedName(null, String.valueOf(element.getClass()) + "$" + sk.getCssName()), sk);
            }
            return m;
        });
        return (WritableStyleableMapAccessor)mm.get(new QualifiedName(namespace, String.valueOf(element.getClass()) + "$" + attributeName));
    }

    private ReadOnlyStyleableMapAccessor<?> findReadableKey(@NonNull Figure element, @Nullable String namespace, String attributeName) {
        Map mm = this.nameToReadableKeyMap.computeIfAbsent(element.getClass(), k -> {
            LinkedHashMap<QualifiedName, ReadOnlyStyleableMapAccessor> m = new LinkedHashMap<QualifiedName, ReadOnlyStyleableMapAccessor>();
            for (MapAccessor kk : element.getSupportedKeys()) {
                if (!(kk instanceof ReadOnlyStyleableMapAccessor)) continue;
                ReadOnlyStyleableMapAccessor sk = (ReadOnlyStyleableMapAccessor)kk;
                m.put(new QualifiedName(sk.getCssNamespace(), String.valueOf(element.getClass()) + "$" + sk.getCssName()), sk);
                if (sk.getCssNamespace() != null) {
                    m.put(new QualifiedName(null, String.valueOf(element.getClass()) + "$" + sk.getCssName()), sk);
                }
                m.put(new QualifiedName("*", String.valueOf(element.getClass()) + "$" + sk.getCssName()), sk);
            }
            return m;
        });
        return (ReadOnlyStyleableMapAccessor)mm.get(new QualifiedName(namespace, String.valueOf(element.getClass()) + "$" + attributeName));
    }

    public boolean hasAttribute(@NonNull Figure element, @Nullable String namespace, @NonNull String attributeName) {
        return this.getReadableMetaMap(element).containsKey(new QualifiedName(namespace, attributeName));
    }

    public boolean attributeValueEquals(@NonNull Figure element, @Nullable String namespacePattern, @NonNull String attributeName, @NonNull String requestedValue) {
        String stringValue = this.getReadOnlyAttributeValueAsString(element, namespacePattern, attributeName);
        return Objects.equals(stringValue, requestedValue);
    }

    public boolean attributeValueStartsWith(@NonNull Figure element, @Nullable String namespacePattern, @NonNull String attributeName, @NonNull String substring) {
        String stringValue = this.getReadOnlyAttributeValueAsString(element, namespacePattern, attributeName);
        return stringValue != null && stringValue.startsWith(substring);
    }

    protected @Nullable ReadOnlyStyleableMapAccessor<Object> getReadableAttributeAccessor(@NonNull Figure element, @Nullable String namespace, @NonNull String attributeName) {
        ReadOnlyStyleableMapAccessor<?> k = this.findReadableKey(element, namespace, attributeName);
        return k;
    }

    protected @Nullable String getReadOnlyAttributeValueAsString(@NonNull Figure element, @Nullable String namespace, @NonNull String attributeName) {
        ReadOnlyStyleableMapAccessor<Object> k = this.getReadableAttributeAccessor(element, namespace, attributeName);
        if (k == null) {
            return null;
        }
        Object value = element.get((MapAccessor)k);
        Converter c = k.getCssConverter();
        String stringValue = c instanceof StringCssConverter ? (String)value : k.getCssConverter().toString(value);
        return stringValue;
    }

    public boolean attributeValueEndsWith(@NonNull Figure element, @Nullable String namespacePattern, @NonNull String attributeName, @NonNull String substring) {
        String stringValue = this.getReadOnlyAttributeValueAsString(element, namespacePattern, attributeName);
        return stringValue != null && stringValue.endsWith(substring);
    }

    public boolean attributeValueContains(@NonNull Figure element, @Nullable String namespacePattern, @NonNull String attributeName, @NonNull String substring) {
        String stringValue = this.getReadOnlyAttributeValueAsString(element, namespacePattern, attributeName);
        return stringValue != null && stringValue.contains(substring);
    }

    public boolean attributeValueContainsWord(@NonNull Figure element, @Nullable String namespacePattern, @NonNull String attributeName, @NonNull String word) {
        block4: {
            Object value;
            block3: {
                ReadOnlyStyleableMapAccessor<Object> k = this.getReadableAttributeAccessor(element, namespacePattern, attributeName);
                if (k == null) {
                    return false;
                }
                value = element.get((MapAccessor)k);
                if (!(value instanceof Collection)) break block3;
                Collection c = (Collection)value;
                for (Object o : c) {
                    if (o == null || !word.equals(o.toString())) continue;
                    return true;
                }
                break block4;
            }
            if (!(value instanceof String)) break block4;
            for (String s : ((String)value).split("\\s+")) {
                if (!s.equals(word)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPseudoClass(@NonNull Figure element, @NonNull String pseudoClass) {
        Set fs = (Set)this.additionalPseudoClassStatesProperty().get((Object)pseudoClass);
        if (fs != null && fs.contains(element)) {
            return true;
        }
        return element.getPseudoClassStates().contains((Object)pseudoClass);
    }

    public Figure getParent(@NonNull Figure element) {
        return element.getParent();
    }

    public @Nullable Figure getPreviousSibling(@NonNull Figure element) {
        if (element.getParent() == null) {
            return null;
        }
        int i = element.getParent().getChildren().indexOf((Object)element);
        return i == 0 ? null : (Figure)element.getParent().getChild(i - 1);
    }

    public @NonNull Set<QualifiedName> getAttributeNames(@NonNull Figure element) {
        return this.getWritableMetaMap(element).keySet();
    }

    public @NonNull Set<QualifiedName> getComposedAttributeNames(@NonNull Figure element) {
        HashSet<QualifiedName> attr = new HashSet<QualifiedName>();
        HashSet<WritableStyleableMapAccessor> attrk = new HashSet<WritableStyleableMapAccessor>();
        for (MapAccessor key : element.getSupportedKeys()) {
            if (!(key instanceof WritableStyleableMapAccessor)) continue;
            WritableStyleableMapAccessor sk = (WritableStyleableMapAccessor)key;
            attrk.add(sk);
        }
        for (MapAccessor key : element.getSupportedKeys()) {
            if (!(key instanceof CompositeMapAccessor)) continue;
            attrk.removeAll(((CompositeMapAccessor)key).getSubAccessors().asSet());
        }
        for (MapAccessor key : attrk) {
            attr.add(new QualifiedName(key.getCssNamespace(), key.getCssName()));
        }
        return attr;
    }

    public @NonNull Set<QualifiedName> getDecomposedAttributeNames(@NonNull Figure element) {
        HashSet<QualifiedName> attr = new HashSet<QualifiedName>();
        HashSet<WritableStyleableMapAccessor> attrk = new HashSet<WritableStyleableMapAccessor>();
        for (MapAccessor key : element.getSupportedKeys()) {
            if (!(key instanceof WritableStyleableMapAccessor)) continue;
            WritableStyleableMapAccessor sk = (WritableStyleableMapAccessor)key;
            if (key instanceof CompositeMapAccessor) continue;
            attrk.add(sk);
        }
        for (MapAccessor key : attrk) {
            attr.add(new QualifiedName(key.getCssNamespace(), key.getCssName()));
        }
        return attr;
    }

    public @Nullable String getAttributeAsString(@NonNull Figure element, @Nullable String namespacePattern, @NonNull String attributeName) {
        return this.getAttributeAsString(element, StyleOrigin.USER, namespacePattern, attributeName);
    }

    public @Nullable String getAttributeAsString(@NonNull Figure element, @Nullable StyleOrigin origin, @Nullable String namespacePattern, @NonNull String attributeName) {
        boolean isInitialValue;
        ReadOnlyStyleableMapAccessor<?> key = this.findReadableKey(element, namespacePattern, attributeName);
        if (key == null) {
            return null;
        }
        boolean bl = isInitialValue = origin != null && !element.containsMapAccessor(origin, (MapAccessor)key);
        if (isInitialValue && key instanceof CompositeMapAccessor) {
            for (MapAccessor subkey : ((CompositeMapAccessor)key).getSubAccessors()) {
                if (!element.containsMapAccessor(origin, subkey)) continue;
                isInitialValue = false;
                break;
            }
        }
        if (isInitialValue) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        Converter converter = key.getCssConverter();
        if (converter instanceof CssConverter) {
            CssConverter c = (CssConverter)converter;
            try {
                List cssTokens = c.toTokens(element.getStyled(origin, (MapAccessor)key), null);
                if (cssTokens.size() == 1) {
                    block8: for (CssToken t : cssTokens) {
                        switch (t.getType()) {
                            case -9: {
                                buf.append(t.getNumericValueNonNull());
                                continue block8;
                            }
                            case -10: {
                                buf.append(t.getNumericValueNonNull());
                                buf.append('%');
                                continue block8;
                            }
                            case -11: {
                                buf.append(t.getNumericValueNonNull());
                                if (t.getStringValue() == null) continue block8;
                                buf.append(t.getStringValue());
                                continue block8;
                            }
                        }
                        if (t.getStringValue() == null) continue;
                        buf.append(t.getStringValue());
                    }
                }
                for (CssToken t : cssTokens) {
                    buf.append(t.toString());
                }
            }
            catch (IOException e) {
                Logger.getLogger(FigureSelectorModel.class.getName()).log(Level.WARNING, "Could not produce tokens for key: " + String.valueOf(key) + " value: " + String.valueOf(element.getStyled(origin, (MapAccessor)key)), e);
            }
        } else {
            buf.append(converter.toString(element.getStyled(origin, (MapAccessor)key)));
        }
        return buf.toString();
    }

    public @Nullable List<CssToken> getAttribute(@NonNull Figure element, @Nullable StyleOrigin origin, @Nullable String namespacePattern, @NonNull String attributeName) {
        boolean isInitialValue;
        ReadOnlyStyleableMapAccessor<?> key = this.findReadableKey(element, namespacePattern, attributeName);
        if (key == null) {
            return null;
        }
        boolean bl = isInitialValue = origin != null && !element.containsMapAccessor(origin, (MapAccessor)key);
        if (isInitialValue && key instanceof CompositeMapAccessor) {
            for (MapAccessor subkey : ((CompositeMapAccessor)key).getSubAccessors()) {
                if (!element.containsMapAccessor(origin, subkey)) continue;
                isInitialValue = false;
                break;
            }
        }
        if (isInitialValue) {
            return null;
        }
        Converter converter = key.getCssConverter();
        if (converter instanceof CssConverter) {
            try {
                return ((CssConverter)converter).toTokens(element.getStyled(origin, (MapAccessor)key), null);
            }
            catch (IOException e) {
                Logger.getLogger(FigureSelectorModel.class.getName()).log(Level.WARNING, "Could not produce tokens for key: " + String.valueOf(key) + " value: " + String.valueOf(element.getStyled(origin, (MapAccessor)key)), e);
                return null;
            }
        }
        try {
            StreamCssTokenizer tt = new StreamCssTokenizer((CharSequence)converter.toString(element.getStyled(origin, (MapAccessor)key)), null);
            return tt.toTokenList();
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception", e);
        }
    }

    public @Nullable Converter<?> getConverter(@NonNull Figure element, @Nullable String namespace, String attributeName) {
        WritableStyleableMapAccessor<?> k = this.findKey(element, namespace, attributeName);
        return k == null ? null : k.getCssConverter();
    }

    public @Nullable WritableStyleableMapAccessor<?> getAccessor(@NonNull Figure element, @Nullable String namespace, String attributeName) {
        return this.findKey(element, namespace, attributeName);
    }

    protected Map<QualifiedName, List<WritableStyleableMapAccessor<Object>>> getWritableMetaMap(@NonNull Figure elem) {
        return this.figureToMetaMap.computeIfAbsent(elem.getClass(), klass -> {
            HashMap<QualifiedName, List> metaMap = new HashMap<QualifiedName, List>();
            Function<QualifiedName, List> arrayListSupplier = key -> new ArrayList();
            for (MapAccessor k : elem.getSupportedKeys()) {
                if (!(k instanceof WritableStyleableMapAccessor)) continue;
                WritableStyleableMapAccessor sk = (WritableStyleableMapAccessor)k;
                metaMap.computeIfAbsent(new QualifiedName(sk.getCssNamespace(), sk.getCssName()), arrayListSupplier).add(sk);
                if (sk.getCssNamespace() == null) continue;
                metaMap.computeIfAbsent(new QualifiedName(null, sk.getCssName()), arrayListSupplier).add(sk);
            }
            return metaMap;
        });
    }

    private Map<QualifiedName, List<ReadOnlyStyleableMapAccessor<Object>>> getReadableMetaMap(@NonNull Figure elem) {
        return this.figureToReadOnlyMetaMap.computeIfAbsent(elem.getClass(), klass -> {
            HashMap<QualifiedName, List> metaMap = new HashMap<QualifiedName, List>();
            Function<QualifiedName, List> arrayListSupplier = key -> new ArrayList();
            for (MapAccessor k : elem.getSupportedKeys()) {
                if (!(k instanceof ReadOnlyStyleableMapAccessor)) continue;
                ReadOnlyStyleableMapAccessor sk = (ReadOnlyStyleableMapAccessor)k;
                metaMap.computeIfAbsent(new QualifiedName(sk.getCssNamespace(), sk.getCssName()), arrayListSupplier).add(sk);
                if (sk.getCssNamespace() == null) continue;
                metaMap.computeIfAbsent(new QualifiedName(null, sk.getCssName()), arrayListSupplier).add(sk);
            }
            return metaMap;
        });
    }

    public void setAttribute(@NonNull Figure elem, @NonNull StyleOrigin origin, @Nullable String namespace, @NonNull String name, @Nullable ReadOnlyList<CssToken> value) {
        Map<QualifiedName, List<WritableStyleableMapAccessor<Object>>> metaMap = this.getWritableMetaMap(elem);
        List<WritableStyleableMapAccessor<Object>> ks = metaMap.get(new QualifiedName(namespace, name));
        if (ks != null) {
            for (WritableStyleableMapAccessor<Object> k : ks) {
                if (value == null || this.isInitialRevertOrUnset(value)) {
                    elem.remove(origin, (MapAccessor)k);
                    continue;
                }
                Converter converter = k.getCssConverter();
                try {
                    Object convertedValue = converter instanceof CssConverter ? ((CssConverter)converter).parse((CssTokenizer)new ListCssTokenizer(value), null) : converter.fromString((CharSequence)value.stream().map(CssToken::fromToken).collect(Collectors.joining()));
                    elem.setStyled(origin, (MapAccessor)k, this.intern(convertedValue));
                }
                catch (IOException | ParseException ex) {
                    Logger.getLogger(FigureSelectorModel.class.getName()).log(Level.WARNING, "error setting attribute " + name + " with tokens " + String.valueOf(value), ex);
                }
            }
        }
    }

    protected @Nullable Object intern(@Nullable Object convertedValue) {
        return convertedValue == null ? null : this.inlinedValues.computeIfAbsent(convertedValue, k -> convertedValue);
    }

    protected boolean isInitialRevertOrUnset(@Nullable ReadOnlyList<CssToken> value) {
        if (value != null) {
            boolean isInitial = false;
            block4: for (CssToken token : value) {
                switch (token.getType()) {
                    case -2: {
                        if (!"initial".equals(token.getStringValue()) && !"revert".equals(token.getStringValue()) && !"unset".equals(token.getStringValue())) continue block4;
                        isInitial = true;
                        continue block4;
                    }
                    case -16: {
                        continue block4;
                    }
                }
                isInitial = false;
                break;
            }
            return isInitial;
        }
        return false;
    }

    public void reset(@NonNull Figure elem) {
        elem.resetStyledValues();
    }
}

