/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.value;

import java.text.ParseException;
import java.util.Objects;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.converter.DoubleCssConverter;
import org.jhotdraw8.draw.css.converter.ColorCssConverter;
import org.jhotdraw8.draw.css.value.DefaultSystemColorConverter;
import org.jhotdraw8.draw.css.value.NamedCssColor;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.css.value.SystemColorConverter;
import org.jhotdraw8.draw.render.RenderContext;

public class CssColor
implements Paintable {
    private static final DoubleCssConverter num = new DoubleCssConverter(false);
    private final @NonNull String name;
    private final @NonNull Color color;
    private static final @NonNull ColorCssConverter converter = new ColorCssConverter();

    public CssColor(@NonNull Color color) {
        this(null, color);
    }

    public CssColor(@Nullable String name) {
        Color computedColor = (Color)DefaultSystemColorConverter.LIGHT_SYSTEM_COLORS.get((Object)name);
        if (computedColor == null && name != null) {
            try {
                computedColor = Color.web((String)name);
            }
            catch (IllegalArgumentException e) {
                computedColor = Color.BLACK;
            }
        } else {
            computedColor = Color.BLACK;
        }
        this.color = computedColor;
        this.name = name == null ? CssColor.toName(computedColor) : name;
    }

    public CssColor(@Nullable String name, @NonNull Color color) {
        this.name = name == null ? CssColor.toName(color) : name;
        this.color = color;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull Color getColor(SystemColorConverter converter) {
        return converter.convert(this);
    }

    public @NonNull Color getColor() {
        return this.color;
    }

    public @NonNull Color getPaint() {
        return this.color;
    }

    @Override
    public @Nullable Paint getPaint(RenderContext ctx) {
        return this.color;
    }

    public static @NonNull String toName(@NonNull Color c) {
        if (c.getOpacity() == 1.0) {
            int r = (int)Math.round(c.getRed() * 255.0);
            int g = (int)Math.round(c.getGreen() * 255.0);
            int b = (int)Math.round(c.getBlue() * 255.0);
            return String.format("#%02x%02x%02x", r, g, b);
        }
        if (c.equals((Object)Color.TRANSPARENT)) {
            return "transparent";
        }
        int r = (int)Math.round(c.getRed() * 255.0);
        int g = (int)Math.round(c.getGreen() * 255.0);
        int b = (int)Math.round(c.getBlue() * 255.0);
        int o = (int)Math.round(c.getOpacity() * 255.0);
        return String.format("#%02x%02x%02x%02x", r, g, b, o);
    }

    public int hashCode() {
        return Objects.hash(this.color, this.name);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!CssColor.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        CssColor other = (CssColor)obj;
        return Objects.equals(this.color, other.color) && Objects.equals(this.name, other.name);
    }

    public @NonNull String toString() {
        return "CssColor{" + this.getName() + "," + this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue() + "," + this.color.getOpacity() + "}";
    }

    public static @NonNull CssColor valueOf(@NonNull String value) {
        try {
            return (CssColor)converter.fromString(value);
        }
        catch (ParseException e) {
            return new NamedCssColor(value, Color.BLACK);
        }
    }

    public static @Nullable CssColor ofColor(@Nullable Color c) {
        return c == null ? null : new CssColor(c);
    }

    public static @Nullable Color toColor(@Nullable CssColor c) {
        return c == null ? null : c.getColor();
    }
}

