/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.value;

import java.util.Objects;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;

public class CssDimension2D {
    public static final CssDimension2D ZERO = new CssDimension2D();
    private final @NonNull CssSize width;
    private final @NonNull CssSize height;

    public CssDimension2D(@NonNull CssSize width, @NonNull CssSize height) {
        this.width = width;
        this.height = height;
    }

    public CssDimension2D(double width, double height, @NonNull String units) {
        this(CssSize.of((double)width, (String)units), CssSize.of((double)height, (String)units));
    }

    public CssDimension2D() {
        this(CssSize.ZERO, CssSize.ZERO);
    }

    public CssDimension2D(double width, double height) {
        this(width, height, "");
    }

    public CssDimension2D(@NonNull Point2D p) {
        this(p.getX(), p.getY());
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CssDimension2D other = (CssDimension2D)obj;
        if (!Objects.equals(this.width, other.width)) {
            return false;
        }
        return Objects.equals(this.height, other.height);
    }

    public @NonNull CssSize getWidth() {
        return this.width;
    }

    public @NonNull CssSize getHeight() {
        return this.height;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.width);
        hash = 89 * hash + Objects.hashCode(this.height);
        return hash;
    }

    public @NonNull String toString() {
        return "CssPoint2D{" + String.valueOf(this.width) + ", " + String.valueOf(this.height) + "}";
    }

    public @NonNull Dimension2D getConvertedValue() {
        return new Dimension2D(this.width.getConvertedValue(), this.height.getConvertedValue());
    }

    public @NonNull CssDimension2D subtract(@NonNull CssDimension2D that) {
        return new CssDimension2D(this.width.subtract(that.width), this.height.subtract(that.height));
    }

    public @NonNull CssDimension2D add(@NonNull CssDimension2D that) {
        return new CssDimension2D(this.width.add(that.width), this.height.add(that.height));
    }
}

