/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.value;

import java.util.Objects;
import javafx.geometry.Point3D;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;

public class CssPoint3D {
    public static final CssPoint3D ZERO = new CssPoint3D();
    private final CssSize x;
    private final CssSize y;
    private final CssSize z;

    public CssPoint3D(CssSize x, CssSize y, CssSize z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public CssPoint3D(double x, double y, double z, String units) {
        this(CssSize.of((double)x, (String)units), CssSize.of((double)y, (String)units), CssSize.of((double)z, (String)units));
    }

    public CssPoint3D() {
        this(CssSize.ZERO, CssSize.ZERO, CssSize.ZERO);
    }

    public CssPoint3D(double x, double y, double z) {
        this(x, y, z, null);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CssPoint3D other = (CssPoint3D)obj;
        if (!Objects.equals(this.x, other.x)) {
            return false;
        }
        if (!Objects.equals(this.y, other.y)) {
            return false;
        }
        return Objects.equals(this.z, other.z);
    }

    public CssSize getX() {
        return this.x;
    }

    public CssSize getY() {
        return this.y;
    }

    public CssSize getZ() {
        return this.z;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.x);
        hash = 89 * hash + Objects.hashCode(this.y);
        hash = 89 * hash + Objects.hashCode(this.z);
        return hash;
    }

    public @NonNull String toString() {
        return "CssPoint3D{" + String.valueOf(this.x) + ", " + String.valueOf(this.y) + ", " + String.valueOf(this.z) + "}";
    }

    public @NonNull Point3D getConvertedValue() {
        return new Point3D(this.x.getConvertedValue(), this.y.getConvertedValue(), this.z.getConvertedValue());
    }
}

