/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.value;

import java.util.Objects;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssPoint2D;

public class CssRectangle2D {
    public static final CssRectangle2D ZERO = new CssRectangle2D();
    private final CssSize width;
    private final CssSize height;
    private final CssSize y;
    private final CssSize x;

    public CssRectangle2D(@NonNull Bounds b) {
        this(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
    }

    public CssRectangle2D(@NonNull CssPoint2D a, @NonNull CssPoint2D b) {
        this(CssSize.min((CssSize)a.getX(), (CssSize)b.getX()), CssSize.min((CssSize)a.getY(), (CssSize)b.getY()), a.getX().subtract(b.getX()).abs(), a.getY().subtract(b.getY()).abs());
    }

    public CssRectangle2D(CssSize x, CssSize y, CssSize width, CssSize height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public CssRectangle2D(double x, double y, double width, double height, String units) {
        this(CssSize.of((double)x, (String)units), CssSize.of((double)y, (String)units), CssSize.of((double)width, (String)units), CssSize.of((double)height, (String)units));
    }

    public CssRectangle2D() {
        this(CssSize.ZERO, CssSize.ZERO, CssSize.ZERO, CssSize.ZERO);
    }

    public CssRectangle2D(double x, double y, double width, double height) {
        this(x, y, width, height, null);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CssRectangle2D other = (CssRectangle2D)obj;
        if (!Objects.equals(this.x, other.x)) {
            return false;
        }
        if (!Objects.equals(this.y, other.y)) {
            return false;
        }
        if (!Objects.equals(this.width, other.width)) {
            return false;
        }
        return Objects.equals(this.height, other.height);
    }

    public CssSize getWidth() {
        return this.width;
    }

    public CssSize getHeight() {
        return this.height;
    }

    public CssSize getMinY() {
        return this.y;
    }

    public CssSize getMinX() {
        return this.x;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.x);
        hash = 89 * hash + Objects.hashCode(this.y);
        hash = 89 * hash + Objects.hashCode(this.width);
        hash = 89 * hash + Objects.hashCode(this.height);
        return hash;
    }

    public @NonNull String toString() {
        return "CssRectangle2D{" + String.valueOf(this.x) + ", " + String.valueOf(this.y) + ", " + String.valueOf(this.width) + ", " + String.valueOf(this.height) + "}";
    }

    public @NonNull Rectangle2D getConvertedValue() {
        return new Rectangle2D(this.x.getConvertedValue(), this.y.getConvertedValue(), this.width.getConvertedValue(), this.height.getConvertedValue());
    }

    public @NonNull Bounds getConvertedBoundsValue() {
        return new BoundingBox(this.x.getConvertedValue(), this.y.getConvertedValue(), this.width.getConvertedValue(), this.height.getConvertedValue());
    }

    public @NonNull CssSize getMaxX() {
        return this.x.add(this.getWidth());
    }

    public @NonNull CssSize getMaxY() {
        return this.y.add(this.getHeight());
    }

    public @NonNull CssPoint2D getTopLeft() {
        return new CssPoint2D(this.x, this.y);
    }
}

