/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.value;

import javafx.scene.paint.Color;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.base.util.MathUtil;
import org.jhotdraw8.css.converter.DoubleCssConverter;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.SrgbaCssColor;

public class ShsbaCssColor
extends CssColor {
    private static final DoubleCssConverter num = new DoubleCssConverter(false);
    public static final SrgbaCssColor BLACK = new SrgbaCssColor(CssSize.ZERO, CssSize.ZERO, CssSize.ZERO, CssSize.ONE);
    private final @NonNull CssSize hue;
    private final @NonNull CssSize saturation;
    private final @NonNull CssSize brightness;
    private final @NonNull CssSize opacity;

    public ShsbaCssColor(@NonNull Color color) {
        super(ShsbaCssColor.toName(CssSize.of((double)color.getHue()), CssSize.of((double)color.getSaturation()), CssSize.of((double)color.getBrightness()), CssSize.of((double)color.getOpacity())), color);
        this.hue = CssSize.of((double)color.getHue());
        this.saturation = CssSize.of((double)color.getSaturation());
        this.brightness = CssSize.of((double)color.getBrightness());
        this.opacity = CssSize.of((double)color.getOpacity());
    }

    public ShsbaCssColor(@NonNull CssSize hue, @NonNull CssSize saturation, @NonNull CssSize brightness, @NonNull CssSize opacity) {
        super(ShsbaCssColor.toName(hue, saturation, brightness, opacity), Color.hsb((double)("%".equals(hue.getUnits()) ? hue.getValue() / 360.0 : hue.getValue()), (double)MathUtil.clamp((double)("%".equals(saturation.getUnits()) ? saturation.getValue() / 100.0 : saturation.getValue()), (double)0.0, (double)1.0), (double)MathUtil.clamp((double)("%".equals(brightness.getUnits()) ? brightness.getValue() / 100.0 : brightness.getValue()), (double)0.0, (double)1.0), (double)MathUtil.clamp((double)("%".equals(opacity.getUnits()) ? opacity.getValue() / 100.0 : opacity.getValue()), (double)0.0, (double)1.0)));
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = brightness;
        this.opacity = opacity;
    }

    private static String toName(@NonNull CssSize hue, @NonNull CssSize saturation, @NonNull CssSize brightness, @NonNull CssSize opacity) {
        StringBuilder buf = new StringBuilder(20);
        if ("%".equals(opacity.getUnits()) && opacity.getValue() == 100.0 || opacity.getValue() == 1.0) {
            buf.append("hsb(");
            buf.append(num.toString((Object)hue.getValue()));
            buf.append(hue.getUnits());
            buf.append(",");
            buf.append(num.toString((Object)saturation.getValue()));
            buf.append(saturation.getUnits());
            buf.append(",");
            buf.append(num.toString((Object)brightness.getValue()));
            buf.append(brightness.getUnits());
        } else {
            buf.append("hsba(");
            buf.append(num.toString((Object)hue.getValue()));
            buf.append(hue.getUnits());
            buf.append(",");
            buf.append(num.toString((Object)saturation.getValue()));
            buf.append(saturation.getUnits());
            buf.append(",");
            buf.append(num.toString((Object)brightness.getValue()));
            buf.append(brightness.getUnits());
            buf.append(",");
            buf.append(num.toString((Object)opacity.getValue()));
            buf.append(opacity.getUnits());
        }
        buf.append(')');
        return buf.toString();
    }
}

