/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.css.value;

import javafx.scene.paint.Color;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.base.converter.FloatConverter;
import org.jhotdraw8.base.util.MathUtil;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssColor;

public class SrgbaCssColor
extends CssColor {
    private static final FloatConverter num = new FloatConverter();
    public static final SrgbaCssColor BLACK = new SrgbaCssColor(CssSize.ZERO, CssSize.ZERO, CssSize.ZERO, CssSize.ONE);
    private final @NonNull CssSize red;
    private final @NonNull CssSize green;
    private final @NonNull CssSize blue;
    private final @NonNull CssSize opacity;

    public SrgbaCssColor(@NonNull Color color) {
        super(SrgbaCssColor.toName(CssSize.of((double)(color.getRed() * 100.0), (String)"%"), CssSize.of((double)(color.getGreen() * 100.0), (String)"%"), CssSize.of((double)(color.getBlue() * 100.0), (String)"%"), CssSize.of((double)color.getOpacity())), color);
        this.red = CssSize.of((double)(color.getRed() * 100.0), (String)"%");
        this.green = CssSize.of((double)(color.getGreen() * 100.0), (String)"%");
        this.blue = CssSize.of((double)(color.getBlue() * 100.0), (String)"%");
        this.opacity = CssSize.of((double)color.getOpacity());
    }

    public SrgbaCssColor(@NonNull CssSize red, @NonNull CssSize green, @NonNull CssSize blue, @NonNull CssSize opacity) {
        super(SrgbaCssColor.toName(red, green, blue, opacity), "%".equals(red.getUnits()) || "%".equals(green.getUnits()) || "%".equals(blue.getUnits()) ? Color.color((double)MathUtil.clamp((double)("%".equals(red.getUnits()) ? red.getValue() / 100.0 : red.getValue() / 255.0), (double)0.0, (double)1.0), (double)MathUtil.clamp((double)("%".equals(green.getUnits()) ? green.getValue() / 100.0 : green.getValue() / 255.0), (double)0.0, (double)1.0), (double)MathUtil.clamp((double)("%".equals(blue.getUnits()) ? blue.getValue() / 100.0 : blue.getValue() / 255.0), (double)0.0, (double)1.0), (double)MathUtil.clamp((double)("%".equals(opacity.getUnits()) ? opacity.getValue() / 100.0 : opacity.getValue()), (double)0.0, (double)1.0)) : Color.rgb((int)((int)Math.round(MathUtil.clamp((double)("%".equals(red.getUnits()) ? red.getValue() * 2.55 : red.getValue()), (double)0.0, (double)255.0))), (int)((int)Math.round(MathUtil.clamp((double)("%".equals(green.getUnits()) ? green.getValue() * 2.55 : green.getValue()), (double)0.0, (double)255.0))), (int)((int)Math.round(MathUtil.clamp((double)("%".equals(blue.getUnits()) ? blue.getValue() * 2.55 : blue.getValue()), (double)0.0, (double)255.0))), (double)MathUtil.clamp((double)("%".equals(opacity.getUnits()) ? opacity.getValue() / 100.0 : opacity.getValue()), (double)0.0, (double)1.0)));
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.opacity = opacity;
    }

    private static String toName(@NonNull CssSize red, @NonNull CssSize green, @NonNull CssSize blue, @NonNull CssSize opacity) {
        StringBuilder buf = new StringBuilder(20);
        if ("%".equals(opacity.getUnits()) && opacity.getValue() == 100.0 || opacity.getValue() == 1.0) {
            buf.append("rgb(");
            buf.append(num.toString((Object)Float.valueOf((float)red.getValue())));
            buf.append(red.getUnits());
            buf.append(",");
            buf.append(num.toString((Object)Float.valueOf((float)green.getValue())));
            buf.append(green.getUnits());
            buf.append(",");
            buf.append(num.toString((Object)Float.valueOf((float)blue.getValue())));
            buf.append(blue.getUnits());
        } else {
            buf.append("rgba(");
            buf.append(num.toString((Object)Float.valueOf((float)red.getValue())));
            buf.append(red.getUnits());
            buf.append(",");
            buf.append(num.toString((Object)Float.valueOf((float)green.getValue())));
            buf.append(green.getUnits());
            buf.append(",");
            buf.append(num.toString((Object)Float.valueOf((float)blue.getValue())));
            buf.append(blue.getUnits());
            buf.append(",");
            buf.append(num.toString((Object)Float.valueOf((float)opacity.getValue())));
            buf.append(opacity.getUnits());
        }
        buf.append(')');
        return buf.toString();
    }
}

