/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.shape.Path;
import javafx.scene.shape.Polyline;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.AbstractLineConnectionFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.handle.LineConnectorHandle;
import org.jhotdraw8.draw.handle.LineOutlineHandle;
import org.jhotdraw8.draw.handle.MoveHandle;
import org.jhotdraw8.draw.handle.PathIterableOutlineHandle;
import org.jhotdraw8.draw.handle.SelectionHandle;
import org.jhotdraw8.draw.locator.PointLocator;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.AwtShapes;
import org.jhotdraw8.geom.FXGeom;
import org.jhotdraw8.geom.FXPathElementsBuilder;
import org.jhotdraw8.geom.FXPreciseRotate;
import org.jhotdraw8.geom.PathBuilder;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.SvgPaths;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;

public abstract class AbstractElbowLineConnectionWithMarkersFigure
extends AbstractLineConnectionFigure
implements PathIterableFigure {
    private final Polyline path = new Polyline();

    public AbstractElbowLineConnectionWithMarkersFigure() {
        this(0.0, 0.0, 1.0, 1.0);
    }

    public AbstractElbowLineConnectionWithMarkersFigure(@NonNull Point2D start, @NonNull Point2D end) {
        this(start.getX(), start.getY(), end.getX(), end.getY());
    }

    public AbstractElbowLineConnectionWithMarkersFigure(double startX, double startY, double endX, double endY) {
        super(startX, startY, endX, endY);
    }

    @Override
    public @NonNull Node createNode(@NonNull RenderContext drawingView) {
        Group g = new Group();
        Polyline line = new Polyline();
        Path startMarker = new Path();
        Path endMarker = new Path();
        g.getChildren().addAll((Object[])new Node[]{line, startMarker, endMarker});
        return g;
    }

    @Override
    public void createHandles(@NonNull HandleType handleType, @NonNull List<Handle> list) {
        if (handleType == HandleType.SELECT) {
            list.add(new LineOutlineHandle(this));
        } else if (handleType == HandleType.MOVE) {
            list.add(new PathIterableOutlineHandle(this, true));
            if (this.get((MapAccessor)START_CONNECTOR) == null) {
                list.add(new MoveHandle(this, new PointLocator(START)));
            } else {
                list.add(new SelectionHandle(this, new PointLocator(START)));
            }
            if (this.get((MapAccessor)END_CONNECTOR) == null) {
                list.add(new MoveHandle(this, new PointLocator(END)));
            } else {
                list.add(new SelectionHandle(this, new PointLocator(END)));
            }
        } else if (handleType == HandleType.RESIZE) {
            list.add(new PathIterableOutlineHandle(this, true));
            list.add(new LineConnectorHandle(this, START, (MapAccessor<Connector>)START_CONNECTOR, (MapAccessor<Figure>)START_TARGET));
            list.add(new LineConnectorHandle(this, END, (MapAccessor<Connector>)END_CONNECTOR, (MapAccessor<Figure>)END_TARGET));
        } else if (handleType == HandleType.POINT) {
            list.add(new PathIterableOutlineHandle(this, true));
            list.add(new LineConnectorHandle(this, START, (MapAccessor<Connector>)START_CONNECTOR, (MapAccessor<Figure>)START_TARGET));
            list.add(new LineConnectorHandle(this, END, (MapAccessor<Connector>)END_CONNECTOR, (MapAccessor<Figure>)END_TARGET));
        } else if (handleType == HandleType.TRANSFORM) {
            list.add(new LineOutlineHandle(this));
        } else {
            super.createHandles(handleType, list);
        }
    }

    protected void updateLineNode(@NonNull RenderContext ctx, @NonNull Polyline node) {
    }

    protected void updateStartMarkerNode(@NonNull RenderContext ctx, @NonNull Path node) {
    }

    protected void updateEndMarkerNode(@NonNull RenderContext ctx, @NonNull Path node) {
    }

    @Override
    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Point2D p2;
        Point2D p3;
        Point2D p1;
        Point2D p0;
        Group g = (Group)node;
        Polyline lineNode = (Polyline)g.getChildren().get(0);
        Path startMarkerNode = (Path)g.getChildren().get(1);
        Path endMarkerNode = (Path)g.getChildren().get(2);
        Point2D start = ((CssPoint2D)this.getNonNull(START)).getConvertedValue();
        Point2D end = ((CssPoint2D)this.getNonNull(END)).getConvertedValue();
        double startInset = this.getStrokeCutStart(ctx);
        double endInset = this.getStrokeCutEnd(ctx);
        String startMarkerStr = this.getMarkerStartShape();
        ObservableList points = lineNode.getPoints();
        points.setAll((Collection)this.path.getPoints());
        int size = points.size();
        if (size > 4) {
            p0 = new Point2D(((Double)points.get(0)).doubleValue(), ((Double)points.get(1)).doubleValue());
            p1 = new Point2D(((Double)points.get(2)).doubleValue(), ((Double)points.get(3)).doubleValue());
            p3 = new Point2D(((Double)points.get(size - 2)).doubleValue(), ((Double)points.get(size - 1)).doubleValue());
            p2 = new Point2D(((Double)points.get(size - 4)).doubleValue(), ((Double)points.get(size - 3)).doubleValue());
        } else {
            p2 = p0 = new Point2D(((Double)points.get(0)).doubleValue(), ((Double)points.get(1)).doubleValue());
            p3 = p1 = new Point2D(((Double)points.get(2)).doubleValue(), ((Double)points.get(3)).doubleValue());
        }
        this.updateMarkerNode(ctx, g, startMarkerNode, new PointAndDerivative(p0.getX(), p0.getY(), p1.getX() - p0.getX(), p1.getY() - p0.getY()), startMarkerStr, this.getMarkerStartScaleFactor());
        String endMarkerStr = this.getMarkerEndShape();
        this.updateMarkerNode(ctx, g, endMarkerNode, new PointAndDerivative(p3.getX(), p3.getY(), p2.getX() - p3.getX(), p2.getY() - p3.getY()), endMarkerStr, this.getMarkerEndScaleFactor());
        Point2D dir = end.subtract(start).normalize();
        if (startInset != 0.0) {
            start = start.add(dir.multiply(startInset));
        }
        if (endInset != 0.0) {
            end = end.add(dir.multiply(-endInset));
        }
        this.updateLineNode(ctx, lineNode);
        this.updateStartMarkerNode(ctx, startMarkerNode);
        this.updateEndMarkerNode(ctx, endMarkerNode);
    }

    protected void updateMarkerNode(@NonNull RenderContext ctx, @NonNull Group group, @NonNull Path markerNode, @NonNull PointAndDerivative pd, @Nullable String svgString, double markerScaleFactor) {
        if (svgString != null) {
            try {
                ArrayList nodes = new ArrayList();
                FXPathElementsBuilder builder = new FXPathElementsBuilder(nodes);
                SvgPaths.svgStringToBuilder((String)svgString, (PathBuilder)builder);
                builder.build();
                markerNode.getElements().setAll(nodes);
            }
            catch (ParseException e) {
                Logger.getLogger(AbstractElbowLineConnectionWithMarkersFigure.class.getName()).warning("Illegal path: " + svgString);
            }
            double angle = Math.PI + pd.getAngle();
            double pdx = pd.x();
            double pdy = pd.y();
            markerNode.getTransforms().setAll((Object[])new Transform[]{new FXPreciseRotate(angle * 180.0 / Math.PI, pdx, pdy), new Scale(markerScaleFactor, markerScaleFactor, pdx, pdy), new Translate(pdx, pdy)});
            markerNode.setVisible(true);
        } else {
            markerNode.setVisible(false);
        }
    }

    @Override
    public @NonNull PathIterator getPathIterator(@NonNull RenderContext ctx, AffineTransform tx) {
        return this.path == null ? AwtShapes.emptyPathIterator() : AwtShapes.pathIteratorFromPointCoords((List)this.path.getPoints(), (boolean)false, (int)1, (AffineTransform)tx);
    }

    public abstract double getStrokeCutStart(RenderContext var1);

    public abstract double getStrokeCutEnd(RenderContext var1);

    public abstract @Nullable String getMarkerStartShape();

    public abstract double getMarkerStartScaleFactor();

    public abstract @Nullable String getMarkerEndShape();

    public abstract double getMarkerEndScaleFactor();

    public abstract @Nullable CssSize getElbowOffset();

    @Override
    public void layout(@NonNull RenderContext ctx) {
        IntersectionPointEx intersectionPointEx;
        Point2D start = ((CssPoint2D)this.getNonNull(START)).getConvertedValue();
        Point2D end = ((CssPoint2D)this.getNonNull(END)).getConvertedValue();
        Connector startConnector = (Connector)this.get((MapAccessor)START_CONNECTOR);
        Connector endConnector = (Connector)this.get((MapAccessor)END_CONNECTOR);
        Figure startTarget = (Figure)this.get((MapAccessor)START_TARGET);
        Figure endTarget = (Figure)this.get((MapAccessor)END_TARGET);
        CssSize elbowOffset1 = this.getElbowOffset();
        double elbowOffset = elbowOffset1 == null ? 0.0 : ((UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY)).convert(elbowOffset1, "");
        ObservableList points = this.path.getPoints();
        points.clear();
        if (startConnector != null && startTarget != null) {
            start = (Point2D)startConnector.getPointAndDerivativeInWorld(this, startTarget).getPoint(Point2D::new);
        }
        if (endConnector != null && endTarget != null) {
            end = (Point2D)endConnector.getPointAndDerivativeInWorld(this, endTarget).getPoint(Point2D::new);
        }
        Point2D endDerivative = null;
        if (startConnector != null && startTarget != null) {
            intersectionPointEx = startConnector.chopStart(ctx, this, startTarget, start, end);
            start = this.worldToParent(intersectionPointEx.getX(), intersectionPointEx.getY());
            this.set((MapAccessor)START, new CssPoint2D(start));
        }
        if (endConnector != null && endTarget != null) {
            intersectionPointEx = endConnector.chopStart(ctx, this, endTarget, end, start);
            endDerivative = new Point2D(intersectionPointEx.getDerivativeB().getX(), intersectionPointEx.getDerivativeB().getY());
            end = this.worldToParent(intersectionPointEx.getX(), intersectionPointEx.getY());
            this.set((MapAccessor)END, new CssPoint2D(end));
        }
        CssSize elbowOffsetSize = this.getElbowOffset();
        if (elbowOffset == 0.0 || endDerivative == null || FXGeom.squaredMagnitude(endDerivative) < 1.0E-7) {
            points.addAll((Object[])new Double[]{start.getX(), start.getY()});
            points.addAll((Object[])new Double[]{end.getX(), end.getY()});
        } else {
            Point2D endDerivativeNormalized = endDerivative.normalize();
            endDerivativeNormalized = Math.abs(endDerivativeNormalized.getX()) > Math.abs(endDerivativeNormalized.getY()) ? new Point2D(Math.signum(endDerivativeNormalized.getX()), 0.0) : new Point2D(0.0, Math.signum(endDerivativeNormalized.getY()));
            Point2D dir = new Point2D(endDerivative.getY(), -endDerivative.getX()).normalize();
            if ("%".equals(elbowOffsetSize.getUnits())) {
                elbowOffset = elbowOffsetSize.getConvertedValue() * Math.abs(dir.dotProduct(end.subtract(start)));
            }
            Point2D p2 = endDerivativeNormalized.multiply(elbowOffset);
            Point2D p1 = endDerivativeNormalized.multiply(Math.abs(dir.dotProduct(end.subtract(start))) - elbowOffset);
            points.addAll((Object[])new Double[]{start.getX(), start.getY()});
            points.addAll((Object[])new Double[]{start.getX() - p1.getY(), start.getY() + p1.getX()});
            points.addAll((Object[])new Double[]{end.getX() + p2.getY(), end.getY() - p2.getX()});
            points.addAll((Object[])new Double[]{end.getX(), end.getY()});
        }
    }
}

