/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLabelFigure;
import org.jhotdraw8.draw.figure.ConnectingFigure;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.LabelAutorotate;
import org.jhotdraw8.draw.figure.LabelConnectionFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.BoundsInLocalOutlineHandle;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.handle.LabelConnectorHandle;
import org.jhotdraw8.draw.handle.MoveHandle;
import org.jhotdraw8.draw.key.CssPoint2DStyleableMapAccessor;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.NonNullEnumStyleableKey;
import org.jhotdraw8.draw.locator.BoundsLocator;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.Angles;
import org.jhotdraw8.geom.FXGeom;
import org.jhotdraw8.geom.FXPreciseRotate;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.icollection.ChampSet;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;

public abstract class AbstractLabelConnectionFigure
extends AbstractLabelFigure
implements ConnectingFigure,
TransformableFigure,
LabelConnectionFigure {
    public static final @NonNull CssSizeStyleableKey LABELED_LOCATION_X = new CssSizeStyleableKey("labeledLocationX", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey LABELED_LOCATION_Y = new CssSizeStyleableKey("labeledLocationY", CssSize.ZERO);
    public static final @NonNull CssPoint2DStyleableMapAccessor LABELED_LOCATION = new CssPoint2DStyleableMapAccessor("labeledLocation", (NonNullMapAccessor<CssSize>)LABELED_LOCATION_X, (NonNullMapAccessor<CssSize>)LABELED_LOCATION_Y);
    public static final @NonNull CssSizeStyleableKey LABEL_OFFSET_Y = new CssSizeStyleableKey("labelOffsetY", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey LABEL_OFFSET_X = new CssSizeStyleableKey("labelOffsetX", CssSize.ZERO);
    public static final @NonNull CssPoint2DStyleableMapAccessor LABEL_OFFSET = new CssPoint2DStyleableMapAccessor("labelOffset", (NonNullMapAccessor<CssSize>)LABEL_OFFSET_X, (NonNullMapAccessor<CssSize>)LABEL_OFFSET_Y);
    public static final @NonNull NonNullEnumStyleableKey<LabelAutorotate> LABEL_AUTOROTATE = new NonNullEnumStyleableKey<LabelAutorotate>("labelAutorotate", LabelAutorotate.class, LabelAutorotate.OFF);
    public static final @NonNull CssSizeStyleableKey LABEL_TRANSLATE_Y = new CssSizeStyleableKey("labelTranslationY", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey LABEL_TRANSLATE_X = new CssSizeStyleableKey("labelTranslationX", CssSize.ZERO);
    public static final @NonNull CssPoint2DStyleableMapAccessor LABEL_TRANSLATE = new CssPoint2DStyleableMapAccessor("labelTranslation", (NonNullMapAccessor<CssSize>)LABEL_TRANSLATE_X, (NonNullMapAccessor<CssSize>)LABEL_TRANSLATE_Y);
    private final @NonNull ReadOnlyBooleanWrapper connected = new ReadOnlyBooleanWrapper();

    @Override
    protected <T> void onPropertyChanged(@NonNull Key<T> key, @Nullable T oldValue, @Nullable T newValue, boolean wasAdded, boolean wasRemoved) {
        if (key == LABEL_TARGET) {
            if (this.getDrawing() != null) {
                if (oldValue != null) {
                    ((Figure)oldValue).getLayoutObservers().remove(this);
                }
                if (newValue != null) {
                    ((Figure)newValue).getLayoutObservers().add(this);
                }
            }
            this.updateConnectedProperty();
        } else if (key == LABEL_CONNECTOR) {
            this.updateConnectedProperty();
        }
        super.onPropertyChanged(key, oldValue, newValue, wasAdded, wasRemoved);
    }

    @Override
    public void doAddedToDrawing(@NonNull Drawing drawing) {
        Figure labelTarget = (Figure)this.get((MapAccessor)LABEL_TARGET);
        if (labelTarget != null) {
            labelTarget.getLayoutObservers().add(this);
        }
    }

    @Override
    protected void doRemovedFromDrawing(@NonNull Drawing drawing) {
        Figure labelTarget = (Figure)this.get((MapAccessor)LABEL_TARGET);
        if (labelTarget != null) {
            labelTarget.getLayoutObservers().remove(this);
        }
    }

    private void updateConnectedProperty() {
        this.connected.set(this.get((MapAccessor)LABEL_CONNECTOR) != null && this.get((MapAccessor)LABEL_TARGET) != null);
    }

    public @NonNull ReadOnlyBooleanProperty connectedProperty() {
        return this.connected.getReadOnlyProperty();
    }

    @Override
    public void createHandles(@NonNull HandleType handleType, @NonNull List<Handle> list) {
        if (handleType == HandleType.MOVE) {
            list.add(new BoundsInLocalOutlineHandle(this));
            if (this.get((MapAccessor)LABEL_CONNECTOR) == null) {
                list.add(new MoveHandle(this, BoundsLocator.NORTH_EAST));
                list.add(new MoveHandle(this, BoundsLocator.NORTH_WEST));
                list.add(new MoveHandle(this, BoundsLocator.SOUTH_EAST));
                list.add(new MoveHandle(this, BoundsLocator.SOUTH_WEST));
            }
        } else if (handleType == HandleType.RESIZE) {
            list.add(new BoundsInLocalOutlineHandle(this));
            list.add(new LabelConnectorHandle(this, ORIGIN, LABELED_LOCATION, (MapAccessor<Connector>)LABEL_CONNECTOR, (MapAccessor<Figure>)LABEL_TARGET));
        } else if (handleType == HandleType.POINT) {
            list.add(new BoundsInLocalOutlineHandle(this));
            list.add(new LabelConnectorHandle(this, ORIGIN, LABELED_LOCATION, (MapAccessor<Connector>)LABEL_CONNECTOR, (MapAccessor<Figure>)LABEL_TARGET));
        } else {
            super.createHandles(handleType, list);
        }
    }

    @Override
    public @NonNull ReadOnlySet<Figure> getLayoutSubjects() {
        Figure labelTarget = (Figure)this.get((MapAccessor)LABEL_TARGET);
        return labelTarget == null ? ChampSet.of() : ChampSet.of((Object[])new Figure[]{labelTarget});
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public boolean isGroupReshapeableWith(@NonNull Set<Figure> others) {
        for (Figure f : this.getLayoutSubjects()) {
            if (!others.contains(f)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isLayoutable() {
        return true;
    }

    @Override
    public void layout(@NonNull RenderContext ctx) {
        this.layoutOrigin(ctx);
        super.layout(ctx);
    }

    protected void layoutOrigin(@NonNull RenderContext ctx) {
        Figure labelTarget = (Figure)this.get((MapAccessor)LABEL_TARGET);
        Connector labelConnector = (Connector)this.get((MapAccessor)LABEL_CONNECTOR);
        if (labelConnector == null || labelTarget == null) {
            return;
        }
        UnitConverter units = (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        PointAndDerivative pointAndDerivative = labelConnector.getPointAndDerivativeInWorld(this, labelTarget);
        Point2D labeledLoc = this.worldToParent((Point2D)pointAndDerivative.getPoint(Point2D::new));
        Point2D derivative = this.getWorldToParent().deltaTransform((Point2D)pointAndDerivative.getDerivative(Point2D::new)).normalize();
        Point2D perp = FXGeom.perp((Point2D)derivative);
        double labelOffsetX = ((CssSize)this.getStyledNonNull(LABEL_OFFSET_X)).getConvertedValue(units);
        double labelOffsetY = ((CssSize)this.getStyledNonNull(LABEL_OFFSET_Y)).getConvertedValue(units);
        Point2D origin = labeledLoc.add(perp.multiply(-labelOffsetY)).add(derivative.multiply(labelOffsetX));
        FXPreciseRotate rotate = null;
        boolean layoutTransforms = switch (this.getStyledNonNull(LABEL_AUTOROTATE)) {
            case LabelAutorotate.FULL -> {
                double theta = (Math.toDegrees(Angles.atan2((double)derivative.getY(), (double)derivative.getX())) + 360.0) % 360.0;
                rotate = new FXPreciseRotate(theta, origin.getX(), origin.getY());
                yield true;
            }
            case LabelAutorotate.HALF -> {
                double theta = (Math.toDegrees(Angles.atan2((double)derivative.getY(), (double)derivative.getX())) + 360.0) % 360.0;
                double halfTheta = theta <= 90.0 || theta > 270.0 ? theta : (theta + 180.0) % 360.0;
                rotate = new FXPreciseRotate(halfTheta, origin.getX(), origin.getY());
                yield true;
            }
            default -> false;
        };
        Point2D labelTranslation = this.getStyledNonNull(LABEL_TRANSLATE).getConvertedValue();
        origin = origin.add(labelTranslation);
        this.set((MapAccessor)ORIGIN, new CssPoint2D(origin));
        this.set((MapAccessor)LABELED_LOCATION, new CssPoint2D(labeledLoc));
        if (layoutTransforms) {
            ArrayList<FXPreciseRotate> transforms = new ArrayList<FXPreciseRotate>();
            if (!rotate.isIdentity()) {
                transforms.add(rotate);
            }
            this.setTransforms(transforms.toArray(new Transform[0]));
        }
    }

    @Override
    public void removeAllLayoutSubjects() {
        this.set((MapAccessor)LABEL_TARGET, null);
    }

    @Override
    public void removeLayoutSubject(@NonNull Figure subject) {
        if (subject == this.get((MapAccessor)LABEL_TARGET)) {
            this.set((MapAccessor)LABEL_TARGET, null);
        }
    }

    @Override
    public void updateGroupNode(@NonNull RenderContext ctx, @NonNull Group node) {
        super.updateGroupNode(ctx, node);
        this.applyTransformableFigureProperties(ctx, (Node)node);
    }

    @Override
    public void reshapeInLocal(@NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
        if (this.get((MapAccessor)LABEL_TARGET) == null) {
            super.reshapeInLocal(x, y, width, height);
            this.set((MapAccessor)LABELED_LOCATION, (CssPoint2D)this.getNonNull(ORIGIN));
            this.set((MapAccessor)LABEL_TRANSLATE, new CssPoint2D(0.0, 0.0));
        } else {
            CssRectangle2D bounds = this.getCssLayoutBounds();
            CssPoint2D oldValue = (CssPoint2D)this.getNonNull(LABEL_TRANSLATE);
            this.set((MapAccessor)LABEL_TRANSLATE, new CssPoint2D(x.subtract(bounds.getMinX()).add(oldValue.getX()), y.subtract(bounds.getMinY()).add(oldValue.getY())));
        }
    }

    @Override
    public void translateInLocal(@NonNull CssPoint2D delta) {
        if (this.get((MapAccessor)LABEL_TARGET) == null) {
            super.translateInLocal(delta);
            this.set((MapAccessor)LABELED_LOCATION, (CssPoint2D)this.getNonNull(ORIGIN));
            this.set((MapAccessor)LABEL_TRANSLATE, new CssPoint2D(0.0, 0.0));
        } else {
            CssPoint2D oldValue = (CssPoint2D)this.getNonNull(LABEL_TRANSLATE);
            this.set((MapAccessor)LABEL_TRANSLATE, oldValue.add(delta));
        }
    }

    public void setLabelConnection(@Nullable Figure target, @Nullable Connector connector) {
        this.set((MapAccessor)LABEL_CONNECTOR, connector);
        this.set((MapAccessor)LABEL_TARGET, target);
    }
}

