/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.text.ParseException;
import java.util.Collection;
import java.util.logging.Logger;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.shape.Path;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.RectangleFigure;
import org.jhotdraw8.draw.key.CssRectangle2DStyleableMapAccessor;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.NonNullBooleanStyleableKey;
import org.jhotdraw8.draw.key.NullableSvgPathStyleableKey;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.geom.AwtPathBuilder;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.geom.PathBuilder;
import org.jhotdraw8.geom.SvgPaths;

public abstract class AbstractRegionFigure
extends AbstractLeafFigure
implements PathIterableFigure {
    public static final @NonNull CssRectangle2DStyleableMapAccessor BOUNDS = RectangleFigure.BOUNDS;
    public static final @NonNull CssSizeStyleableKey HEIGHT = RectangleFigure.HEIGHT;
    public static final @NonNull NullableSvgPathStyleableKey SHAPE = new NullableSvgPathStyleableKey("shape", "M 0,0 h 1 v -1 h -1 Z");
    public static final @NonNull CssSizeStyleableKey WIDTH = RectangleFigure.WIDTH;
    public static final @NonNull CssSizeStyleableKey X = RectangleFigure.X;
    public static final @NonNull CssSizeStyleableKey Y = RectangleFigure.Y;
    public static final NonNullBooleanStyleableKey SHAPE_PRESERVE_RATIO_KEY = new NonNullBooleanStyleableKey("ShapePreserveRatio", false);
    private static final Logger LOGGER = Logger.getLogger(AbstractRegionFigure.class.getName());
    private transient Path2D.Double path;

    public AbstractRegionFigure() {
        this(0.0, 0.0, 1.0, 1.0);
    }

    public AbstractRegionFigure(double x, double y, double width, double height) {
        if (x != 0.0 || y != 0.0 || width != 0.0 || height != 0.0) {
            this.reshapeInLocal(x, y, width, height);
        }
    }

    public AbstractRegionFigure(@NonNull Rectangle2D rect) {
        this(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
    }

    @Override
    public @NonNull Node createNode(@NonNull RenderContext drawingView) {
        Path n = new Path();
        n.setManaged(false);
        return n;
    }

    @Override
    public @NonNull CssRectangle2D getCssLayoutBounds() {
        return (CssRectangle2D)this.getNonNull(BOUNDS);
    }

    @Override
    public @NonNull PathIterator getPathIterator(@NonNull RenderContext ctx, AffineTransform tx) {
        if (this.path == null) {
            this.path = new Path2D.Double();
        }
        return this.path.getPathIterator(tx);
    }

    @Override
    public void layout(@NonNull RenderContext ctx) {
        this.layoutPath();
    }

    @Override
    public void reshapeInLocal(@NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
        this.set((MapAccessor)X, width.getValue() < 0.0 ? x.add(width) : x);
        this.set((MapAccessor)Y, height.getValue() < 0.0 ? y.add(height) : y);
        this.set((MapAccessor)WIDTH, width.abs());
        this.set((MapAccessor)HEIGHT, height.abs());
    }

    protected void updatePathNode(RenderContext ctx, @NonNull Path path) {
        path.getElements().setAll((Collection)FXShapes.fxPathElementsFromAwt((PathIterator)this.path.getPathIterator(null)));
    }

    @Override
    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Path path = (Path)node;
        this.updatePathNode(ctx, path);
    }

    protected void layoutPath() {
        BoundingBox b;
        if (this.path == null) {
            this.path = new Path2D.Double();
        }
        this.path.reset();
        String pathstr = (String)this.getStyled((MapAccessor)SHAPE);
        if (pathstr == null || pathstr.isEmpty()) {
            return;
        }
        double width = ((CssSize)this.getStyledNonNull(WIDTH)).getConvertedValue();
        double height = ((CssSize)this.getStyledNonNull(HEIGHT)).getConvertedValue();
        double x = ((CssSize)this.getStyledNonNull(X)).getConvertedValue();
        double y = ((CssSize)this.getStyledNonNull(Y)).getConvertedValue();
        if (((Boolean)this.getStyledNonNull(SHAPE_PRESERVE_RATIO_KEY)).booleanValue()) {
            AwtPathBuilder awtPathBuilder = new AwtPathBuilder(this.path);
            try {
                SvgPaths.svgStringToBuilder((String)pathstr, (PathBuilder)awtPathBuilder);
                java.awt.geom.Rectangle2D bounds2D = awtPathBuilder.build().getBounds2D();
                double pathRatio = bounds2D.getHeight() / bounds2D.getWidth();
                double regionRatio = height / width;
                b = pathRatio < regionRatio ? new BoundingBox(x, y, width, pathRatio * width) : new BoundingBox(x, y, height / pathRatio, height);
                this.path.reset();
            }
            catch (ParseException e) {
                LOGGER.warning("Illegal SVG path: " + pathstr);
                return;
            }
        } else {
            b = new BoundingBox(x, y, width, height);
        }
        SvgPaths.svgStringReshapeToBuilder((String)pathstr, (Bounds)b, (PathBuilder)new AwtPathBuilder(this.path));
    }
}

