/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.shape.Line;
import javafx.scene.shape.Path;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.AbstractLineConnectionFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.handle.LineConnectorHandle;
import org.jhotdraw8.draw.handle.LineOutlineHandle;
import org.jhotdraw8.draw.handle.MoveHandle;
import org.jhotdraw8.draw.handle.SelectionHandle;
import org.jhotdraw8.draw.locator.PointLocator;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXPathElementsBuilder;
import org.jhotdraw8.geom.FXPreciseRotate;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.geom.PathBuilder;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.SvgPaths;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;

public abstract class AbstractStraightLineConnectionWithMarkersFigure
extends AbstractLineConnectionFigure
implements PathIterableFigure {
    public AbstractStraightLineConnectionWithMarkersFigure() {
        this(0.0, 0.0, 1.0, 1.0);
    }

    public AbstractStraightLineConnectionWithMarkersFigure(@NonNull Point2D start, @NonNull Point2D end) {
        this(start.getX(), start.getY(), end.getX(), end.getY());
    }

    public AbstractStraightLineConnectionWithMarkersFigure(double startX, double startY, double endX, double endY) {
        super(startX, startY, endX, endY);
    }

    @Override
    public void createHandles(@NonNull HandleType handleType, @NonNull List<Handle> list) {
        if (handleType == HandleType.SELECT) {
            list.add(new LineOutlineHandle(this));
        } else if (handleType == HandleType.MOVE) {
            list.add(new LineOutlineHandle(this));
            if (this.get((MapAccessor)START_CONNECTOR) == null) {
                list.add(new MoveHandle(this, new PointLocator(START)));
            } else {
                list.add(new SelectionHandle(this, new PointLocator(START)));
            }
            if (this.get((MapAccessor)END_CONNECTOR) == null) {
                list.add(new MoveHandle(this, new PointLocator(END)));
            } else {
                list.add(new SelectionHandle(this, new PointLocator(END)));
            }
        } else if (handleType == HandleType.RESIZE) {
            list.add(new LineOutlineHandle(this));
            list.add(new LineConnectorHandle(this, START, (MapAccessor<Connector>)START_CONNECTOR, (MapAccessor<Figure>)START_TARGET));
            list.add(new LineConnectorHandle(this, END, (MapAccessor<Connector>)END_CONNECTOR, (MapAccessor<Figure>)END_TARGET));
        } else if (handleType == HandleType.POINT) {
            list.add(new LineOutlineHandle(this));
            list.add(new LineConnectorHandle(this, START, (MapAccessor<Connector>)START_CONNECTOR, (MapAccessor<Figure>)START_TARGET));
            list.add(new LineConnectorHandle(this, END, (MapAccessor<Connector>)END_CONNECTOR, (MapAccessor<Figure>)END_TARGET));
        } else if (handleType == HandleType.TRANSFORM) {
            list.add(new LineOutlineHandle(this));
        } else {
            super.createHandles(handleType, list);
        }
    }

    @Override
    public @NonNull Node createNode(@NonNull RenderContext drawingView) {
        Group g = new Group();
        Line line = new Line();
        Path startMarker = new Path();
        Path endMarker = new Path();
        startMarker.setStroke(null);
        endMarker.setStroke(null);
        g.getChildren().addAll((Object[])new Node[]{line, startMarker, endMarker});
        return g;
    }

    public abstract double getMarkerCenterScaleFactor();

    public abstract @Nullable String getMarkerCenterShape();

    public abstract double getMarkerEndScaleFactor();

    public abstract @Nullable String getMarkerEndShape();

    public abstract double getMarkerStartScaleFactor();

    public abstract @Nullable String getMarkerStartShape();

    @Override
    public @NonNull PathIterator getPathIterator(@NonNull RenderContext ctx, AffineTransform tx) {
        return FXShapes.awtShapeFromFX((Shape)new Line(((CssSize)this.getNonNull((NonNullMapAccessor)START_X)).getConvertedValue(), ((CssSize)this.getNonNull((NonNullMapAccessor)START_Y)).getConvertedValue(), ((CssSize)this.getNonNull((NonNullMapAccessor)END_X)).getConvertedValue(), ((CssSize)this.getNonNull((NonNullMapAccessor)END_Y)).getConvertedValue())).getPathIterator(tx);
    }

    public abstract double getStrokeCutEnd(RenderContext var1);

    public abstract double getStrokeCutStart(RenderContext var1);

    @Override
    public void layout(@NonNull RenderContext ctx) {
        Point2D p;
        IntersectionPointEx chp;
        Point2D start = ((CssPoint2D)this.getNonNull(START)).getConvertedValue();
        Point2D end = ((CssPoint2D)this.getNonNull(END)).getConvertedValue();
        Connector startConnector = (Connector)this.get((MapAccessor)START_CONNECTOR);
        Connector endConnector = (Connector)this.get((MapAccessor)END_CONNECTOR);
        Figure startTarget = (Figure)this.get((MapAccessor)START_TARGET);
        Figure endTarget = (Figure)this.get((MapAccessor)END_TARGET);
        if (startConnector != null && startTarget != null) {
            start = (Point2D)startConnector.getPointAndDerivativeInWorld(this, startTarget).getPoint(Point2D::new);
        }
        if (endConnector != null && endTarget != null) {
            end = (Point2D)endConnector.getPointAndDerivativeInWorld(this, endTarget).getPoint(Point2D::new);
        }
        if (startConnector != null && startTarget != null) {
            chp = startConnector.chopStart(ctx, this, startTarget, start, end);
            p = this.worldToParent(chp.getX(), chp.getY());
            this.set((MapAccessor)START, new CssPoint2D(p));
        }
        if (endConnector != null && endTarget != null) {
            chp = endConnector.chopStart(ctx, this, endTarget, end, start);
            p = this.worldToParent(chp.getX(), chp.getY());
            this.set((MapAccessor)END, new CssPoint2D(p));
        }
    }

    @Override
    public void translateInLocal(@NonNull CssPoint2D t) {
        this.set((MapAccessor)START, ((CssPoint2D)this.getNonNull(START)).add(t));
        this.set((MapAccessor)END, ((CssPoint2D)this.getNonNull(END)).add(t));
    }

    protected void updateEndMarkerNode(RenderContext ctx, Path node) {
    }

    protected void updateLineNode(@NonNull RenderContext ctx, @NonNull Line node) {
    }

    protected void updateMarkerNode(RenderContext ctx, Group group, @NonNull Path markerNode, @NonNull PointAndDerivative pd, @Nullable String svgString, double markerScaleFactor) {
        if (svgString != null) {
            try {
                ArrayList nodes = new ArrayList();
                FXPathElementsBuilder builder = new FXPathElementsBuilder(nodes);
                SvgPaths.svgStringToBuilder((String)svgString, (PathBuilder)builder);
                builder.build();
                if (!nodes.equals(markerNode.getElements())) {
                    markerNode.getElements().setAll(nodes);
                }
            }
            catch (ParseException e) {
                Logger.getLogger(AbstractStraightLineConnectionWithMarkersFigure.class.getName()).warning("Illegal path: " + svgString);
            }
            double angle = Math.PI + pd.getAngle();
            double pdx = pd.x();
            double pdy = pd.y();
            markerNode.getTransforms().setAll((Object[])new Transform[]{new FXPreciseRotate(angle * 180.0 / Math.PI, pdx, pdy), new Scale(markerScaleFactor, markerScaleFactor, pdx, pdy), new Translate(pdx, pdy)});
            markerNode.setVisible(true);
        } else {
            markerNode.setVisible(false);
        }
    }

    @Override
    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Group g = (Group)node;
        Line lineNode = (Line)g.getChildren().get(0);
        Path startMarkerNode = (Path)g.getChildren().get(1);
        Path endMarkerNode = (Path)g.getChildren().get(2);
        Point2D start = ((CssPoint2D)this.getNonNull(START)).getConvertedValue();
        Point2D end = ((CssPoint2D)this.getNonNull(END)).getConvertedValue();
        double startInset = this.getStrokeCutStart(ctx);
        double endInset = this.getStrokeCutEnd(ctx);
        String startMarkerStr = this.getMarkerStartShape();
        String endMarkerStr = this.getMarkerEndShape();
        Point2D endMinusStart = end.subtract(start);
        Point2D startMinusEnd = start.subtract(end);
        Point2D dir = endMinusStart.normalize();
        if (startInset != 0.0) {
            start = start.add(dir.multiply(startInset));
        }
        if (endInset != 0.0) {
            end = end.add(dir.multiply(-endInset));
        }
        lineNode.setStartX(start.getX());
        lineNode.setStartY(start.getY());
        lineNode.setEndX(end.getX());
        lineNode.setEndY(end.getY());
        this.updateLineNode(ctx, lineNode);
        this.updateMarkerNode(ctx, g, startMarkerNode, new PointAndDerivative(start.getX(), start.getY(), endMinusStart.getX(), endMinusStart.getY()), startMarkerStr, this.getMarkerStartScaleFactor());
        this.updateMarkerNode(ctx, g, endMarkerNode, new PointAndDerivative(end.getX(), end.getY(), startMinusEnd.getX(), startMinusEnd.getY()), endMarkerStr, this.getMarkerEndScaleFactor());
        this.updateStartMarkerNode(ctx, startMarkerNode);
        this.updateEndMarkerNode(ctx, endMarkerNode);
    }

    protected void updateStartMarkerNode(RenderContext ctx, Path node) {
    }
}

