/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import javafx.css.StyleOrigin;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Path;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.connector.PathConnector;
import org.jhotdraw8.draw.css.converter.BezierPathCssConverter;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.CompositableFigure;
import org.jhotdraw8.draw.figure.ConnectableFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.FillRulableFigure;
import org.jhotdraw8.draw.figure.FillableFigure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.ResizableFigure;
import org.jhotdraw8.draw.figure.StrokableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.BezierControlPointEditHandle;
import org.jhotdraw8.draw.handle.BezierNodeEditHandle;
import org.jhotdraw8.draw.handle.BezierNodeTangentHandle;
import org.jhotdraw8.draw.handle.BezierPathEditHandle;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.handle.PathIterableOutlineHandle;
import org.jhotdraw8.draw.key.NonNullObjectStyleableKey;
import org.jhotdraw8.draw.locator.BoundsLocator;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.shape.BezierPath;

public class BezierPathFigure
extends AbstractLeafFigure
implements StrokableFigure,
FillableFigure,
FillRulableFigure,
TransformableFigure,
HideableFigure,
StyleableFigure,
LockableFigure,
CompositableFigure,
ResizableFigure,
ConnectableFigure,
PathIterableFigure {
    public static final NonNullObjectStyleableKey<BezierPath> PATH = new NonNullObjectStyleableKey<BezierPath>("path", (Type)((Object)BezierPath.class), (Converter<BezierPath>)new BezierPathCssConverter(false), BezierPath.of());
    public static final String TYPE_SELECTOR = "Bezier";

    public BezierPathFigure() {
        this.setStyled(StyleOrigin.USER_AGENT, (MapAccessor)FILL, null);
    }

    @Override
    public void createHandles(@NonNull HandleType handleType, @NonNull List<Handle> list) {
        if (handleType == HandleType.SELECT) {
            list.add(new PathIterableOutlineHandle(this, true));
        } else if (handleType == HandleType.POINT) {
            list.add(new BezierPathEditHandle(this, (MapAccessor<BezierPath>)PATH));
            BezierPath nodes = (BezierPath)this.get((MapAccessor)PATH);
            int n = nodes.size();
            for (int i = 0; i < n; ++i) {
                list.add(new BezierNodeTangentHandle(this, (MapAccessor<BezierPath>)PATH, i));
                list.add(new BezierNodeEditHandle(this, (MapAccessor<BezierPath>)PATH, i));
                list.add(new BezierControlPointEditHandle(this, (MapAccessor<BezierPath>)PATH, i, 2));
                list.add(new BezierControlPointEditHandle(this, (MapAccessor<BezierPath>)PATH, i, 4));
            }
        } else {
            super.createHandles(handleType, list);
        }
    }

    @Override
    public @NonNull Node createNode(@NonNull RenderContext ctx) {
        Path n = new Path();
        n.setManaged(false);
        return n;
    }

    @Override
    public @Nullable Connector findConnector(@NonNull Point2D p, Figure prototype, double tolerance) {
        return new PathConnector(new BoundsLocator(this.getLayoutBounds(), p));
    }

    @Override
    public @NonNull Bounds getLayoutBounds() {
        Rectangle2D b = ((BezierPath)this.getNonNull((NonNullMapAccessor)PATH)).getBounds2D();
        return new BoundingBox(b.getX(), b.getY(), b.getWidth(), b.getHeight());
    }

    @Override
    public @NonNull CssRectangle2D getCssLayoutBounds() {
        return new CssRectangle2D(this.getLayoutBounds());
    }

    public int getNodeCount() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public @NonNull PathIterator getPathIterator(@NonNull RenderContext ctx, AffineTransform tx) {
        return new BezierPath((Iterable)this.getStyledNonNull(PATH), (FillRule)this.getStyled((MapAccessor)FILL_RULE)).getPathIterator(tx);
    }

    public @NonNull Point2D getPoint(int index, int coord) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public @NonNull Point2D getPointOnPath(float f, int i) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public @NonNull String getTypeSelector() {
        return TYPE_SELECTOR;
    }

    @Override
    public void reshapeInLocal(@NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
        this.reshapeInLocal(x.getConvertedValue(), y.getConvertedValue(), width.getConvertedValue(), height.getConvertedValue());
    }

    @Override
    public void reshapeInLocal(double x, double y, double width, double height) {
        this.reshapeInLocal(FXTransforms.createReshapeTransform((Bounds)this.getLayoutBounds(), (double)x, (double)y, (double)width, (double)height));
    }

    @Override
    public void reshapeInLocal(@NonNull Transform transform) {
        BezierPath newP = (BezierPath)this.getNonNull((NonNullMapAccessor)PATH);
        int n = newP.size();
        for (int i = 0; i < n; ++i) {
            newP = newP.set(i, newP.get(i).transform(transform));
        }
        this.set((MapAccessor)PATH, newP);
    }

    @Override
    public void translateInLocal(@NonNull CssPoint2D t) {
        Translate transform = new Translate(t.getX().getConvertedValue(), t.getY().getConvertedValue());
        this.reshapeInLocal((Transform)transform);
    }

    @Override
    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Path pathNode = (Path)node;
        this.applyHideableFigureProperties(ctx, node);
        this.applyStyleableFigureProperties(ctx, node);
        this.applyStrokableFigureProperties(ctx, (Shape)pathNode);
        this.applyFillableFigureProperties(ctx, (Shape)pathNode);
        this.applyFillRulableFigureProperties(ctx, (Shape)pathNode);
        this.applyTransformableFigureProperties(ctx, node);
        this.applyCompositableFigureProperties(ctx, (Node)pathNode);
        pathNode.setFillRule((FillRule)this.getStyled((MapAccessor)FILL_RULE));
        List elements = FXShapes.fxPathElementsFromAwt((PathIterator)new BezierPath((Iterable)this.getStyledNonNull(PATH), (FillRule)this.getStyledNonNull(FILL_RULE)).getPathIterator(null));
        if (!pathNode.getElements().equals((Object)elements)) {
            pathNode.getElements().setAll((Collection)elements);
        }
    }
}

