/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.paint.Paint;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Path;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.css.value.CssTransforms;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.AbstractCompositeFigure;
import org.jhotdraw8.draw.figure.CompositableFigure;
import org.jhotdraw8.draw.figure.ConnectableFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.FillRulableFigure;
import org.jhotdraw8.draw.figure.FillableFigure;
import org.jhotdraw8.draw.figure.Grouping;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.ResizableFigure;
import org.jhotdraw8.draw.figure.StrokableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.key.NullableEnumStyleableKey;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.AwtPathBuilder;
import org.jhotdraw8.geom.AwtShapes;
import org.jhotdraw8.geom.ConcatenatedPathIterator;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.PathBuilder;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class CombinedPathFigure
extends AbstractCompositeFigure
implements StrokableFigure,
FillableFigure,
Grouping,
ResizableFigure,
TransformableFigure,
HideableFigure,
StyleableFigure,
LockableFigure,
CompositableFigure,
FillRulableFigure,
ConnectableFigure,
PathIterableFigure {
    public static final @NonNull NullableEnumStyleableKey<CagOperation> CAG_OPERATION = new NullableEnumStyleableKey<Object>("cag-operation", CagOperation.class, null);
    public static final String TYPE_SELECTOR = "CombinedPath";

    @Override
    public @NonNull Node createNode(@NonNull RenderContext drawingView) {
        Path n = new Path();
        n.setManaged(false);
        return n;
    }

    @Override
    public @Nullable Connector findConnector(@NonNull Point2D pointInLocal, Figure connectingFigure, double tolerance) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private PathIterator getStyledPathIteratorInParent(RenderContext ctx, @NonNull PathIterableFigure f, @Nullable AffineTransform tx) {
        double strokeWidth;
        Paint stroke;
        AffineTransform childTx = tx;
        Transform localToParent = f.getLocalToParent();
        AffineTransform ltpTx = FXTransforms.toAwt((Transform)localToParent);
        if (tx != null) {
            childTx = (AffineTransform)tx.clone();
            childTx.concatenate(ltpTx);
        } else {
            childTx = ltpTx;
        }
        PathIterator iter = f.getPathIterator(ctx, childTx);
        if (f instanceof StrokableFigure && (stroke = Paintable.getPaint((Paintable)f.getStyled((MapAccessor)STROKE), ctx)) != null && (strokeWidth = ((CssSize)f.getStyledNonNull((NonNullMapAccessor)STROKE_WIDTH)).getConvertedValue()) > 0.0) {
            BasicStroke basicStroke;
            ImmutableList dashArray = (ImmutableList)f.getStyledNonNull((NonNullMapAccessor)STROKE_DASH_ARRAY);
            if (!dashArray.isEmpty()) {
                double dashOffset = ((CssSize)f.getStyledNonNull((NonNullMapAccessor)STROKE_DASH_OFFSET)).getConvertedValue();
                float[] dash = new float[dashArray.size()];
                int n = dashArray.size();
                for (int i = 0; i < n; ++i) {
                    dash[i] = (float)((CssSize)dashArray.get(i)).getConvertedValue();
                }
                basicStroke = new BasicStroke((float)strokeWidth, FXShapes.awtCapFromFX((StrokeLineCap)((StrokeLineCap)f.getStyledNonNull((NonNullMapAccessor)STROKE_LINE_CAP))), FXShapes.awtJoinFromFX((StrokeLineJoin)((StrokeLineJoin)f.getStyledNonNull((NonNullMapAccessor)STROKE_LINE_JOIN))), (float)((CssSize)f.getStyledNonNull((NonNullMapAccessor)STROKE_MITER_LIMIT)).getConvertedValue(), dash, (float)dashOffset);
            } else {
                basicStroke = new BasicStroke((float)strokeWidth, FXShapes.awtCapFromFX((StrokeLineCap)((StrokeLineCap)f.getStyledNonNull((NonNullMapAccessor)STROKE_LINE_CAP))), FXShapes.awtJoinFromFX((StrokeLineJoin)((StrokeLineJoin)f.getStyledNonNull((NonNullMapAccessor)STROKE_LINE_JOIN))), (float)((CssSize)f.getStyledNonNull((NonNullMapAccessor)STROKE_MITER_LIMIT)).getConvertedValue());
            }
            iter = basicStroke.createStrokedShape(((AwtPathBuilder)AwtShapes.buildFromPathIterator((PathBuilder)new AwtPathBuilder(), (PathIterator)iter)).build()).getPathIterator(null);
        }
        return iter;
    }

    @Override
    public @NonNull PathIterator getPathIterator(@NonNull RenderContext ctx, AffineTransform tx) {
        CagOperation op = (CagOperation)((Object)this.getStyled((MapAccessor)CAG_OPERATION));
        if (op != null) {
            return this.getPathIteratorCAG(ctx, tx, op);
        }
        ArrayList<PathIterator> iterators = new ArrayList<PathIterator>();
        for (Figure child : this.getChildren()) {
            if (!(child instanceof PathIterableFigure)) continue;
            PathIterator childPathIterator = this.getStyledPathIteratorInParent(ctx, (PathIterableFigure)child, tx);
            iterators.add(childPathIterator);
        }
        return new ConcatenatedPathIterator((FillRule)this.getStyled((MapAccessor)FILL_RULE), iterators);
    }

    private @NonNull PathIterator getPathIteratorCAG(RenderContext ctx, AffineTransform tx, @NonNull CagOperation op) {
        Area area = null;
        boolean first = true;
        block5: for (Figure child : this.getChildren()) {
            if (!(child instanceof PathIterableFigure)) continue;
            PathIterator childPathIterator = this.getStyledPathIteratorInParent(ctx, (PathIterableFigure)child, tx);
            if (first) {
                first = false;
                area = new Area(((AwtPathBuilder)AwtShapes.buildFromPathIterator((PathBuilder)new AwtPathBuilder(), (PathIterator)childPathIterator)).build());
                continue;
            }
            Area area1 = new Area(((AwtPathBuilder)AwtShapes.buildFromPathIterator((PathBuilder)new AwtPathBuilder(), (PathIterator)childPathIterator)).build());
            switch (op.ordinal()) {
                default: {
                    area.add(area1);
                    continue block5;
                }
                case 2: {
                    area.intersect(area1);
                    continue block5;
                }
                case 1: {
                    area.subtract(area1);
                    continue block5;
                }
                case 3: 
            }
            area.exclusiveOr(area1);
        }
        Object iter = area != null ? area.getPathIterator(null) : new ConcatenatedPathIterator((FillRule)this.getStyled((MapAccessor)FILL_RULE), Collections.emptyList());
        return iter;
    }

    public @NonNull String getTypeSelector() {
        return TYPE_SELECTOR;
    }

    @Override
    public boolean isLayoutable() {
        return true;
    }

    @Override
    public void reshapeInLocal(Transform transform) {
        this.flattenTransforms();
        Transform localTransform = transform;
        for (Figure child : this.getChildren()) {
            child.reshapeInParent(localTransform);
        }
    }

    @Override
    public void reshapeInLocal(@NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
        this.flattenTransforms();
        Transform localTransform = CssTransforms.createReshapeTransform(this.getCssLayoutBounds(), x, y, width, height);
        for (Figure child : this.getChildren()) {
            child.reshapeInParent(localTransform);
        }
    }

    @Override
    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Path n = (Path)node;
        this.applyHideableFigureProperties(ctx, (Node)n);
        this.applyTransformableFigureProperties(ctx, (Node)n);
        this.applyStyleableFigureProperties(ctx, (Node)n);
        this.applyFillableFigureProperties(ctx, (Shape)n);
        this.applyFillRulableFigureProperties(ctx, (Shape)n);
        this.applyStrokableFigureProperties(ctx, (Shape)n);
        this.applyTransformableFigureProperties(ctx, (Node)n);
        this.applyCompositableFigureProperties(ctx, (Node)n);
        n.getElements().setAll((Collection)FXShapes.fxPathElementsFromAwt((PathIterator)this.getPathIterator(ctx, null)));
    }

    @Override
    public boolean isSuitableParent(@NonNull Figure newParent) {
        return true;
    }

    @Override
    public boolean isSuitableChild(@NonNull Figure newChild) {
        return newChild instanceof PathIterableFigure;
    }

    public static enum CagOperation {
        ADD,
        SUBTRACT,
        INTERSECT,
        XOR;

    }
}

