/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.util.Objects;
import javafx.css.StyleOrigin;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssDefaultableValue;
import org.jhotdraw8.css.value.CssDefaulting;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.key.DefaultableStyleableMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;

public interface DefaultableFigure
extends Figure {
    default public <T> @Nullable T getDefaultableStyled(@NonNull DefaultableStyleableMapAccessor<T> key) {
        return this.getDefaultableStyled(StyleOrigin.INLINE, key);
    }

    default public <T> @Nullable T getDefaultableStyled(@NonNull StyleOrigin origin, @NonNull DefaultableStyleableMapAccessor<T> key) {
        CssDefaultableValue dv = Objects.requireNonNull((CssDefaultableValue)this.getStyled(origin == StyleOrigin.INLINE ? null : origin, (MapAccessor)key));
        if (dv.getDefaulting() == null) {
            return (T)dv.getValue();
        }
        switch (dv.getDefaulting()) {
            case INITIAL: {
                return key.getInitialValue();
            }
            case INHERIT: {
                if (this.getParent() instanceof DefaultableFigure) {
                    return ((DefaultableFigure)this.getParent()).getDefaultableStyled(key);
                }
                return key.getInitialValue();
            }
            case UNSET: {
                CssDefaultableValue defaultValue = (CssDefaultableValue)key.getDefaultValue();
                if (defaultValue.getDefaulting() == CssDefaulting.INHERIT) {
                    if (this.getParent() instanceof DefaultableFigure) {
                        return ((DefaultableFigure)this.getParent()).getDefaultableStyled(key);
                    }
                    return key.getInitialValue();
                }
                return key.getInitialValue();
            }
            case REVERT: {
                return switch (origin) {
                    default -> throw new MatchException(null, null);
                    case StyleOrigin.USER_AGENT -> key.getInitialValue();
                    case StyleOrigin.USER -> this.getDefaultableStyled(StyleOrigin.USER_AGENT, key);
                    case StyleOrigin.AUTHOR -> this.getDefaultableStyled(StyleOrigin.USER, key);
                    case StyleOrigin.INLINE -> this.getDefaultableStyled(StyleOrigin.AUTHOR, key);
                };
            }
        }
        throw new UnsupportedOperationException("unsupported defaulting: " + String.valueOf(dv.getDefaulting()));
    }

    default public <T> @NonNull T getDefaultableStyledNonNull(@NonNull DefaultableStyleableMapAccessor<T> key) {
        return Objects.requireNonNull(this.getDefaultableStyled(key));
    }
}

