/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.lang.reflect.Type;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import javafx.scene.paint.Color;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.collection.primitive.IntArrayList;
import org.jhotdraw8.css.manager.StylesheetsManager;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.NullableCssColorStyleableKey;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.NonNullKey;
import org.jhotdraw8.fxcollection.typesafekey.NonNullListKey;
import org.jhotdraw8.fxcollection.typesafekey.NullableObjectKey;
import org.jhotdraw8.fxcollection.typesafekey.SimpleParameterizedType;
import org.jhotdraw8.graph.DirectedGraph;
import org.jhotdraw8.graph.IndexedDirectedGraph;
import org.jhotdraw8.graph.SimpleMutableDirectedGraph;
import org.jhotdraw8.graph.algo.TopologicalSortAlgo;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public interface Drawing
extends Figure {
    public static final @NonNull Key<URI> DOCUMENT_HOME = new NullableObjectKey("documentHome", URI.class, (Object)Paths.get(System.getProperty("user.home"), new String[0]).toUri());
    public static final @NonNull NonNullKey<ImmutableList<URI>> AUTHOR_STYLESHEETS = new NonNullListKey("authorStylesheets", (Type)new SimpleParameterizedType(ImmutableList.class, new Type[]{URI.class}));
    public static final @NonNull NonNullKey<ImmutableList<URI>> USER_AGENT_STYLESHEETS = new NonNullListKey("userAgentStylesheets", (Type)new SimpleParameterizedType(ImmutableList.class, new Type[]{URI.class}));
    public static final @NonNull NonNullKey<ImmutableList<String>> INLINE_STYLESHEETS = new NonNullListKey("inlineStylesheets", (Type)new SimpleParameterizedType(ImmutableList.class, new Type[]{String.class}));
    public static final @NonNull CssSizeStyleableKey WIDTH = new CssSizeStyleableKey("width", CssSize.of((double)640.0));
    public static final @NonNull CssSizeStyleableKey HEIGHT = new CssSizeStyleableKey("height", CssSize.of((double)480.0));
    public static final @NonNull NullableCssColorStyleableKey BACKGROUND = new NullableCssColorStyleableKey("background", new CssColor("white", Color.WHITE));
    public static final String TYPE_SELECTOR = "Drawing";

    default public @NonNull String getTypeSelector() {
        return TYPE_SELECTOR;
    }

    public @Nullable StylesheetsManager<Figure> getStyleManager();

    public void updateStyleManager();

    default public void layoutAll(@NonNull RenderContext ctx) {
        this.layoutAll(ctx, true);
    }

    default public void layoutAll(@NonNull RenderContext ctx, boolean parallel) {
        SimpleMutableDirectedGraph graphBuilder = new SimpleMutableDirectedGraph(1024, 1024, false);
        graphBuilder.setOrdered(false);
        for (Figure f : this.preorderIterable()) {
            graphBuilder.addVertex((Object)f);
            for (Figure subj : f.getLayoutSubjects()) {
                graphBuilder.addVertex((Object)subj);
                graphBuilder.addArrow((Object)subj, (Object)f, null);
            }
            Figure parent = f.getParent();
            if (parent == null) continue;
            graphBuilder.addArrow((Object)parent, (Object)f, null);
        }
        SimpleOrderedPair pair = new TopologicalSortAlgo().sortTopologicallyIntBatches((IndexedDirectedGraph)graphBuilder);
        int[] sorted = (int[])pair.first();
        if (((IntArrayList)pair.second()).isEmpty()) {
            for (Object i2 : (Figure)sorted) {
                ((Figure)graphBuilder.getVertex((int)i2)).layout(ctx);
            }
        } else {
            int start = 0;
            PrimitiveIterator.OfInt ofInt = ((IntArrayList)pair.second()).iterator();
            while (ofInt.hasNext()) {
                int end = (Integer)ofInt.next();
                StreamSupport.intStream(Spliterators.spliterator(sorted, start, end, 0), parallel).forEach(i -> ((Figure)graphBuilder.getVertex(i)).layout(ctx));
                start = end;
            }
        }
    }

    default public void updateAllCss(@NonNull RenderContext ctx) {
        StylesheetsManager<Figure> styleManager = this.getStyleManager();
        if (styleManager != null && styleManager.hasStylesheets()) {
            ArrayList list = new ArrayList();
            this.preorderIterable().forEach(list::add);
            styleManager.applyStylesheetsTo(list);
            for (Figure f : this.preorderIterable()) {
                f.invalidateTransforms();
            }
        }
    }

    default public @NonNull Iterable<Figure> layoutDependenciesIterable() {
        SimpleMutableDirectedGraph graphBuilder = new SimpleMutableDirectedGraph(1024, 1024, true);
        for (Figure f : this.postorderIterable()) {
            graphBuilder.addVertex((Object)f);
            for (Figure obs : f.getReadOnlyLayoutObservers()) {
                graphBuilder.addVertex((Object)obs);
                graphBuilder.addArrow((Object)f, (Object)obs, (Object)f);
            }
        }
        return new TopologicalSortAlgo().sortTopologically((DirectedGraph)graphBuilder);
    }
}

