/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.shape.StrokeType;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.CompositableFigure;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.FigurePropertyChangeEvent;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.Layer;
import org.jhotdraw8.draw.figure.ResizableFigure;
import org.jhotdraw8.draw.figure.StrokableFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.AnchorOutlineHandle;
import org.jhotdraw8.draw.handle.BoundsInLocalOutlineHandle;
import org.jhotdraw8.draw.handle.BoundsInTranslationOutlineHandle;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.handle.MoveHandle;
import org.jhotdraw8.draw.handle.ResizeHandleKit;
import org.jhotdraw8.draw.handle.RotateHandle;
import org.jhotdraw8.draw.handle.TransformHandleKit;
import org.jhotdraw8.draw.locator.BoundsLocator;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxbase.styleable.StyleableBean;
import org.jhotdraw8.fxbase.styleable.StyleablePropertyBean;
import org.jhotdraw8.fxbase.tree.TreeNode;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXRectangles;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.icollection.ChampSet;
import org.jhotdraw8.icollection.immutable.ImmutableSet;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;

public interface Figure
extends StyleablePropertyBean,
TreeNode<Figure> {
    public static final String JHOTDRAW_CSS_PREFIX = "";
    public static final String PARENT_PROPERTY = "parent";
    public static final Map<Class<?>, ImmutableSet<MapAccessor<?>>> declaredAndInheritedKeys = new ConcurrentHashMap();

    public static @NonNull Bounds bounds(@NonNull Collection<? extends Figure> selection) {
        double minx = Double.POSITIVE_INFINITY;
        double miny = Double.POSITIVE_INFINITY;
        double maxx = Double.NEGATIVE_INFINITY;
        double maxy = Double.NEGATIVE_INFINITY;
        for (Figure figure : selection) {
            Bounds fb = FXTransforms.transform((Transform)figure.getLocalToWorld(), (Bounds)figure.getLayoutBounds());
            double v = fb.getMaxX();
            if (v > maxx) {
                maxx = v;
            }
            if ((v = fb.getMaxY()) > maxy) {
                maxy = v;
            }
            if ((v = fb.getMinX()) < minx) {
                minx = v;
            }
            if (!((v = fb.getMinY()) < miny)) continue;
            miny = v;
        }
        return new BoundingBox(minx, miny, maxx - minx, maxy - miny);
    }

    public static ImmutableSet<MapAccessor<?>> getDeclaredMapAccessors(@NonNull Class<?> clazz, @NonNull ImmutableSet<MapAccessor<?>> keys) {
        try {
            for (Field f : clazz.getDeclaredFields()) {
                if (!Modifier.isStatic(f.getModifiers()) || !MapAccessor.class.isAssignableFrom(f.getType())) continue;
                MapAccessor k = (MapAccessor)f.get(null);
                if (k == null) {
                    throw new RuntimeException(String.valueOf(clazz) + " has null value for key: " + String.valueOf(f));
                }
                keys = keys.add((Object)k);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException(String.valueOf(clazz) + " has non-public keys", ex);
        }
        return keys;
    }

    public static void getDeclaredKeys(@NonNull Class<?> clazz, @NonNull Collection<Key<?>> keys) {
        try {
            for (Field f : clazz.getDeclaredFields()) {
                if (!Key.class.isAssignableFrom(f.getType())) continue;
                Key k = (Key)f.get(null);
                keys.add(k);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException("class can not read its own keys");
        }
    }

    public static ImmutableSet<MapAccessor<?>> getDeclaredAndInheritedMapAccessors(Class<?> clazz) {
        ImmutableSet<MapAccessor<?>> keys = declaredAndInheritedKeys.get(clazz);
        if (keys == null) {
            keys = ChampSet.of();
            ArrayDeque todo = new ArrayDeque();
            HashSet done = new HashSet();
            todo.add(clazz);
            while (!todo.isEmpty()) {
                Class c = (Class)todo.removeFirst();
                keys = Figure.getDeclaredMapAccessors(c, keys);
                if (c.getSuperclass() != null) {
                    todo.add(c.getSuperclass());
                }
                for (Class<?> i : c.getInterfaces()) {
                    if (!done.add(i)) continue;
                    todo.add(i);
                }
            }
            declaredAndInheritedKeys.put(clazz, keys);
        }
        return keys;
    }

    public static @Nullable Bounds visualBounds(@NonNull Collection<Figure> selection) {
        Bounds b = null;
        for (Figure f : selection) {
            Bounds fb;
            if (f instanceof Drawing) {
                fb = f.getLocalToWorld().transform(f.getLayoutBounds());
                if (b == null) {
                    b = fb;
                    continue;
                }
                b = FXRectangles.union((Bounds)b, (Bounds[])new Bounds[]{fb});
                continue;
            }
            for (Figure ff : f.preorderIterable()) {
                fb = ff.getLayoutBounds();
                double grow = 0.0;
                if (ff.get((MapAccessor)StrokableFigure.STROKE) != null) {
                    switch ((StrokeType)ff.getNonNull((NonNullMapAccessor)StrokableFigure.STROKE_TYPE)) {
                        case CENTERED: {
                            grow += ((CssSize)ff.getNonNull((NonNullMapAccessor)StrokableFigure.STROKE_WIDTH)).getConvertedValue() * 0.5;
                            break;
                        }
                        case INSIDE: {
                            break;
                        }
                        case OUTSIDE: {
                            grow += ((CssSize)ff.getNonNull((NonNullMapAccessor)StrokableFigure.STROKE_WIDTH)).getConvertedValue();
                        }
                    }
                }
                if (ff.get((MapAccessor)CompositableFigure.EFFECT) != null) {
                    grow += 10.0;
                }
                fb = FXRectangles.grow((Bounds)fb, (double)grow, (double)grow);
                fb = f.localToWorld(fb);
                if (b == null) {
                    b = fb;
                    continue;
                }
                b = FXRectangles.union((Bounds)b, (Bounds[])new Bounds[]{fb});
            }
        }
        return b;
    }

    default public boolean addChild(@NonNull Figure newChild) {
        return this.getChildren().add((Object)newChild);
    }

    default public void addedToDrawing(@NonNull Drawing drawing) {
    }

    default public void createHandles(@NonNull HandleType handleType, @NonNull List<Handle> list) {
        if (handleType == HandleType.SELECT) {
            list.add(new BoundsInLocalOutlineHandle(this));
        } else if (handleType == HandleType.ANCHOR) {
            list.add(new AnchorOutlineHandle(this));
        } else if (handleType == HandleType.LEAD) {
            list.add(new AnchorOutlineHandle(this));
        } else if (handleType == HandleType.MOVE) {
            list.add(new BoundsInLocalOutlineHandle(this));
            list.add(new MoveHandle(this, BoundsLocator.NORTH_EAST));
            list.add(new MoveHandle(this, BoundsLocator.NORTH_WEST));
            list.add(new MoveHandle(this, BoundsLocator.SOUTH_EAST));
            list.add(new MoveHandle(this, BoundsLocator.SOUTH_WEST));
        } else if (handleType == HandleType.POINT) {
            list.add(new BoundsInLocalOutlineHandle(this));
            ResizeHandleKit.addCornerResizeHandles(this, list);
        } else if (handleType == HandleType.RESIZE) {
            list.add(new BoundsInLocalOutlineHandle(this));
            if (this instanceof ResizableFigure) {
                ResizeHandleKit.addCornerResizeHandles(this, list);
                ResizeHandleKit.addEdgeResizeHandles(this, list);
            } else {
                list.add(new MoveHandle(this, BoundsLocator.NORTH_EAST));
                list.add(new MoveHandle(this, BoundsLocator.NORTH_WEST));
                list.add(new MoveHandle(this, BoundsLocator.SOUTH_EAST));
                list.add(new MoveHandle(this, BoundsLocator.SOUTH_WEST));
            }
        } else if (handleType == HandleType.TRANSFORM) {
            list.add(new BoundsInTranslationOutlineHandle(this));
            list.add(new BoundsInLocalOutlineHandle(this));
            Figure figure = this;
            if (figure instanceof TransformableFigure) {
                TransformableFigure tf = (TransformableFigure)figure;
                list.add(new RotateHandle(tf));
                TransformHandleKit.addTransformHandles(tf, list);
            }
        }
    }

    public @NonNull Node createNode(@NonNull RenderContext var1);

    default public void layoutSubjectChanged() {
    }

    default public <T> void propertyChanged(Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
    }

    default public void layoutObserverChanged() {
    }

    default public void disconnect() {
        for (Figure connectedFigure : (Figure[])this.getReadOnlyLayoutObservers().toArray((Object[])new Figure[0])) {
            connectedFigure.removeLayoutSubject(this);
        }
        this.removeAllLayoutSubjects();
    }

    default public <T> void firePropertyChangeEvent(Figure source, Key<T> key, @Nullable T oldValue, @Nullable T newValue, boolean wasAdded, boolean wasRemoved) {
        Figure parent;
        if (!wasRemoved && !wasAdded && Objects.equals(oldValue, newValue)) {
            return;
        }
        if (this.hasPropertyChangeListeners()) {
            this.firePropertyChangeEvent(new FigurePropertyChangeEvent(source, key, oldValue, newValue, wasAdded, wasRemoved));
        }
        if ((parent = this.getParent()) != null) {
            parent.firePropertyChangeEvent(source, key, oldValue, newValue, wasAdded, wasRemoved);
        }
    }

    default public void firePropertyChangeEvent(FigurePropertyChangeEvent event) {
        Figure parent;
        if (this.hasPropertyChangeListeners()) {
            for (Listener<FigurePropertyChangeEvent> l : this.getPropertyChangeListeners()) {
                l.handle((Object)event);
            }
        }
        if ((parent = this.getParent()) != null) {
            parent.firePropertyChangeEvent(event);
        }
    }

    default public @NonNull Bounds getLayoutBounds() {
        return this.getCssLayoutBounds().getConvertedBoundsValue();
    }

    default public @NonNull Bounds getVisualBounds() {
        return this.getLayoutBounds();
    }

    public @NonNull Bounds getBoundsInLocal();

    public @NonNull CssRectangle2D getCssLayoutBounds();

    default public @NonNull Bounds getLayoutBoundsInParent() {
        return FXTransforms.transformedBoundingBox((Transform)this.getLocalToParent(), (Bounds)this.getLayoutBounds());
    }

    default public @NonNull Bounds getBoundsInParent() {
        return FXTransforms.transformedBoundingBox((Transform)this.getLocalToParent(), (Bounds)this.getBoundsInLocal());
    }

    default public @NonNull Bounds getBoundsInWorld() {
        return FXTransforms.transformedBoundingBox((Transform)this.getLocalToWorld(), (Bounds)this.getBoundsInLocal());
    }

    default public @NonNull Bounds getLayoutBoundsInWorld() {
        return FXTransforms.transformedBoundingBox((Transform)this.getLocalToWorld(), (Bounds)this.getLayoutBounds());
    }

    default public @NonNull Bounds getVisualBoundsInWorld() {
        return FXTransforms.transformedBoundingBox((Transform)this.getLocalToWorld(), (Bounds)this.getVisualBounds());
    }

    default public @NonNull Point2D getCenterInLocal() {
        Bounds b = this.getLayoutBounds();
        return FXRectangles.center((Bounds)b);
    }

    default public @NonNull Point2D getCenterInParent() {
        Bounds b = this.getLayoutBoundsInParent();
        return FXRectangles.center((Bounds)b);
    }

    public @NonNull ObservableList<Figure> getChildren();

    public @NonNull Set<Figure> getLayoutObservers();

    public @NonNull ReadOnlySet<Figure> getReadOnlyLayoutObservers();

    default public @Nullable Drawing getDrawing() {
        return (Drawing)this.getAncestor(Drawing.class);
    }

    default public @Nullable Layer getLayer() {
        return (Layer)this.getAncestor(Layer.class);
    }

    public @NonNull Transform getLocalToParent();

    public @NonNull Transform getLocalToWorld();

    default public @Nullable Figure getParent() {
        return (Figure)this.parentProperty().get();
    }

    default public void setParent(@Nullable Figure newValue) {
        this.parentProperty().set((Object)newValue);
    }

    public @NonNull Transform getParentToLocal();

    public @NonNull Transform getParentToWorld();

    default public double getPreferredAspectRatio() {
        Bounds bounds = this.getLayoutBounds();
        return bounds.getHeight() == 0.0 || bounds.getWidth() == 0.0 ? 1.0 : bounds.getHeight() / bounds.getWidth();
    }

    public CopyOnWriteArrayList<Listener<FigurePropertyChangeEvent>> getPropertyChangeListeners();

    default public @NonNull ReadOnlySet<Figure> getLayoutSubjects() {
        return ChampSet.of();
    }

    default public @Nullable Figure getRoot() {
        Figure parent = this;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    default public @Nullable StyleableBean getStyleableParent() {
        return this.getParent();
    }

    default public @NonNull ImmutableSet<MapAccessor<?>> getSupportedKeys() {
        return Figure.getDeclaredAndInheritedMapAccessors(this.getClass());
    }

    public @NonNull Transform getWorldToLocal();

    public @NonNull Transform getWorldToParent();

    public boolean hasPropertyChangeListeners();

    public void invalidateTransforms();

    public boolean isAllowsChildren();

    default public boolean isDecomposable() {
        return true;
    }

    public boolean isDeletable();

    public boolean isEditable();

    default public boolean isGroupReshapeableWith(@NonNull Set<Figure> others) {
        return true;
    }

    default public boolean isLayoutable() {
        return false;
    }

    public boolean isSelectable();

    public boolean isSuitableParent(@NonNull Figure var1);

    public boolean isSuitableChild(@NonNull Figure var1);

    default public boolean isSupportedKey(MapAccessor<?> key) {
        return this.getSupportedKeys().contains(key);
    }

    default public boolean isEditableKey(MapAccessor<?> key) {
        return this.isSupportedKey(key);
    }

    default public boolean isShowing() {
        for (Figure node = this; node != null; node = node.getParent()) {
            if (((Boolean)node.getStyledNonNull((NonNullMapAccessor)HideableFigure.VISIBLE)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    default public boolean isVisible() {
        Figure node = this;
        return (Boolean)node.getStyledNonNull((NonNullMapAccessor)HideableFigure.VISIBLE);
    }

    default public void layout(@NonNull RenderContext ctx) {
    }

    default public void layoutChanged(@NonNull RenderContext ctx) {
        this.layout(ctx);
    }

    default public @NonNull Point2D localToWorld(@NonNull Point2D p) {
        return FXTransforms.transform((Transform)this.getLocalToWorld(), (Point2D)p);
    }

    default public @NonNull Bounds localToParent(@NonNull Bounds p) {
        return this.getLocalToParent().transform(p);
    }

    default public @NonNull Bounds localToWorld(@NonNull Bounds p) {
        return this.getLocalToWorld().transform(p);
    }

    public @NonNull ObjectProperty<Figure> parentProperty();

    default public void removeChild(Figure child) {
        this.getChildren().remove((Object)child);
    }

    public void removeAllLayoutSubjects();

    public void removeLayoutSubject(Figure var1);

    default public void removedFromDrawing(Drawing drawing) {
    }

    public void reshapeInLocal(Transform var1);

    default public void reshapeInLocal(@NonNull Bounds bounds) {
        this.reshapeInLocal(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
    }

    default public void reshapeInLocal(double x, double y, double width, double height) {
        this.reshapeInLocal(CssSize.of((double)x), CssSize.of((double)y), CssSize.of((double)width), CssSize.of((double)height));
    }

    public void reshapeInLocal(@NonNull CssSize var1, @NonNull CssSize var2, @NonNull CssSize var3, @NonNull CssSize var4);

    public void reshapeInParent(@NonNull Transform var1);

    default public void translateInParent(@NonNull CssPoint2D t) {
        if (FXTransforms.isIdentityOrNull((Transform)this.getParentToLocal())) {
            this.translateInLocal(t);
        } else {
            Point2D p = t.getConvertedValue();
            this.reshapeInParent((Transform)new Translate(p.getX(), p.getY()));
        }
    }

    default public void translateInLocal(@NonNull CssPoint2D t) {
        CssRectangle2D b = this.getCssLayoutBounds();
        this.reshapeInLocal(b.getMinX().add(t.getX()), b.getMinY().add(t.getY()), b.getWidth(), b.getHeight());
    }

    default public void stylesheetChanged(@NonNull RenderContext ctx) {
        this.updateCss(ctx);
    }

    public void transformInLocal(@NonNull Transform var1);

    public void transformInParent(@NonNull Transform var1);

    default public void transformChanged() {
        this.invalidateTransforms();
    }

    public void updateCss(RenderContext var1);

    public void updateNode(@NonNull RenderContext var1, @NonNull Node var2);

    default public @NonNull Point2D worldToLocal(@NonNull Point2D pointInWorld) {
        Transform wtl = this.getWorldToLocal();
        return FXTransforms.isIdentityOrNull((Transform)wtl) ? pointInWorld : FXTransforms.transform((Transform)wtl, (Point2D)pointInWorld);
    }

    default public @NonNull CssPoint2D worldToLocal(@NonNull CssPoint2D pointInWorld) {
        Transform wtl = this.getWorldToLocal();
        return FXTransforms.isIdentityOrNull((Transform)wtl) ? pointInWorld : new CssPoint2D(FXTransforms.transform((Transform)wtl, (Point2D)pointInWorld.getConvertedValue()));
    }

    default public @NonNull Point2D worldToParent(@NonNull Point2D pointInWorld) {
        Transform wtp = this.getWorldToParent();
        return FXTransforms.transform((Transform)wtp, (Point2D)pointInWorld);
    }

    default public @NonNull Point2D worldToParent(double x, double y) {
        Transform wtp = this.getWorldToParent();
        return FXTransforms.transform((Transform)wtp, (double)x, (double)y);
    }

    default public boolean isDeletWithLastLayoutSubject() {
        return true;
    }
}

