/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.shape.Line;
import javafx.scene.shape.Shape;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.AbstractLineConnectionFigure;
import org.jhotdraw8.draw.figure.CompositableFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.StrokableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.handle.LineConnectorHandle;
import org.jhotdraw8.draw.handle.LineOutlineHandle;
import org.jhotdraw8.draw.handle.MoveHandle;
import org.jhotdraw8.draw.handle.SelectionHandle;
import org.jhotdraw8.draw.locator.PointLocator;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;

public class LineConnectionFigure
extends AbstractLineConnectionFigure
implements StrokableFigure,
HideableFigure,
StyleableFigure,
LockableFigure,
CompositableFigure,
PathIterableFigure {
    public static final String TYPE_SELECTOR = "LineConnection";

    public LineConnectionFigure() {
        this(0.0, 0.0, 1.0, 1.0);
    }

    public LineConnectionFigure(@NonNull Point2D start, @NonNull Point2D end) {
        this(start.getX(), start.getY(), end.getX(), end.getY());
    }

    public LineConnectionFigure(double startX, double startY, double endX, double endY) {
        super(startX, startY, endX, endY);
    }

    @Override
    public void createHandles(@NonNull HandleType handleType, @NonNull List<Handle> list) {
        if (handleType == HandleType.SELECT) {
            list.add(new LineOutlineHandle(this));
        } else if (handleType == HandleType.MOVE) {
            list.add(new LineOutlineHandle(this));
            if (this.get((MapAccessor)START_CONNECTOR) == null) {
                list.add(new MoveHandle(this, new PointLocator(START)));
            } else {
                list.add(new SelectionHandle(this, new PointLocator(START)));
            }
            if (this.get((MapAccessor)END_CONNECTOR) == null) {
                list.add(new MoveHandle(this, new PointLocator(END)));
            } else {
                list.add(new SelectionHandle(this, new PointLocator(END)));
            }
        } else if (handleType == HandleType.RESIZE) {
            list.add(new LineOutlineHandle(this));
            list.add(new LineConnectorHandle(this, START, (MapAccessor<Connector>)START_CONNECTOR, (MapAccessor<Figure>)START_TARGET));
            list.add(new LineConnectorHandle(this, END, (MapAccessor<Connector>)END_CONNECTOR, (MapAccessor<Figure>)END_TARGET));
        } else if (handleType == HandleType.POINT) {
            list.add(new LineOutlineHandle(this));
            list.add(new LineConnectorHandle(this, START, (MapAccessor<Connector>)START_CONNECTOR, (MapAccessor<Figure>)START_TARGET));
            list.add(new LineConnectorHandle(this, END, (MapAccessor<Connector>)END_CONNECTOR, (MapAccessor<Figure>)END_TARGET));
        } else if (handleType == HandleType.TRANSFORM) {
            list.add(new LineOutlineHandle(this));
        } else {
            super.createHandles(handleType, list);
        }
    }

    @Override
    public @NonNull Node createNode(@NonNull RenderContext drawingView) {
        Line n = new Line();
        n.setManaged(false);
        return n;
    }

    public @NonNull String getTypeSelector() {
        return TYPE_SELECTOR;
    }

    @Override
    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Line lineNode = (Line)node;
        Point2D start = ((CssPoint2D)this.getNonNull(START)).getConvertedValue();
        lineNode.setStartX(start.getX());
        lineNode.setStartY(start.getY());
        Point2D end = ((CssPoint2D)this.getNonNull(END)).getConvertedValue();
        lineNode.setEndX(end.getX());
        lineNode.setEndY(end.getY());
        this.applyHideableFigureProperties(ctx, (Node)lineNode);
        this.applyStrokableFigureProperties(ctx, (Shape)lineNode);
        this.applyCompositableFigureProperties(ctx, node);
        this.applyStyleableFigureProperties(ctx, node);
    }

    @Override
    public @NonNull PathIterator getPathIterator(@NonNull RenderContext ctx, AffineTransform tx) {
        return FXShapes.awtShapeFromFX((Shape)new Line(((CssSize)this.getNonNull((NonNullMapAccessor)START_X)).getConvertedValue(), ((CssSize)this.getNonNull((NonNullMapAccessor)START_Y)).getConvertedValue(), ((CssSize)this.getNonNull((NonNullMapAccessor)END_X)).getConvertedValue(), ((CssSize)this.getNonNull((NonNullMapAccessor)END_Y)).getConvertedValue())).getPathIterator(tx);
    }

    @Override
    public void layout(@NonNull RenderContext ctx) {
        Point2D p;
        IntersectionPointEx chp;
        Point2D start = ((CssPoint2D)this.getNonNull(START)).getConvertedValue();
        Point2D end = ((CssPoint2D)this.getNonNull(END)).getConvertedValue();
        Connector startConnector = (Connector)this.get((MapAccessor)START_CONNECTOR);
        Connector endConnector = (Connector)this.get((MapAccessor)END_CONNECTOR);
        Figure startTarget = (Figure)this.get((MapAccessor)START_TARGET);
        Figure endTarget = (Figure)this.get((MapAccessor)END_TARGET);
        if (startConnector != null && startTarget != null) {
            start = (Point2D)startConnector.getPointAndDerivativeInWorld(this, startTarget).getPoint(Point2D::new);
        }
        if (endConnector != null && endTarget != null) {
            end = (Point2D)endConnector.getPointAndDerivativeInWorld(this, endTarget).getPoint(Point2D::new);
        }
        if (startConnector != null && startTarget != null) {
            chp = startConnector.chopStart(ctx, this, startTarget, start, end);
            p = this.worldToParent(chp.getX(), chp.getY());
            this.set((MapAccessor)START, new CssPoint2D(p));
        }
        if (endConnector != null && endTarget != null) {
            chp = endConnector.chopStart(ctx, this, endTarget, end, start);
            p = this.worldToParent(chp.getX(), chp.getY());
            this.set((MapAccessor)END, new CssPoint2D(p));
        }
    }
}

