/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.shape.Line;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.CompositableFigure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.StrokableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.handle.LineOutlineHandle;
import org.jhotdraw8.draw.handle.MoveHandle;
import org.jhotdraw8.draw.handle.PointHandle;
import org.jhotdraw8.draw.key.CssPoint2DStyleableMapAccessor;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.locator.PointLocator;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXTransforms;

public class LineFigure
extends AbstractLeafFigure
implements StrokableFigure,
HideableFigure,
StyleableFigure,
LockableFigure,
CompositableFigure,
TransformableFigure,
PathIterableFigure {
    public static final @NonNull String TYPE_SELECTOR = "Line";
    public static final @NonNull CssSizeStyleableKey START_X = new CssSizeStyleableKey("startX", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey START_Y = new CssSizeStyleableKey("startY", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey END_X = new CssSizeStyleableKey("endX", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey END_Y = new CssSizeStyleableKey("endY", CssSize.ZERO);
    public static final @NonNull CssPoint2DStyleableMapAccessor START = new CssPoint2DStyleableMapAccessor("start", (NonNullMapAccessor<CssSize>)START_X, (NonNullMapAccessor<CssSize>)START_Y);
    public static final @NonNull CssPoint2DStyleableMapAccessor END = new CssPoint2DStyleableMapAccessor("end", (NonNullMapAccessor<CssSize>)END_X, (NonNullMapAccessor<CssSize>)END_Y);

    public LineFigure() {
        this(0.0, 0.0, 1.0, 1.0);
    }

    public LineFigure(double startX, double startY, double endX, double endY) {
        this.set((MapAccessor)START, new CssPoint2D(startX, startY));
        this.set((MapAccessor)END, new CssPoint2D(endX, endY));
    }

    public LineFigure(@NonNull Point2D start, @NonNull Point2D end) {
        this.set((MapAccessor)START, new CssPoint2D(start));
        this.set((MapAccessor)END, new CssPoint2D(end));
    }

    @Override
    public @NonNull Bounds getLayoutBounds() {
        return this.getCssLayoutBounds().getConvertedBoundsValue();
    }

    @Override
    public @NonNull CssRectangle2D getCssLayoutBounds() {
        CssPoint2D start = (CssPoint2D)this.getNonNull(START);
        CssPoint2D end = (CssPoint2D)this.getNonNull(END);
        return new CssRectangle2D(start, end);
    }

    @Override
    public @NonNull PathIterator getPathIterator(@NonNull RenderContext ctx, AffineTransform tx) {
        Path2D.Double p = new Path2D.Double();
        p.moveTo(((CssSize)this.getNonNull((NonNullMapAccessor)START_X)).getConvertedValue(), ((CssSize)this.getNonNull((NonNullMapAccessor)START_Y)).getConvertedValue());
        p.lineTo(((CssSize)this.getNonNull((NonNullMapAccessor)END_X)).getConvertedValue(), ((CssSize)this.getNonNull((NonNullMapAccessor)END_Y)).getConvertedValue());
        return p.getPathIterator(tx);
    }

    @Override
    public void reshapeInLocal(@NonNull Transform transform) {
        this.set((MapAccessor)START, new CssPoint2D(FXTransforms.transform((Transform)transform, (Point2D)((CssPoint2D)this.getNonNull(START)).getConvertedValue())));
        this.set((MapAccessor)END, new CssPoint2D(FXTransforms.transform((Transform)transform, (Point2D)((CssPoint2D)this.getNonNull(END)).getConvertedValue())));
    }

    @Override
    public void reshapeInLocal(@NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
        this.reshapeInLocal(x.getConvertedValue(), y.getConvertedValue(), width.getConvertedValue(), height.getConvertedValue());
    }

    @Override
    public void reshapeInLocal(double x, double y, double width, double height) {
        this.reshapeInLocal(FXTransforms.createReshapeTransform((Bounds)this.getLayoutBounds(), (double)x, (double)y, (double)width, (double)height));
    }

    @Override
    public @NonNull Node createNode(@NonNull RenderContext drawingView) {
        Line n = new Line();
        n.setManaged(false);
        return n;
    }

    @Override
    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Line lineNode = (Line)node;
        this.applyHideableFigureProperties(ctx, node);
        this.applyStyleableFigureProperties(ctx, node);
        this.applyStrokableFigureProperties(ctx, (Shape)lineNode);
        this.applyTransformableFigureProperties(ctx, node);
        this.applyCompositableFigureProperties(ctx, (Node)lineNode);
        Point2D start = this.getStyledNonNull(START).getConvertedValue();
        lineNode.setStartX(start.getX());
        lineNode.setStartY(start.getY());
        Point2D end = this.getStyledNonNull(END).getConvertedValue();
        lineNode.setEndX(end.getX());
        lineNode.setEndY(end.getY());
        lineNode.applyCss();
    }

    @Override
    public void createHandles(@NonNull HandleType handleType, @NonNull List<Handle> list) {
        if (handleType == HandleType.SELECT) {
            list.add(new LineOutlineHandle(this));
        } else if (handleType == HandleType.MOVE) {
            list.add(new LineOutlineHandle(this));
            list.add(new MoveHandle(this, new PointLocator(START)));
            list.add(new MoveHandle(this, new PointLocator(END)));
        } else if (handleType == HandleType.RESIZE) {
            list.add(new LineOutlineHandle(this));
            list.add(new PointHandle(this, START));
            list.add(new PointHandle(this, END));
        } else if (handleType == HandleType.POINT) {
            list.add(new LineOutlineHandle(this));
            list.add(new PointHandle(this, START));
            list.add(new PointHandle(this, END));
        } else {
            super.createHandles(handleType, list);
        }
    }

    public @NonNull String getTypeSelector() {
        return TYPE_SELECTOR;
    }

    @Override
    public void layout(@NonNull RenderContext ctx) {
    }
}

