/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.figure;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Objects;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.converter.SizeCssConverter;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.NonNullEnumStyleableKey;
import org.jhotdraw8.draw.key.NonNullListStyleableKey;
import org.jhotdraw8.draw.key.NullablePaintableStyleableKey;
import org.jhotdraw8.draw.key.StrokeStyleableMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.SimpleParameterizedType;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public interface MarkerStrokableFigure
extends Figure {
    public static final @Nullable CssSizeStyleableKey MARKER_STROKE_DASH_OFFSET = new CssSizeStyleableKey("marker-stroke-dashoffset", CssSize.ZERO);
    public static final NonNullEnumStyleableKey<StrokeLineCap> MARKER_STROKE_LINE_CAP = new NonNullEnumStyleableKey<StrokeLineCap>("marker-stroke-linecap", StrokeLineCap.class, StrokeLineCap.BUTT);
    public static final NonNullEnumStyleableKey<StrokeLineJoin> MARKER_STROKE_LINE_JOIN = new NonNullEnumStyleableKey<StrokeLineJoin>("marker-stroke-linejoin", StrokeLineJoin.class, StrokeLineJoin.MITER);
    public static final CssSizeStyleableKey MARKER_STROKE_MITER_LIMIT = new CssSizeStyleableKey("marker-stroke-miterlimit", CssSize.of((double)4.0));
    public static final @NonNull NullablePaintableStyleableKey MARKER_STROKE = new NullablePaintableStyleableKey("marker-stroke", null);
    public static final NonNullEnumStyleableKey<StrokeType> MARKER_STROKE_TYPE = new NonNullEnumStyleableKey<StrokeType>("marker-stroke-type", StrokeType.class, StrokeType.CENTERED);
    public static final CssSizeStyleableKey MARKER_STROKE_WIDTH = new CssSizeStyleableKey("marker-stroke-width", CssSize.ONE);
    public static final NonNullListStyleableKey<CssSize> MARKER_STROKE_DASH_ARRAY = new NonNullListStyleableKey("marker-stroke-dasharray", (Type)new SimpleParameterizedType(ImmutableList.class, new Type[]{CssSize.class}), new SizeCssConverter(false), VectorList.of());
    public static final @Nullable StrokeStyleableMapAccessor STROKE_STYLE = new StrokeStyleableMapAccessor("marker-stroke-style", (MapAccessor<StrokeType>)MARKER_STROKE_TYPE, (MapAccessor<StrokeLineCap>)MARKER_STROKE_LINE_CAP, (MapAccessor<StrokeLineJoin>)MARKER_STROKE_LINE_JOIN, (MapAccessor<CssSize>)MARKER_STROKE_MITER_LIMIT, (MapAccessor<CssSize>)MARKER_STROKE_DASH_OFFSET, (MapAccessor<ImmutableList<CssSize>>)MARKER_STROKE_DASH_ARRAY);

    default public void applyMarkerStrokeCapAndJoinProperties(@NonNull Shape shape) {
        StrokeLineCap slp = (StrokeLineCap)this.getStyled((MapAccessor)MARKER_STROKE_LINE_CAP);
        if (shape.getStrokeLineCap() != slp) {
            shape.setStrokeLineCap(slp);
        }
        StrokeLineJoin slj = (StrokeLineJoin)this.getStyled((MapAccessor)MARKER_STROKE_LINE_JOIN);
        if (shape.getStrokeLineJoin() != slj) {
            shape.setStrokeLineJoin(slj);
        }
        double d = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)MARKER_STROKE_MITER_LIMIT)).getConvertedValue();
        if (shape.getStrokeMiterLimit() != d) {
            shape.setStrokeMiterLimit(d);
        }
    }

    default public void applyMarkerStrokeDashProperties(@NonNull Shape shape) {
        ImmutableList dashArray;
        double d = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)MARKER_STROKE_DASH_OFFSET)).getConvertedValue();
        if (shape.getStrokeDashOffset() != d) {
            shape.setStrokeDashOffset(d);
        }
        if ((dashArray = (ImmutableList)this.getStyledNonNull((NonNullMapAccessor)MARKER_STROKE_DASH_ARRAY)).isEmpty()) {
            shape.getStrokeDashArray().clear();
        } else {
            ArrayList<Double> list = new ArrayList<Double>(dashArray.size());
            for (CssSize sz : dashArray) {
                list.add(sz.getConvertedValue());
            }
            shape.getStrokeDashArray().setAll(list);
        }
    }

    default public void applyMarkerStrokeTypeProperties(@NonNull Shape shape) {
        StrokeType st = (StrokeType)this.getStyled((MapAccessor)MARKER_STROKE_TYPE);
        if (shape.getStrokeType() != st) {
            shape.setStrokeType(st);
        }
    }

    default public void applyMarkerStrokableFigureProperties(@NonNull Shape shape) {
        this.applyMarkerStrokeColorProperties(shape);
        this.applyMarkerStrokeWidthProperties(shape);
        this.applyMarkerStrokeCapAndJoinProperties(shape);
        this.applyMarkerStrokeTypeProperties(shape);
        this.applyMarkerStrokeDashProperties(shape);
    }

    default public void applyMarkerStrokeColorProperties(@NonNull Shape shape) {
        Paint p = Paintable.getPaint((Paintable)this.getStyled((MapAccessor)MARKER_STROKE));
        if (!Objects.equals(shape.getStroke(), p)) {
            shape.setStroke(p);
        }
    }

    default public void applyMarkerStrokeWidthProperties(@NonNull Shape shape) {
        double d = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)MARKER_STROKE_WIDTH)).getConvertedValue();
        if (shape.getStrokeWidth() != d) {
            shape.setStrokeWidth(d);
        }
    }
}

